/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.resources.bbmodel;

import com.google.gson.JsonObject;
import immersive_aircraft.resources.bbmodel.BBAnimationVariables;
import immersive_aircraft.resources.bbmodel.BBAnimator;
import java.util.Locale;
import org.joml.Vector3f;
import org.mariuszgromada.math.mxparser.Expression;
import org.mariuszgromada.math.mxparser.PrimitiveElement;

public class BBKeyframe {
    public final BBAnimator.Channel channel;
    public final float time;
    public final Expression[] expressions;

    public BBKeyframe(JsonObject element) {
        this.channel = BBAnimator.Channel.valueOf(element.getAsJsonPrimitive("channel").getAsString().toUpperCase(Locale.ROOT));
        this.time = element.getAsJsonPrimitive("time").getAsFloat();
        this.expressions = new Expression[3];
        JsonObject point = element.getAsJsonArray("data_points").get(0).getAsJsonObject();
        this.expressions[0] = BBKeyframe.getExpression(point, "x");
        this.expressions[1] = BBKeyframe.getExpression(point, "y");
        this.expressions[2] = BBKeyframe.getExpression(point, "z");
    }

    private static Expression getExpression(JsonObject point, String x) {
        return new Expression(point.getAsJsonPrimitive(x).getAsString().replace("variable.", "variable_"), (PrimitiveElement[])BBAnimationVariables.getArgumentArray());
    }

    public Vector3f evaluate() {
        return new Vector3f((float)this.expressions[0].calculate(), (float)this.expressions[1].calculate(), (float)this.expressions[2].calculate());
    }
}

