/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.network.handler;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.core.io.ParsingException;
import com.electronwill.nightconfig.toml.TomlFormat;
import com.google.common.base.Joiner;
import com.mrcrayfish.configured.Constants;
import com.mrcrayfish.configured.network.ForgeNetwork;
import com.mrcrayfish.configured.network.ServerPlayHelper;
import com.mrcrayfish.configured.network.message.play.MessageSyncForgeConfig;
import com.mrcrayfish.configured.util.ForgeConfigHelper;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.network.PacketDistributor;

public class ForgeServerPlayHandler {
    private static final Joiner DOT_JOINER = Joiner.on((String)".");

    public static void handleSyncServerConfigMessage(ServerPlayer player, MessageSyncForgeConfig message) {
        if (!ServerPlayHelper.canEditServerConfigs(player)) {
            return;
        }
        Constants.LOG.debug("Received server config sync from player: {}", (Object)player.m_7755_().getString());
        ModConfig config = ForgeConfigHelper.getForgeConfig(message.fileName());
        if (config == null) {
            Constants.LOG.warn("{} tried to update a config that doesn't exist!", (Object)player.m_7755_().getString());
            player.f_8906_.m_9942_((Component)Component.m_237115_((String)"configured.multiplayer.disconnect.bad_config_packet"));
            return;
        }
        if (config.getType() != ModConfig.Type.SERVER) {
            Constants.LOG.warn("{} tried to update a forge config that isn't a server type", (Object)player.m_7755_().getString());
            player.f_8906_.m_9942_((Component)Component.m_237115_((String)"configured.multiplayer.disconnect.bad_config_packet"));
            return;
        }
        ForgeConfigSpec spec = ForgeConfigHelper.findConfigSpec((UnmodifiableConfig)config.getSpec());
        if (spec == null) {
            Constants.LOG.warn("Unable to process server config update due to unknown spec for config: {}", (Object)message.fileName());
            player.f_8906_.m_9942_((Component)Component.m_237115_((String)"configured.multiplayer.disconnect.bad_config_packet"));
            return;
        }
        try {
            CommentedConfig data = (CommentedConfig)TomlFormat.instance().createParser().parse((InputStream)new ByteArrayInputStream(message.data()));
            int result = spec.correct(data, (action, path, incorrectValue, correctedValue) -> Constants.LOG.warn("Incorrect key {} was corrected from {} to its default, {}. {}", new Object[]{DOT_JOINER.join((Iterable)path), incorrectValue, correctedValue, incorrectValue == correctedValue ? "This seems to be an error." : ""}), (action, path, incorrectValue, correctedValue) -> Constants.LOG.debug("The comment on key {} does not match the spec. This may create a backup.", (Object)DOT_JOINER.join((Iterable)path)));
            if (result != 0) {
                Constants.LOG.info("Config data sent from {} needed to be corrected", (Object)player.m_7755_().getString());
            }
            config.getConfigData().putAll((UnmodifiableConfig)data);
        }
        catch (ParsingException e) {
            Constants.LOG.warn("{} sent malformed config data to the server", (Object)player.m_7755_().getString());
            player.f_8906_.m_9942_((Component)Component.m_237115_((String)"configured.multiplayer.disconnect.invalid_config_packet"));
            ServerPlayHelper.sendMessageToOperators((Component)Component.m_237110_((String)"configured.chat.malformed_config_data", (Object[])new Object[]{player.m_7755_(), Component.m_237113_((String)config.getFileName()).m_130940_(ChatFormatting.GRAY)}).m_130940_(ChatFormatting.RED), player);
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        Constants.LOG.debug("Successfully processed config update for '" + message.fileName() + "'");
        ForgeNetwork.getPlay().send(PacketDistributor.ALL.noArg(), (Object)new MessageSyncForgeConfig(message.fileName(), message.data()));
        ServerPlayHelper.sendMessageToOperators((Component)Component.m_237110_((String)"configured.chat.config_updated", (Object[])new Object[]{player.m_7755_(), config.getFileName()}).m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}), player);
    }
}

