/*
 * Decompiled with CFR 0.152.
 */
package toni.lib.networking;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import toni.lib.networking.codecs.StreamCodec;
import toni.lib.utils.VersionUtils;

public abstract class ToniPacket<TPacket extends ToniPacket> {
    public ResourceLocation Resource;
    public StreamCodec<FriendlyByteBuf, TPacket> CODEC;

    public ToniPacket(String modid, String path, StreamCodec<FriendlyByteBuf, TPacket> codec) {
        this.Resource = VersionUtils.resource(modid, path);
        this.CODEC = codec;
    }

    public void registerType() {
    }

    public void registerClientHandler(BiConsumer<TPacket, LocalPlayer> consumer) {
        ClientPlayNetworking.registerGlobalReceiver((ResourceLocation)this.Resource, (client, handler, buf, responseSender) -> {
            ToniPacket packet = (ToniPacket)this.CODEC.decode(buf);
            consumer.accept(packet, client.f_91074_);
        });
    }

    public void registerClientHandler(Consumer<TPacket> consumer) {
        ClientPlayNetworking.registerGlobalReceiver((ResourceLocation)this.Resource, (client, handler, buf, responseSender) -> {
            ToniPacket packet = (ToniPacket)this.CODEC.decode(buf);
            consumer.accept(packet);
        });
    }

    public void sendToAll(MinecraftServer server) {
        FriendlyByteBuf buf = PacketByteBufs.create();
        this.CODEC.encode(buf, this);
        for (ServerPlayer player : server.m_6846_().m_11314_()) {
            ServerPlayNetworking.send((ServerPlayer)player, (ResourceLocation)this.Resource, (FriendlyByteBuf)buf);
        }
    }

    public void send(ServerPlayer player) {
        FriendlyByteBuf buf = PacketByteBufs.create();
        this.CODEC.encode(buf, this);
        ServerPlayNetworking.send((ServerPlayer)player, (ResourceLocation)this.Resource, (FriendlyByteBuf)buf);
    }
}

