/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.worldGeneration.step;

import com.seibel.distanthorizons.core.logging.DhLogger;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.util.gridList.ArrayGridList;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Set;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.chunk.ChunkWrapper;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.worldGeneration.BatchGenerationEnvironment;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.worldGeneration.mimicObject.DhLitWorldGenRegion;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.worldGeneration.params.ThreadWorldGenParams;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.worldGeneration.step.AbstractWorldGenStep;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.levelgen.Heightmap;

public final class StepFeatures
extends AbstractWorldGenStep {
    private static final DhLogger LOGGER = new DhLoggerBuilder().build();
    public static final ChunkStatus STATUS = ChunkStatus.f_62322_;
    private final BatchGenerationEnvironment environment;

    public StepFeatures(BatchGenerationEnvironment batchGenerationEnvironment) {
        this.environment = batchGenerationEnvironment;
    }

    @Override
    public ChunkStatus getChunkStatus() {
        return STATUS;
    }

    @Override
    public void generateGroup(ThreadWorldGenParams tParams, DhLitWorldGenRegion worldGenRegion, ArrayGridList<ChunkWrapper> chunkWrappers) {
        ArrayList<ChunkWrapper> chunksToDo = this.getChunkWrappersToGenerate(chunkWrappers);
        for (ChunkWrapper chunkWrapper : chunksToDo) {
            ChunkAccess chunk = chunkWrapper.getChunk();
            try {
                if (worldGenRegion.m_7232_(chunkWrapper.getChunkPos().getX(), chunkWrapper.getChunkPos().getZ())) {
                    this.environment.globalParams.generator.m_213609_((WorldGenLevel)worldGenRegion, chunk, (StructureManager)tParams.structFeatManager.forWorldGenRegion(worldGenRegion));
                } else {
                    LOGGER.warn("Unable to generate features for chunk at pos [" + String.valueOf(chunkWrapper.getChunkPos()) + "], world gen region doesn't contain the chunk.", new Object[0]);
                }
                Heightmap.m_64256_((ChunkAccess)chunk, (Set)STATUS.m_62500_());
            }
            catch (ConcurrentModificationException concurrentModificationException) {
            }
            catch (Exception e) {
                LOGGER.warn("Unexpected issue when generating features for chunk at pos [" + String.valueOf(chunkWrapper.getChunkPos()) + "], error: [" + e.getMessage() + "].", e);
            }
        }
    }
}

