/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.minecraft;

import com.seibel.distanthorizons.core.logging.DhLogger;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhChunkPos;
import com.seibel.distanthorizons.core.pos.blockPos.DhBlockPos;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftClientWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftSharedWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IProfilerWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IClientLevelWrapper;
import java.io.File;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.minecraft.ProfilerWrapper;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.world.ClientLevelWrapper;
import net.minecraft.CrashReport;
import net.minecraft.client.CloudStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.ChunkPos;
import org.jetbrains.annotations.Nullable;

public class MinecraftClientWrapper
implements IMinecraftClientWrapper,
IMinecraftSharedWrapper {
    private static final DhLogger LOGGER = new DhLoggerBuilder().build();
    private static final Minecraft MINECRAFT = Minecraft.m_91087_();
    public static final MinecraftClientWrapper INSTANCE = new MinecraftClientWrapper();
    private ProfilerWrapper profilerWrapper;

    @Override
    public boolean hasSinglePlayerServer() {
        return MINECRAFT.m_91091_();
    }

    @Override
    public boolean clientConnectedToDedicatedServer() {
        return MINECRAFT.m_91089_() != null && !this.hasSinglePlayerServer();
    }

    @Override
    public boolean connectedToReplay() {
        return MINECRAFT.m_91089_() == null && !this.hasSinglePlayerServer();
    }

    @Override
    public String getCurrentServerName() {
        if (this.connectedToReplay()) {
            return "REPLAY";
        }
        ServerData server = MINECRAFT.m_91089_();
        return server != null ? server.f_105362_ : "NULL";
    }

    @Override
    public String getCurrentServerIp() {
        if (this.connectedToReplay()) {
            return "";
        }
        ServerData server = MINECRAFT.m_91089_();
        return server != null ? server.f_105363_ : "NA";
    }

    @Override
    public String getCurrentServerVersion() {
        ServerData server = MINECRAFT.m_91089_();
        return server != null ? server.f_105368_.getString() : "UNKOWN";
    }

    public LocalPlayer getPlayer() {
        return MinecraftClientWrapper.MINECRAFT.f_91074_;
    }

    @Override
    public boolean playerExists() {
        return MinecraftClientWrapper.MINECRAFT.f_91074_ != null;
    }

    @Override
    public DhBlockPos getPlayerBlockPos() {
        LocalPlayer player = this.getPlayer();
        if (player == null) {
            return new DhBlockPos(0, 0, 0);
        }
        BlockPos playerPos = player.m_20183_();
        return new DhBlockPos(playerPos.m_123341_(), playerPos.m_123342_(), playerPos.m_123343_());
    }

    @Override
    public DhChunkPos getPlayerChunkPos() {
        LocalPlayer player = this.getPlayer();
        if (player == null) {
            return new DhChunkPos(0, 0);
        }
        ChunkPos playerPos = player.m_146902_();
        return new DhChunkPos(playerPos.f_45578_, playerPos.f_45579_);
    }

    @Override
    @Nullable
    public IClientLevelWrapper getWrappedClientLevel() {
        return this.getWrappedClientLevel(false);
    }

    @Override
    @Nullable
    public IClientLevelWrapper getWrappedClientLevel(boolean bypassLevelKeyManager) {
        ClientLevel level = MinecraftClientWrapper.MINECRAFT.f_91073_;
        if (level == null) {
            return null;
        }
        return ClientLevelWrapper.getWrapper(level, bypassLevelKeyManager);
    }

    @Override
    public void sendChatMessage(String string) {
        LocalPlayer player = this.getPlayer();
        if (player == null) {
            return;
        }
        player.m_5661_((Component)Component.m_237115_((String)string), false);
    }

    @Override
    public void sendOverlayMessage(String string) {
        LocalPlayer player = this.getPlayer();
        if (player == null) {
            return;
        }
        player.m_5661_((Component)Component.m_237115_((String)string), true);
    }

    @Override
    public void disableVanillaClouds() {
        MinecraftClientWrapper.MINECRAFT.f_91066_.m_232050_().m_231514_((Object)CloudStatus.OFF);
    }

    @Override
    public void disableVanillaChunkFadeIn() {
    }

    @Override
    public IProfilerWrapper getProfiler() {
        ProfilerFiller profiler = MINECRAFT.m_91307_();
        if (this.profilerWrapper == null) {
            this.profilerWrapper = new ProfilerWrapper(profiler);
        } else if (profiler != this.profilerWrapper.profiler) {
            this.profilerWrapper.profiler = profiler;
        }
        return this.profilerWrapper;
    }

    @Override
    public void crashMinecraft(String errorMessage, Throwable exception) {
        LOGGER.fatal("Distant Horizons had the following error: [" + errorMessage + "]. Crashing Minecraft...", exception);
        CrashReport report = new CrashReport(errorMessage, exception);
        Minecraft.m_91332_((CrashReport)report);
    }

    @Override
    public Object getOptionsObject() {
        return MinecraftClientWrapper.MINECRAFT.f_91066_;
    }

    @Override
    public boolean isDedicatedServer() {
        return false;
    }

    @Override
    public File getInstallationDirectory() {
        return MinecraftClientWrapper.MINECRAFT.f_91069_;
    }

    @Override
    public int getPlayerCount() {
        if (MINECRAFT.m_91092_() == null) {
            return 1;
        }
        return MINECRAFT.m_91092_().m_7416_();
    }
}

