/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.forge.com.seibel.distanthorizons.common;

import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.logging.DhLogger;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.network.event.internal.IncompatibleMessageInternalEvent;
import com.seibel.distanthorizons.core.network.event.internal.ProtocolErrorInternalEvent;
import com.seibel.distanthorizons.core.network.messages.AbstractNetworkMessage;
import com.seibel.distanthorizons.core.network.messages.MessageRegistry;
import com.seibel.distanthorizons.core.network.messages.base.CloseReasonMessage;
import com.seibel.distanthorizons.core.wrapperInterfaces.misc.IPluginPacketSender;
import com.seibel.distanthorizons.core.wrapperInterfaces.misc.IServerPlayerWrapper;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.io.IOException;
import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public abstract class AbstractPluginPacketSender
implements IPluginPacketSender {
    private static final DhLogger LOGGER = new DhLoggerBuilder().fileLevelConfig(Config.Common.Logging.logNetworkEventToFile).build();
    public static final ResourceLocation WRAPPER_PACKET_RESOURCE = new ResourceLocation("distant_horizons", "message");
    private final boolean forgeByteInProtocolVersion;

    public AbstractPluginPacketSender() {
        this(false);
    }

    public AbstractPluginPacketSender(boolean forgeByteInProtocolVersion) {
        this.forgeByteInProtocolVersion = forgeByteInProtocolVersion;
    }

    @Override
    public final void sendToClient(IServerPlayerWrapper serverPlayer, AbstractNetworkMessage message) {
        this.sendToClient((ServerPlayer)serverPlayer.getWrappedMcObject(), message);
    }

    public abstract void sendToClient(ServerPlayer var1, AbstractNetworkMessage var2);

    @Override
    public abstract void sendToServer(AbstractNetworkMessage var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractNetworkMessage decodeMessage(FriendlyByteBuf in) {
        AbstractNetworkMessage message = null;
        try {
            short protocolVersion;
            in.markReaderIndex();
            short s = protocolVersion = this.forgeByteInProtocolVersion ? in.readByte() : in.readShort();
            if (protocolVersion != 13) {
                IncompatibleMessageInternalEvent incompatibleMessageInternalEvent = new IncompatibleMessageInternalEvent(protocolVersion);
                return incompatibleMessageInternalEvent;
            }
            message = MessageRegistry.INSTANCE.createMessage(in.readUnsignedShort());
            message.decode((ByteBuf)in);
            if (in.isReadable()) {
                throw new IOException("Buffer has not been fully read");
            }
            AbstractNetworkMessage abstractNetworkMessage = message;
            return abstractNetworkMessage;
        }
        catch (Exception e) {
            in.resetReaderIndex();
            LOGGER.error("Failed to decode message", e);
            LOGGER.error("Buffer: [" + String.valueOf(in) + "]", new Object[0]);
            LOGGER.error("Buffer contents: [" + ByteBufUtil.hexDump((ByteBuf)in) + "]", new Object[0]);
            ProtocolErrorInternalEvent protocolErrorInternalEvent = new ProtocolErrorInternalEvent(e, message, true);
            return protocolErrorInternalEvent;
        }
        finally {
            in.readerIndex(in.writerIndex());
        }
    }

    public void encodeMessage(FriendlyByteBuf out, AbstractNetworkMessage message) {
        Objects.requireNonNull(message);
        if (this.forgeByteInProtocolVersion) {
            out.writeByte(13);
        } else {
            out.writeShort(13);
        }
        try {
            out.markWriterIndex();
            out.writeShort(MessageRegistry.INSTANCE.getMessageId(message));
            message.encode((ByteBuf)out);
        }
        catch (Exception e) {
            LOGGER.error("Failed to encode message", e);
            LOGGER.error("Message: [" + String.valueOf(message) + "]", new Object[0]);
            message.getSession().tryHandleMessage(new ProtocolErrorInternalEvent(e, message, false));
            out.resetWriterIndex();
            message = new CloseReasonMessage("Internal error on other side");
            out.writeShort(MessageRegistry.INSTANCE.getMessageId(message));
            message.encode((ByteBuf)out);
        }
    }
}

