/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.render.renderer;

import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.logging.DhLogger;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.render.renderer.LodRenderer;
import com.seibel.distanthorizons.core.render.renderer.shaders.DhFadeShader;
import com.seibel.distanthorizons.core.render.renderer.shaders.FadeApplyShader;
import com.seibel.distanthorizons.core.util.math.Mat4f;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftClientWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftGLWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftRenderWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IProfilerWrapper;
import java.nio.ByteBuffer;
import org.lwjgl.opengl.GL32;
import org.lwjgl.opengl.GL43C;

public class DhFadeRenderer {
    public static DhFadeRenderer INSTANCE = new DhFadeRenderer();
    private static final DhLogger LOGGER = new DhLoggerBuilder().build();
    private static final IMinecraftClientWrapper MC_CLIENT = SingletonInjector.INSTANCE.get(IMinecraftClientWrapper.class);
    private static final IMinecraftRenderWrapper MC_RENDER = SingletonInjector.INSTANCE.get(IMinecraftRenderWrapper.class);
    private static final IMinecraftGLWrapper GLMC = SingletonInjector.INSTANCE.get(IMinecraftGLWrapper.class);
    private boolean init = false;
    private int width = -1;
    private int height = -1;
    private int fadeFramebuffer = -1;
    private int fadeTexture = -1;

    private DhFadeRenderer() {
    }

    public void init() {
        if (this.init) {
            return;
        }
        this.init = true;
        DhFadeShader.INSTANCE.init();
        FadeApplyShader.INSTANCE.init();
    }

    private void createFramebuffer(int width, int height) {
        if (this.fadeFramebuffer != -1) {
            GL32.glDeleteFramebuffers((int)this.fadeFramebuffer);
            this.fadeFramebuffer = -1;
        }
        this.fadeFramebuffer = GL32.glGenFramebuffers();
        GLMC.glBindFramebuffer(36160, this.fadeFramebuffer);
        if (this.fadeTexture != -1) {
            GLMC.glDeleteTextures(this.fadeTexture);
            this.fadeTexture = -1;
        }
        this.fadeTexture = GL32.glGenTextures();
        GLMC.glBindTexture(this.fadeTexture);
        GL32.glTexImage2D((int)3553, (int)0, (int)32859, (int)width, (int)height, (int)0, (int)6408, (int)32819, (ByteBuffer)null);
        GL32.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL32.glTexParameteri((int)3553, (int)10240, (int)9729);
        GL43C.glTexParameteri((int)3553, (int)33084, (int)0);
        GL43C.glTexParameteri((int)3553, (int)33085, (int)0);
        GL32.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)this.fadeTexture, (int)0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(Mat4f mcModelViewMatrix, Mat4f mcProjectionMatrix, float partialTicks, IProfilerWrapper profiler) {
        try {
            profiler.push("Fade Generate");
            this.init();
            int width = MC_RENDER.getTargetFramebufferViewportWidth();
            int height = MC_RENDER.getTargetFramebufferViewportHeight();
            if (this.width != width || this.height != height) {
                this.width = width;
                this.height = height;
                this.createFramebuffer(width, height);
            }
            DhFadeShader.INSTANCE.frameBuffer = this.fadeFramebuffer;
            DhFadeShader.INSTANCE.setProjectionMatrix(mcModelViewMatrix, mcProjectionMatrix, partialTicks);
            DhFadeShader.INSTANCE.render(partialTicks);
            profiler.popPush("Fade Apply");
            FadeApplyShader.INSTANCE.fadeTexture = this.fadeTexture;
            FadeApplyShader.INSTANCE.readFramebuffer = DhFadeShader.INSTANCE.frameBuffer;
            FadeApplyShader.INSTANCE.drawFramebuffer = LodRenderer.INSTANCE.getActiveFramebufferId();
            FadeApplyShader.INSTANCE.render(partialTicks);
        }
        catch (Exception e) {
            LOGGER.error("Unexpected error during fade render, error: [" + e.getMessage() + "].", e);
        }
        finally {
            profiler.pop();
        }
    }
}

