/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.visuality.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.fml.loading.FMLPaths;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ReloadableJsonConfig
extends SimplePreparableReloadListener<List<Pair<String, JsonObject>>> {
    private static final Map<ResourceLocation, ReloadableJsonConfig> CONFIGS = new HashMap<ResourceLocation, ReloadableJsonConfig>();
    protected static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    protected final ResourceLocation id;
    protected final Path path;
    protected final Logger logger;
    @Nullable
    private JsonObject config;

    protected ReloadableJsonConfig(ResourceLocation id) {
        this.id = new ResourceLocation(id.m_135827_(), id.m_135815_() + ".json");
        this.path = FMLPaths.CONFIGDIR.get().resolve(this.id.m_135827_()).resolve(this.id.m_135815_());
        this.logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
        CONFIGS.put(id, this);
    }

    protected List<Pair<String, JsonObject>> prepare(ResourceManager resourceManager, ProfilerFiller profiler) {
        profiler.m_7242_();
        profiler.m_6180_("config");
        profiler.m_6180_("parse");
        this.config = this.loadConfig();
        profiler.m_7238_();
        profiler.m_7238_();
        ArrayList<Pair<String, JsonObject>> list = new ArrayList<Pair<String, JsonObject>>();
        try {
            for (String namespace : resourceManager.m_7187_()) {
                profiler.m_6180_(namespace);
                ResourceLocation id = new ResourceLocation(namespace, this.id.m_135815_());
                for (Resource resource : resourceManager.m_213829_(id)) {
                    profiler.m_6180_(resource.m_215506_());
                    try {
                        BufferedReader reader = resource.m_215508_();
                        profiler.m_6180_("parse");
                        JsonObject object = (JsonObject)GsonHelper.m_13776_((Gson)GSON, (Reader)reader, JsonObject.class);
                        profiler.m_7238_();
                        list.add((Pair<String, JsonObject>)Pair.of((Object)(resource.m_215506_() + "#" + id), (Object)object));
                    }
                    catch (RuntimeException exception) {
                        this.logger.warn("Invalid {} in resourcepack: '{}'", new Object[]{id, resource.m_215506_(), exception});
                    }
                    profiler.m_7238_();
                }
                profiler.m_7238_();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        profiler.m_7241_();
        return list;
    }

    protected void apply(List<Pair<String, JsonObject>> list, ResourceManager resourceManager, ProfilerFiller profiler) {
        profiler.m_7242_();
        this.config = this.config == null ? this.serializeConfig() : this.apply(this.config, true, this.path.toString(), profiler);
        for (Pair<String, JsonObject> entry : list) {
            String name = (String)entry.getFirst();
            JsonObject object = (JsonObject)entry.getSecond();
            if (!CraftingHelper.processConditions((JsonObject)object, (String)"conditions", (ICondition.IContext)ICondition.IContext.EMPTY)) {
                this.logger.debug("Skipping loading {} from {} as it's conditions were not met", (Object)this.id, (Object)name);
                continue;
            }
            this.apply(object, false, name, profiler);
        }
        if (this.config != null) {
            profiler.m_6180_("save");
            this.saveConfig(this.config);
            profiler.m_7238_();
        }
        profiler.m_7238_();
        profiler.m_7241_();
    }

    @Nullable
    protected abstract JsonObject apply(JsonObject var1, boolean var2, String var3, ProfilerFiller var4);

    protected abstract JsonObject serializeConfig();

    @Nullable
    protected JsonObject loadConfig() {
        JsonObject jsonObject;
        block9: {
            if (!Files.exists(this.path, new LinkOption[0])) {
                return null;
            }
            BufferedReader reader = Files.newBufferedReader(this.path);
            try {
                jsonObject = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
                if (reader == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable throwable3) {
                    this.logger.warn("Failed to read config from {}", (Object)this.path, (Object)throwable3);
                    return null;
                }
            }
            reader.close();
        }
        return jsonObject;
    }

    private void saveConfig(JsonObject output) {
        try {
            Files.createDirectories(this.path.getParent(), new FileAttribute[0]);
            BufferedWriter writer = Files.newBufferedWriter(this.path, new OpenOption[0]);
            GSON.toJson((JsonElement)output, (Appendable)writer);
            writer.close();
            this.logger.info("Saved config to {}", (Object)this.path);
        }
        catch (Throwable throwable) {
            this.logger.error("Failed to save config to {}", (Object)this.path, (Object)throwable);
        }
    }
}

