/*
 * Decompiled with CFR 0.152.
 */
package oros.sereneseasonsfix.mixin;

import java.util.HashMap;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import oros.sereneseasonsfix.SeasonUtilities;
import oros.sereneseasonsfix.config.ServerConfig;
import oros.sereneseasonsfix.core.Sereneseasonsfix;
import oros.sereneseasonsfix.data.SeasonExtraSavedData;
import sereneseasons.api.SSGameRules;
import sereneseasons.api.season.SeasonHelper;
import sereneseasons.handler.season.SeasonHandler;
import sereneseasons.season.SeasonSavedData;

@Mixin(value={SeasonHandler.class})
public abstract class MixinSeasonHandler
implements SeasonHelper.ISeasonDataProvider {
    @Unique
    private static final HashMap<Level, Long> sereneseasonsfix$lastDayTimes = new HashMap();
    @Unique
    private static final HashMap<Level, Integer> sereneseasonsfix$tickSinceLastUpdate = new HashMap();

    @Inject(method={"onWorldTick"}, at={@At(value="HEAD")}, remap=false, cancellable=true)
    public void onWorldTick(TickEvent.LevelTickEvent event, CallbackInfo ci) {
        if (((Boolean)ServerConfig.enable_override.get()).booleanValue()) {
            ci.cancel();
            Level world = event.level;
            if (event.phase == TickEvent.Phase.END && !world.m_5776_() && SeasonUtilities.isWorldWhitelisted(world)) {
                MinecraftServer server;
                long dayTime = world.m_6106_().m_6792_();
                long lastDayTime = sereneseasonsfix$lastDayTimes.get(world);
                sereneseasonsfix$lastDayTimes.put(world, dayTime);
                if (!((Boolean)sereneseasons.config.ServerConfig.progressSeasonWhileOffline.get()).booleanValue() && (server = world.m_7654_()) != null && server.m_6846_().m_11309_() == 0) {
                    return;
                }
                if (!world.m_46469_().m_46207_(SSGameRules.RULE_DOSEASONCYCLE)) {
                    return;
                }
                long difference = dayTime - lastDayTime;
                if (difference == 0L) {
                    return;
                }
                SeasonSavedData savedData = SeasonHandler.getSeasonSavedData((Level)world);
                SeasonUtilities.setSeasonCycleTicks(savedData, (long)savedData.seasonCycleTicks + difference);
                Integer tick = sereneseasonsfix$tickSinceLastUpdate.get(world);
                if (tick >= 20) {
                    SeasonHandler.sendSeasonUpdate((Level)world);
                    tick = tick % 20;
                }
                sereneseasonsfix$tickSinceLastUpdate.put(world, tick + 1);
            }
        }
    }

    @Unique
    @SubscribeEvent
    public void sereneseasonsfix$onWorldLoad(LevelEvent.Load event) {
        Level world = (Level)event.getLevel();
        if (SeasonUtilities.isWorldWhitelisted(world)) {
            Sereneseasonsfix.LOGGER.info("Setting cached parameters");
            sereneseasonsfix$lastDayTimes.put(world, world.m_6106_().m_6792_());
            sereneseasonsfix$tickSinceLastUpdate.put(world, 0);
        }
    }

    @Unique
    @SubscribeEvent
    public void sereneseasonsfix$onWorldUnload(LevelEvent.Unload event) {
        Level world = (Level)event.getLevel();
        if (SeasonUtilities.isWorldWhitelisted(world)) {
            Sereneseasonsfix.LOGGER.info("Clearing cached parameters");
            sereneseasonsfix$lastDayTimes.remove(world);
            sereneseasonsfix$tickSinceLastUpdate.remove(world);
        }
    }

    @Inject(method={"/lambda\\$getSeasonSavedData\\$\\d/"}, at={@At(value="RETURN")}, remap=false)
    private static void afterInitSeasonTicksSet(ServerLevel world, CallbackInfoReturnable<SeasonSavedData> cir) {
        SeasonSavedData data = (SeasonSavedData)cir.getReturnValue();
        if (data != null) {
            Sereneseasonsfix.LOGGER.info("Setting startingSeasonCycleTicks = {}", (Object)data.seasonCycleTicks);
            SeasonExtraSavedData extraSavedData = SeasonExtraSavedData.getExtraSeasonSavedData((Level)world);
            extraSavedData.startingSeasonCycleTicks = data.seasonCycleTicks;
            extraSavedData.m_77762_();
        } else {
            Sereneseasonsfix.LOGGER.warn("Couldn't get initialized seasonCycleTicks");
        }
    }
}

