/*
 * Decompiled with CFR 0.152.
 */
package elocin.shield_overhaul.util;

import elocin.shield_overhaul.config.server.ShieldConfig;
import elocin.shield_overhaul.effect.EffectRegistry;
import elocin.shield_overhaul.networking.PacketRegistry;
import elocin.shield_overhaul.registry.enchantment.EnchantmentEnums;
import elocin.shield_overhaul.registry.entity.ShieldBashEntity;
import elocin.shield_overhaul.util.AnimUtils;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1268;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1510;
import net.minecraft.class_1528;
import net.minecraft.class_1548;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_7260;

public class ShieldUtils {
    private static final String PARRY_WINDOW = "parry_window";

    public static boolean isParrying(class_1799 stack, class_1657 player) {
        if (!ShieldConfig.INSTANCE.enable_parrying) {
            return false;
        }
        return ShieldUtils.getParryWindow(stack) > player.method_37908().method_8510();
    }

    public static void setParryWindow(class_1799 stack, class_1657 player) {
        if (!ShieldConfig.INSTANCE.enable_parrying) {
            return;
        }
        stack.method_7969().method_10544(PARRY_WINDOW, player.method_37908().method_8510() + (long)ShieldUtils.getParryDuration());
    }

    public static int getParryDuration() {
        return (int)(ShieldConfig.INSTANCE.parry_duration_secs * 20.0f);
    }

    public static int getParryCooldown() {
        return (int)(ShieldConfig.INSTANCE.parry_cooldown_secs * 20.0f);
    }

    public static int getParryStunDuration() {
        return (int)(ShieldConfig.INSTANCE.parry_stun_duration_secs * 20.0f);
    }

    public static int getBashCooldown() {
        return (int)(ShieldConfig.INSTANCE.bash_cooldown_secs * 20.0f);
    }

    public static int getBashStunDuration() {
        return (int)(ShieldConfig.INSTANCE.bash_stun_duration_secs * 20.0f);
    }

    public static int getStunImmunityDuration() {
        return (int)(ShieldConfig.INSTANCE.stun_immunity_duration_secs * 20.0f);
    }

    public static long getParryWindow(class_1799 stack) {
        if (stack.method_7969() == null) {
            return 0L;
        }
        return stack.method_7969().method_10537(PARRY_WINDOW);
    }

    public static void removeParryCooldown(class_1657 player) {
        if (ShieldUtils.isParrying(player.method_6047(), player)) {
            player.method_7357().method_7900(player.method_5998(class_1268.field_5808).method_7909());
        } else {
            player.method_7357().method_7900(player.method_5998(class_1268.field_5810).method_7909());
        }
    }

    public static void stunParry(class_1657 player, class_1309 attacker) {
        player.method_37908().method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14833, player.method_5634(), 1.0f, 2.0f);
        ShieldUtils.removeParryCooldown(player);
        class_1799 stack = ShieldUtils.getParryStack(player);
        EnchantmentEnums enchantmentEnum = EnchantmentEnums.DEFAULT;
        if (class_1890.method_8225((class_1887)class_1893.field_9124, (class_1799)stack) > 0 && (float)player.method_6051().method_39332(0, 1) < ShieldConfig.INSTANCE.flameborn_chance_decimal) {
            attacker.method_5639(ShieldConfig.INSTANCE.flameborn_on_fire_time_secs);
            enchantmentEnum = EnchantmentEnums.FLAMEBORN;
        }
        ShieldUtils.addParryParticles(player, enchantmentEnum);
        if (attacker == null || attacker instanceof class_1548) {
            return;
        }
        if (ShieldConfig.INSTANCE.bosses_immune_to_stun && (attacker instanceof class_1528 || attacker instanceof class_7260 || attacker instanceof class_1510)) {
            return;
        }
        ShieldUtils.applyParryStun(attacker);
    }

    public static void stunBash(class_1657 player, class_1792 item) {
        if (player.method_37908().field_9236 || ShieldConfig.INSTANCE.bash_only_on_ground && !player.method_24828()) {
            return;
        }
        player.method_7357().method_7906(item, ShieldUtils.getBashCooldown());
        AnimUtils.playBashAnim((class_3218)player.method_37908(), player);
        ShieldBashEntity entity = new ShieldBashEntity((class_1309)player, player.method_37908());
        entity.method_24919((class_1297)player, player.method_36455(), player.method_36454(), 0.0f, 2.0f, 0.0f);
        entity.method_7432((class_1297)player);
        player.method_37908().method_8649((class_1297)entity);
        class_243 velocityVector = player.method_5720();
        velocityVector = velocityVector.method_1021((double)ShieldConfig.INSTANCE.bash_distance_multiplier);
        player.method_5762(velocityVector.field_1352, velocityVector.field_1351, velocityVector.field_1350);
        player.field_6037 = true;
    }

    public static class_1799 getParryStack(class_1657 entity) {
        class_1799 stack = entity.method_6047();
        if (!ShieldUtils.isParrying(entity.method_6047(), entity)) {
            stack = entity.method_6079();
        }
        return stack;
    }

    public static void addParryParticles(class_1657 entity, EnchantmentEnums enumConstant) {
        if (entity.method_37908().field_9236) {
            return;
        }
        class_2540 buf = PacketByteBufs.create();
        buf.writeInt(entity.method_5628());
        buf.method_10817((Enum)enumConstant);
        for (class_3222 player : ((class_3218)entity.method_37908()).method_18456()) {
            ServerPlayNetworking.send((class_3222)player, (class_2960)PacketRegistry.PARRY_EFFECT, (class_2540)buf);
        }
    }

    public static void applyBashStun(class_1309 target) {
        if (!target.method_6059(EffectRegistry.STUN_IMMUNITY)) {
            target.method_6092(new class_1293(EffectRegistry.STUN, ShieldUtils.getBashStunDuration(), 0, false, false, true));
        }
    }

    public static void applyParryStun(class_1309 target) {
        if (!target.method_6059(EffectRegistry.STUN_IMMUNITY)) {
            target.method_6092(new class_1293(EffectRegistry.STUN, ShieldUtils.getParryStunDuration(), 0, false, false, true));
        }
    }
}

