/*
 * Decompiled with CFR 0.152.
 */
package com.aesefficio.interiors.foundation.mixin;

import com.aesefficio.interiors.content.block.chair.BigChairBlock;
import com.aesefficio.interiors.content.block.chair.FloorChairBlock;
import com.aesefficio.interiors.content.entity.BigSeatEntity;
import com.aesefficio.interiors.content.registry.CIBlocks;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import com.simibubi.create.content.contraptions.actors.seat.SeatBlock;
import com.simibubi.create.content.contraptions.actors.seat.SeatEntity;
import com.tterrag.registrate.util.entry.BlockEntry;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SeatBlock.class})
public abstract class SeatBlockMixin {
    @Inject(method={"isSeatOccupied(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private static void weCountAsSeatsToo(Level level, BlockPos pos, CallbackInfoReturnable<Boolean> cir) {
        if (!level.m_45976_(BigSeatEntity.class, new AABB(pos)).isEmpty()) {
            cir.setReturnValue((Object)true);
        }
    }

    @ModifyExpressionValue(method={"sitDown(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/entity/Entity;)V"}, at={@At(value="NEW", target="(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)Lcom/simibubi/create/content/contraptions/actors/seat/SeatEntity;")})
    private static SeatEntity createCorrectSeatEntity(SeatEntity original, @Local(argsOnly=true) Level level, @Local(argsOnly=true) BlockPos pos) {
        return level.m_8055_(pos).m_60734_() instanceof BigChairBlock ? new BigSeatEntity(level, pos) : new SeatEntity(level, pos);
    }

    @ModifyArg(method={"sitDown(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/entity/Entity;)V"}, at=@At(value="INVOKE", target="Lcom/simibubi/create/content/contraptions/actors/seat/SeatEntity;m_6034_(DDD)V"), index=1)
    private static double getFixedY(double y, @Local(name={"seat"}) SeatEntity seat) {
        return seat instanceof BigSeatEntity ? y + (double)0.34f : y;
    }

    @ModifyExpressionValue(method={"m_6227_(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;Lnet/minecraft/world/phys/BlockHitResult;)Lnet/minecraft/world/InteractionResult;"}, at={@At(value="INVOKE", target="Lcom/simibubi/create/foundation/block/DyedBlockList;get(Lnet/minecraft/world/item/DyeColor;)Lcom/tterrag/registrate/util/entry/BlockEntry;")})
    private BlockEntry<? extends SeatBlock> useBigChairSeats(BlockEntry<SeatBlock> original, @Local(name={"color"}) DyeColor color) {
        SeatBlock thiz = (SeatBlock)this;
        if (thiz instanceof BigChairBlock) {
            return thiz == CIBlocks.KELP_CHAIR.get() ? CIBlocks.KELP_CHAIR : CIBlocks.CHAIRS.get(color);
        }
        if (thiz instanceof FloorChairBlock) {
            return thiz == CIBlocks.KELP_FLOOR_CHAIR.get() ? CIBlocks.KELP_FLOOR_CHAIR : CIBlocks.FLOOR_CHAIRS.get(color);
        }
        return thiz == CIBlocks.KELP_SEAT.get() ? CIBlocks.KELP_SEAT : original;
    }
}

