/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.skinlayers.renderlayers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.tr7zw.skinlayers.SkinLayersModBase;
import dev.tr7zw.skinlayers.SkinUtil;
import dev.tr7zw.skinlayers.accessor.PlayerEntityModelAccessor;
import dev.tr7zw.skinlayers.accessor.PlayerSettings;
import dev.tr7zw.skinlayers.api.LayerFeatureTransformerAPI;
import dev.tr7zw.skinlayers.api.Mesh;
import dev.tr7zw.skinlayers.api.OffsetProvider;
import dev.tr7zw.skinlayers.api.PlayerData;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import lombok.Generated;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.item.ItemStack;

public class CustomLayerFeatureRenderer
extends RenderLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> {
    private static final Minecraft mc = Minecraft.m_91087_();
    private final List<Layer> bodyLayers = new ArrayList<Layer>();
    private final boolean thinArms = ((PlayerEntityModelAccessor)this.m_117386_()).hasThinArms();

    public CustomLayerFeatureRenderer(RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> renderLayerParent) {
        super(renderLayerParent);
        this.bodyLayers.add(new Layer(PlayerData::getHeadMesh, PlayerModelPart.HAT, OffsetProvider.HEAD, () -> ((PlayerModel)this.m_117386_()).f_102808_, player -> {
            ItemStack itemStack = player.m_6844_(EquipmentSlot.HEAD);
            if (itemStack != null && SkinLayersModBase.hideHeadLayers.contains(itemStack.m_41720_())) {
                return false;
            }
            return SkinLayersModBase.config.enableHat;
        }));
        this.bodyLayers.add(new Layer(PlayerData::getLeftLegMesh, PlayerModelPart.LEFT_PANTS_LEG, OffsetProvider.LEFT_LEG, () -> ((PlayerModel)this.m_117386_()).f_102814_, player -> SkinLayersModBase.config.enableLeftPants));
        this.bodyLayers.add(new Layer(PlayerData::getRightLegMesh, PlayerModelPart.RIGHT_PANTS_LEG, OffsetProvider.RIGHT_LEG, () -> ((PlayerModel)this.m_117386_()).f_102813_, player -> SkinLayersModBase.config.enableRightPants));
        this.bodyLayers.add(new Layer(PlayerData::getLeftArmMesh, PlayerModelPart.LEFT_SLEEVE, this.thinArms ? OffsetProvider.LEFT_ARM_SLIM : OffsetProvider.LEFT_ARM, () -> ((PlayerModel)this.m_117386_()).f_102812_, player -> SkinLayersModBase.config.enableLeftSleeve));
        this.bodyLayers.add(new Layer(PlayerData::getRightArmMesh, PlayerModelPart.RIGHT_SLEEVE, this.thinArms ? OffsetProvider.RIGHT_ARM_SLIM : OffsetProvider.RIGHT_ARM, () -> ((PlayerModel)this.m_117386_()).f_102811_, player -> SkinLayersModBase.config.enableRightSleeve));
        this.bodyLayers.add(new Layer(PlayerData::getTorsoMesh, PlayerModelPart.JACKET, OffsetProvider.BODY, () -> ((PlayerModel)this.m_117386_()).f_102810_, player -> SkinLayersModBase.config.enableJacket));
    }

    public void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int i, AbstractClientPlayer player, float f, float g, float h, float j, float k, float l) {
        if (SkinLayersModBase.config.compatibilityMode || player.m_20145_()) {
            return;
        }
        if (CustomLayerFeatureRenderer.mc.f_91073_ == null) {
            return;
        }
        if (player.m_20238_(CustomLayerFeatureRenderer.mc.f_91063_.m_109153_().m_90583_()) > (double)(SkinLayersModBase.config.renderDistanceLOD * SkinLayersModBase.config.renderDistanceLOD)) {
            return;
        }
        PlayerSettings settings = (PlayerSettings)player;
        if (!SkinUtil.setup3dLayers(player, settings, this.thinArms)) {
            return;
        }
        VertexConsumer vertexConsumer = multiBufferSource.m_6299_(RenderType.m_110454_((ResourceLocation)player.m_108560_(), (boolean)true));
        int m = LivingEntityRenderer.m_115338_((LivingEntity)player, (float)0.0f);
        this.renderLayers(player, settings, poseStack, vertexConsumer, i, m);
    }

    public void renderLayers(AbstractClientPlayer abstractClientPlayer, PlayerSettings settings, PoseStack matrixStack, VertexConsumer vertices, int light, int overlay) {
        for (Layer layer : this.bodyLayers) {
            Mesh mesh = layer.meshGetter.apply(settings);
            if (mesh == null || !abstractClientPlayer.m_36170_(layer.modelPart) || !layer.vanillaGetter.get().f_104207_ || !layer.configGetter.apply(abstractClientPlayer).booleanValue()) continue;
            matrixStack.m_85836_();
            LayerFeatureTransformerAPI.getTransformer().transform(abstractClientPlayer, matrixStack, layer.vanillaGetter.get());
            layer.vanillaGetter.get().m_104299_(matrixStack);
            layer.offset.applyOffset(matrixStack, mesh);
            mesh.render(layer.vanillaGetter.get(), matrixStack, vertices, light, overlay, -1);
            matrixStack.m_85849_();
        }
    }

    private static class Layer {
        private final Function<PlayerSettings, Mesh> meshGetter;
        private final PlayerModelPart modelPart;
        private final OffsetProvider offset;
        private final Supplier<ModelPart> vanillaGetter;
        private final Function<AbstractClientPlayer, Boolean> configGetter;

        @Generated
        public Layer(Function<PlayerSettings, Mesh> meshGetter, PlayerModelPart modelPart, OffsetProvider offset, Supplier<ModelPart> vanillaGetter, Function<AbstractClientPlayer, Boolean> configGetter) {
            this.meshGetter = meshGetter;
            this.modelPart = modelPart;
            this.offset = offset;
            this.vanillaGetter = vanillaGetter;
            this.configGetter = configGetter;
        }
    }
}

