/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.arch;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.kosmx.playerAnim.core.data.KeyframeAnimation;
import io.github.kosmx.emotes.api.events.server.ServerEmoteAPI;
import io.github.kosmx.emotes.executor.EmoteInstance;
import io.github.kosmx.emotes.server.serializer.UniversalEmoteSerializer;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;

public final class ServerCommands {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext registryAccess, Commands.CommandSelection environment) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"emotes").then(Commands.m_82127_((String)"play").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"emote", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)new EmoteArgumentProvider()).executes(context -> {
            UUID player = ((CommandSourceStack)context.getSource()).m_81375_().m_20148_();
            boolean admin = ((CommandSourceStack)context.getSource()).m_6761_(2);
            KeyframeAnimation emote = EmoteArgumentProvider.getEmote((CommandContext<CommandSourceStack>)context, "emote");
            if (!admin && ServerEmoteAPI.isForcedEmote(player)) {
                throw new SimpleCommandExceptionType((Message)Component.m_237113_((String)"Can't stop forced emote without admin rights")).create();
            }
            ServerEmoteAPI.playEmote(player, emote, false);
            return 0;
        })).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91470_()).requires(ctx -> ctx.m_6761_(2))).executes(context -> {
            ServerEmoteAPI.playEmote(EntityArgument.m_91474_((CommandContext)context, (String)"player").m_20148_(), EmoteArgumentProvider.getEmote((CommandContext<CommandSourceStack>)context, "emote"), false);
            return 0;
        })).then(Commands.m_82129_((String)"forced", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
            ServerEmoteAPI.playEmote(EntityArgument.m_91474_((CommandContext)context, (String)"player").m_20148_(), EmoteArgumentProvider.getEmote((CommandContext<CommandSourceStack>)context, "emote"), BoolArgumentType.getBool((CommandContext)context, (String)"forced"));
            return 0;
        })))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"stop").executes(context -> {
            boolean canStop;
            boolean admin = ((CommandSourceStack)context.getSource()).m_6761_(2);
            UUID player = ((CommandSourceStack)context.getSource()).m_81375_().m_20148_();
            boolean bl = canStop = admin || !ServerEmoteAPI.isForcedEmote(player);
            if (canStop) {
                ServerEmoteAPI.playEmote(player, null, false);
                return 0;
            }
            throw new SimpleCommandExceptionType((Message)Component.m_237113_((String)"Can't stop forced emote without admin rights")).create();
        })).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91470_()).requires(ctx -> ctx.m_6761_(2))).executes(context -> {
            ServerEmoteAPI.playEmote(EntityArgument.m_91474_((CommandContext)context, (String)"player").m_20148_(), null, false);
            return 0;
        })))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"reload").requires(ctx -> ctx.m_6761_(4) && environment == Commands.CommandSelection.DEDICATED)).executes(context -> {
            UniversalEmoteSerializer.loadEmotes();
            return 0;
        })));
    }

    private static class EmoteArgumentProvider
    implements SuggestionProvider<CommandSourceStack> {
        private EmoteArgumentProvider() {
        }

        public CompletableFuture<Suggestions> getSuggestions(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
            HashMap<UUID, KeyframeAnimation> emotes = EmoteArgumentProvider.getEmotes(((CommandSourceStack)context.getSource()).m_6761_(1));
            LinkedList<String> suggestions = new LinkedList<String>();
            for (KeyframeAnimation emote : emotes.values()) {
                if (emote.extraData.containsKey("name")) {
                    Object name = EmoteInstance.instance.getDefaults().fromJson(emote.extraData.get("name")).getString();
                    if (((String)name).contains(" ")) {
                        name = "\"" + (String)name + "\"";
                    }
                    suggestions.add((String)name);
                    continue;
                }
                suggestions.add(emote.getUuid().toString());
            }
            return SharedSuggestionProvider.m_82967_((String[])((String[])suggestions.toArray(String[]::new)), (SuggestionsBuilder)builder);
        }

        private static HashMap<UUID, KeyframeAnimation> getEmotes(boolean allowHidden) {
            return allowHidden ? ServerEmoteAPI.getLoadedEmotes() : ServerEmoteAPI.getPublicEmotes();
        }

        public static KeyframeAnimation getEmote(CommandContext<CommandSourceStack> context, String argumentName) throws CommandSyntaxException {
            String id = StringArgumentType.getString(context, (String)argumentName);
            HashMap<UUID, KeyframeAnimation> emotes = EmoteArgumentProvider.getEmotes(((CommandSourceStack)context.getSource()).m_6761_(1));
            try {
                UUID emoteID = UUID.fromString(id);
                KeyframeAnimation emote = emotes.get(emoteID);
                if (emote == null) {
                    throw new SimpleCommandExceptionType((Message)Component.m_237113_((String)("No emote with ID: " + emoteID))).create();
                }
                return emote;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                for (KeyframeAnimation emote : emotes.values()) {
                    String name;
                    if (!emote.extraData.containsKey("name") || !(name = EmoteInstance.instance.getDefaults().fromJson(emote.extraData.get("name")).getString()).equals(id)) continue;
                    return emote;
                }
                throw new SimpleCommandExceptionType((Message)Component.m_237113_((String)("Not emote with name: " + id))).create();
            }
        }
    }
}

