/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.events;

import com.jesz.createdieselgenerators.CDGBlocks;
import com.jesz.createdieselgenerators.CDGConfig;
import com.jesz.createdieselgenerators.CDGItems;
import com.jesz.createdieselgenerators.CDGRegistries;
import com.jesz.createdieselgenerators.commands.CDGCommands;
import com.jesz.createdieselgenerators.content.andesite_girder.AndesiteGirderWrenchBehaviour;
import com.jesz.createdieselgenerators.content.diesel_engine.EngineTypes;
import com.jesz.createdieselgenerators.content.entity_filter.EntityFilteringRenderer;
import com.jesz.createdieselgenerators.content.entity_filter.ReverseLootTable;
import com.jesz.createdieselgenerators.events.EntityTickEvent;
import com.jesz.createdieselgenerators.fuel_type.FuelType;
import com.jesz.createdieselgenerators.mixins.LootPoolAccessor;
import com.jesz.createdieselgenerators.mixins.LootTableAccessor;
import com.mojang.brigadier.CommandDispatcher;
import com.simibubi.create.content.equipment.goggles.GogglesItem;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.utility.CreateLang;
import com.simibubi.create.infrastructure.config.AllConfigs;
import com.simibubi.create.infrastructure.config.CKinetics;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.lang.FontHelper;
import net.createmod.catnip.lang.Lang;
import net.createmod.catnip.lang.LangBuilder;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MilkBucketItem;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.ExplosionEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.server.command.ConfigCommand;

@Mod.EventBusSubscriber(modid="createdieselgenerators")
public class ForgeEvents {
    static Map<Level, Set<BlockPos>> toExplode = new HashMap<Level, Set<BlockPos>>();

    @SubscribeEvent
    public static void onCommandRegister(RegisterCommandsEvent event) {
        new CDGCommands((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        ConfigCommand.register((CommandDispatcher)event.getDispatcher());
    }

    @SubscribeEvent
    public static void loadLootTable(LootTableLoadEvent event) {
        LootTable table = event.getTable();
        ResourceLocation tableId = table.getLootTableId();
        if (!tableId.m_135815_().startsWith("entities/")) {
            return;
        }
        LinkedList results = new LinkedList();
        ((LootTableAccessor)table).getPools().forEach(pool -> List.of(((LootPoolAccessor)pool).getEntries()).forEach(e -> {
            if (e instanceof LootItem) {
                LootItem lootItem = (LootItem)e;
                lootItem.m_6948_(stack -> {
                    String path = tableId.m_135815_();
                    path = path.replaceAll("entities/", "");
                    EntityType type = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(tableId.m_135827_(), path));
                    ReverseLootTable.ALL.computeIfAbsent(stack.m_41720_(), s -> new ArrayList()).add(type);
                }, null);
            }
        }));
    }

    @SubscribeEvent
    public static void playerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
    }

    @SubscribeEvent
    public static void addReloadListeners(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)ReverseLootTable.INSTANCE);
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        AndesiteGirderWrenchBehaviour.tick();
        EntityFilteringRenderer.tick();
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.LevelTickEvent event) {
        Level level;
        if (event.phase == TickEvent.Phase.START || !((level = event.level) instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        if (toExplode.containsKey(level2)) {
            List list = toExplode.get(level2).stream().toList();
            if (list.isEmpty()) {
                return;
            }
            for (BlockPos pos : list) {
                level2.m_254877_(null, null, null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 1.0f, true, Level.ExplosionInteraction.BLOCK);
                toExplode.get(level2).remove(pos);
            }
        }
    }

    @SubscribeEvent
    public static void onEntityTick(EntityTickEvent event) {
        ItemEntity itemEntity;
        Entity entity = event.entity;
        if (entity instanceof ItemEntity && (itemEntity = (ItemEntity)entity).m_32055_().m_150930_((Item)CDGItems.LIGHTER.get()) && ((Boolean)CDGConfig.COMBUSTIBLES_BLOW_UP.get()).booleanValue() && itemEntity.m_32055_().m_41783_() != null && itemEntity.m_32055_().m_41783_().m_128451_("Type") == 2) {
            boolean flammable;
            Vec3 entityPos = itemEntity.m_20318_(1.0f);
            FluidState fState = itemEntity.m_9236_().m_6425_(new BlockPos((Vec3i)BlockPos.m_274446_((Position)entityPos)));
            if (fState.m_192917_((Fluid)Fluids.f_76193_) || fState.m_192917_((Fluid)Fluids.f_76192_)) {
                itemEntity.m_32055_().m_41783_().m_128405_("Type", 1);
                itemEntity.m_9236_().m_7785_(itemEntity.m_20318_((float)1.0f).f_82479_, itemEntity.m_20318_((float)1.0f).f_82480_, itemEntity.m_20318_((float)1.0f).f_82481_, SoundEvents.f_144098_, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                return;
            }
            boolean bl = flammable = FuelType.getTypeFor((HolderLookup.RegistryLookup<FuelType>)itemEntity.m_9236_().m_9598_().m_255025_(CDGRegistries.FUEL_TYPE), fState.m_76152_()).normal().speed() != 0.0f;
            if (flammable) {
                itemEntity.m_9236_().m_254877_(null, null, null, itemEntity.m_20318_((float)1.0f).f_82479_, itemEntity.m_20318_((float)1.0f).f_82480_, itemEntity.m_20318_((float)1.0f).f_82481_, 1.0f, true, Level.ExplosionInteraction.BLOCK);
            }
        }
    }

    @SubscribeEvent
    public static void onExplosion(ExplosionEvent event) {
        Level level = event.getLevel();
        if (((Boolean)CDGConfig.COMBUSTIBLES_BLOW_UP.get()).booleanValue() && !level.f_46443_) {
            for (int x = -2; x < 2; ++x) {
                for (int y = -2; y < 2; ++y) {
                    for (int z = -2; z < 2; ++z) {
                        boolean flammable;
                        BlockPos pos = new BlockPos((int)((double)x + event.getExplosion().getPosition().f_82479_), (int)((double)y + event.getExplosion().getPosition().f_82480_), (int)((double)z + event.getExplosion().getPosition().f_82481_));
                        if (!level.m_46739_(pos) || !(Math.abs(Math.sqrt(x * x + y * y + z * z)) < 2.0)) continue;
                        FluidState fluidState = level.m_6425_(pos);
                        boolean bl = flammable = FuelType.getTypeFor((HolderLookup.RegistryLookup<FuelType>)level.m_9598_().m_255025_(CDGRegistries.FUEL_TYPE), fluidState.m_76152_()).normal().speed() != 0.0f;
                        if (!flammable) continue;
                        level.m_46597_(pos, Blocks.f_50016_.m_49966_());
                        if (!toExplode.containsKey(level)) {
                            toExplode.put(level, new HashSet());
                        }
                        toExplode.get(level).add(pos);
                        return;
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void addTrade(VillagerTradesEvent event) {
        Int2ObjectMap trades = event.getTrades();
        if (event.getType() != VillagerProfession.f_35598_) {
            return;
        }
        ((List)trades.get(2)).add((t, r) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 5), new ItemStack((ItemLike)CDGItems.LIGHTER.get()), 10, 8, 0.02f));
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void addToItemTooltip(ItemTooltipEvent event) {
        CKinetics config;
        BlockItem bi;
        List tooltip;
        block17: {
            block16: {
                if (!((Boolean)AllConfigs.client().tooltips.get()).booleanValue()) {
                    return;
                }
                if (event.getEntity() == null) {
                    return;
                }
                tooltip = event.getToolTip();
                Item item = event.getItemStack().m_41720_();
                if ((item instanceof BucketItem || item instanceof MilkBucketItem) && ((Boolean)CDGConfig.FUEL_TOOLTIPS.get()).booleanValue()) {
                    Fluid fluid = (Fluid)ForgeMod.MILK.get();
                    if (item instanceof BucketItem) {
                        bi = (BucketItem)item;
                        fluid = bi.getFluid();
                    }
                    FuelType type = FuelType.getTypeFor((HolderLookup.RegistryLookup<FuelType>)Minecraft.m_91087_().f_91073_.m_9598_().m_255025_(CDGRegistries.FUEL_TYPE), fluid);
                    if (Screen.m_96639_() && type.normal().speed() != 0.0f) {
                        tooltip.add(1, Component.m_237110_((String)"createdieselgenerators.tooltip.holdForFuelStats", (Object[])new Object[]{Component.m_237115_((String)"createdieselgenerators.tooltip.keyAlt").m_130940_(ChatFormatting.WHITE)}).m_130940_(ChatFormatting.DARK_GRAY));
                        tooltip.add(2, Component.m_237119_());
                        byte enginesEnabled = (byte)((EngineTypes.NORMAL.enabled() ? 1 : 0) + (EngineTypes.MODULAR.enabled() ? 1 : 0) + (EngineTypes.HUGE.enabled() ? 1 : 0));
                        int currentEngineIndex = AnimationTickHolder.getTicks() % 120 / 20;
                        List<EngineTypes> enabledEngines = Arrays.stream(EngineTypes.values()).filter(EngineTypes::enabled).toList();
                        Object currentEngine = enabledEngines.get(currentEngineIndex % enginesEnabled);
                        float currentSpeed = type.getGenerated((EngineTypes)((Object)currentEngine)).speed();
                        float currentCapacity = type.getGenerated((EngineTypes)((Object)currentEngine)).strength();
                        float currentBurn = type.getGenerated((EngineTypes)((Object)currentEngine)).burn();
                        if (enginesEnabled != 1) {
                            tooltip.add(3, Component.m_237115_((String)("block.createdieselgenerators." + (currentEngine == EngineTypes.MODULAR ? "large_" : (currentEngine == EngineTypes.HUGE ? "huge_" : "")) + "diesel_engine")).m_130940_(ChatFormatting.GRAY));
                        }
                        tooltip.add(enginesEnabled != 1 ? 4 : 3, Component.m_237110_((String)"createdieselgenerators.tooltip.fuelSpeed", (Object[])new Object[]{CreateLang.number((double)currentSpeed).component().m_130948_(FontHelper.Palette.STANDARD_CREATE.primary())}).m_130940_(ChatFormatting.DARK_GRAY));
                        tooltip.add(enginesEnabled != 1 ? 5 : 4, Component.m_237110_((String)"createdieselgenerators.tooltip.fuelStress", (Object[])new Object[]{CreateLang.number((double)currentCapacity).component().m_130948_(FontHelper.Palette.STANDARD_CREATE.primary())}).m_130940_(ChatFormatting.DARK_GRAY));
                        tooltip.add(enginesEnabled != 1 ? 6 : 5, Component.m_237110_((String)"createdieselgenerators.tooltip.fuelBurnRate", (Object[])new Object[]{CreateLang.number((double)(currentBurn * 20.0f)).component().m_130948_(FontHelper.Palette.STANDARD_CREATE.primary())}).m_130940_(ChatFormatting.DARK_GRAY));
                        tooltip.add(enginesEnabled != 1 ? 7 : 6, Component.m_237119_());
                        tooltip.add(enginesEnabled != 1 ? 8 : 7, Component.m_237110_((String)"createdieselgenerators.tooltip.burnerStrength", (Object[])new Object[]{CreateLang.number((double)(type.burnerStrength() * 100.0f)).text(" %").component().m_130948_(FontHelper.Palette.STANDARD_CREATE.primary())}).m_130940_(ChatFormatting.DARK_GRAY));
                        tooltip.add(enginesEnabled != 1 ? 9 : 8, Component.m_237119_());
                    } else if (type.normal().speed() != 0.0f) {
                        tooltip.add(1, Component.m_237110_((String)"createdieselgenerators.tooltip.holdForFuelStats", (Object[])new Object[]{Component.m_237115_((String)"createdieselgenerators.tooltip.keyAlt").m_130940_(ChatFormatting.GRAY)}).m_130940_(ChatFormatting.DARK_GRAY));
                    }
                }
                config = AllConfigs.server().kinetics;
                if (!(item instanceof BlockItem)) break block16;
                bi = (BlockItem)item;
                if (IRotate.StressImpact.isEnabled() && (CDGBlocks.DIESEL_ENGINE.is((Item)bi) || CDGBlocks.MODULAR_DIESEL_ENGINE.is((Item)bi) || CDGBlocks.HUGE_DIESEL_ENGINE.is((Item)bi))) break block17;
            }
            return;
        }
        tooltip.add(Component.m_237119_());
        int highestRPM = 0;
        int highestCapacity = 0;
        int highestStressCapacity = 0;
        for (Holder.Reference r : Minecraft.m_91087_().f_91073_.m_9598_().m_255025_(CDGRegistries.FUEL_TYPE).m_214062_().toList()) {
            FuelType type = (FuelType)r.get();
            if (CDGBlocks.DIESEL_ENGINE.is((Item)bi)) {
                highestRPM = (int)Math.max((float)highestRPM, type.normal().speed());
                highestCapacity = (int)Math.max((float)highestCapacity, type.normal().strength() / type.normal().speed());
                highestStressCapacity = (int)Math.max((float)highestStressCapacity, type.normal().strength());
                continue;
            }
            if (CDGBlocks.MODULAR_DIESEL_ENGINE.is((Item)bi)) {
                highestRPM = (int)Math.max((float)highestRPM, type.modular().speed());
                highestCapacity = (int)Math.max((float)highestCapacity, type.modular().strength() / type.modular().speed());
                highestStressCapacity = (int)Math.max((float)highestStressCapacity, type.modular().strength());
                continue;
            }
            if (!CDGBlocks.HUGE_DIESEL_ENGINE.is((Item)bi)) continue;
            highestRPM = (int)Math.max((float)highestRPM, type.huge().speed());
            highestCapacity = (int)Math.max((float)highestCapacity, type.huge().strength() / type.huge().speed());
            highestStressCapacity = (int)Math.max((float)highestStressCapacity, type.huge().strength());
        }
        boolean hasGoggles = GogglesItem.isWearingGoggles((Player)event.getEntity());
        LangBuilder rpmUnit = CreateLang.translate((String)"generic.unit.rpm", (Object[])new Object[0]);
        LangBuilder suUnit = CreateLang.translate((String)"generic.unit.stress", (Object[])new Object[0]);
        CreateLang.translate((String)"tooltip.capacityProvided", (Object[])new Object[0]).style(ChatFormatting.GRAY).addTo(tooltip);
        IRotate.StressImpact impactId = (double)highestCapacity >= (Double)config.highCapacity.get() ? IRotate.StressImpact.HIGH : ((double)highestCapacity >= (Double)config.mediumCapacity.get() ? IRotate.StressImpact.MEDIUM : IRotate.StressImpact.LOW);
        IRotate.StressImpact opposite = IRotate.StressImpact.values()[IRotate.StressImpact.values().length - 2 - impactId.ordinal()];
        LangBuilder builder = CreateLang.builder().add(CreateLang.text((String)TooltipHelper.makeProgressBar((int)3, (int)(impactId.ordinal() + 1))).style(opposite.getAbsoluteColor()));
        if (hasGoggles) {
            builder.add(CreateLang.number((double)highestCapacity)).text("x ").add(rpmUnit).addTo(tooltip);
            LangBuilder amount = CreateLang.number((double)highestStressCapacity).add(suUnit);
            CreateLang.text((String)" -> ").add(CreateLang.translate((String)"tooltip.up_to", (Object[])new Object[]{amount})).style(ChatFormatting.DARK_GRAY).addTo(tooltip);
        } else {
            builder.translate("tooltip.capacityProvided." + Lang.asId((String)impactId.name()), new Object[0]).addTo(tooltip);
        }
    }
}

