/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.content.turret;

import com.jesz.createdieselgenerators.CDGPartialModels;
import com.jesz.createdieselgenerators.mixin_interfaces.IEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.content.trains.schedule.hat.TrainHatInfo;
import com.simibubi.create.content.trains.schedule.hat.TrainHatInfoReloadListener;
import com.simibubi.create.foundation.mixin.accessor.AgeableListModelAccessor;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.transform.PoseTransformStack;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import java.util.ArrayList;
import java.util.Iterator;
import net.createmod.catnip.render.CachedBuffers;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class TurretOperatorHatLayer<T extends LivingEntity, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    public TurretOperatorHatLayer(RenderLayerParent<T, M> renderer) {
        super(renderer);
    }

    public void render(PoseStack ms, MultiBufferSource buffer, int light, LivingEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        AgeableListModel model;
        if (!this.shouldRenderOn(entity)) {
            return;
        }
        EntityModel entityModel = this.m_117386_();
        RenderType renderType = Sheets.m_110790_();
        ms.m_85836_();
        PoseTransformStack msr = TransformStack.of((PoseStack)ms);
        TrainHatInfo info = TrainHatInfoReloadListener.getHatInfoFor((Entity)entity);
        ArrayList partsToHead = new ArrayList();
        if (entityModel instanceof AgeableListModel && (model = (AgeableListModel)entityModel) instanceof com.jesz.createdieselgenerators.mixins.AgeableListModelAccessor) {
            ModelPart head;
            com.jesz.createdieselgenerators.mixins.AgeableListModelAccessor modelA = (com.jesz.createdieselgenerators.mixins.AgeableListModelAccessor)model;
            if (model.f_102610_) {
                if (modelA.getScaleHead()) {
                    float f = 1.5f / modelA.getBabyHeadScale();
                    ms.m_85841_(f, f, f);
                }
                ms.m_85837_(0.0, (double)(modelA.getBabyYHeadOffset() / 16.0f), (double)(modelA.getBabyZHeadOffset() / 16.0f));
            }
            if ((head = TurretOperatorHatLayer.getHeadPart(model)) != null) {
                partsToHead.addAll(TrainHatInfo.getAdjustedPart((TrainHatInfo)info, (ModelPart)head, (String)""));
            }
        } else if (entityModel instanceof HierarchicalModel) {
            HierarchicalModel model2 = (HierarchicalModel)entityModel;
            partsToHead.addAll(TrainHatInfo.getAdjustedPart((TrainHatInfo)info, (ModelPart)model2.m_142109_(), (String)"head"));
        }
        if (!partsToHead.isEmpty()) {
            partsToHead.forEach(part -> part.m_104299_(ms));
            ModelPart lastChild = (ModelPart)partsToHead.get(partsToHead.size() - 1);
            if (!lastChild.m_171326_()) {
                ModelPart.Cube cube = lastChild.m_233558_(RandomSource.m_216335_((long)1023112312L));
                ms.m_85837_(info.offset().m_7096_() / 16.0, ((double)(cube.f_104336_ - cube.f_104339_) + info.offset().m_7098_()) / 16.0, info.offset().m_7094_() / 16.0);
                float max = Math.max(cube.f_104338_ - cube.f_104335_, cube.f_104340_ - cube.f_104337_) / 8.0f * info.scale();
                ms.m_85841_(max, max, max);
            }
            ms.m_85841_(1.0f, -1.0f, -1.0f);
            ms.m_252880_(0.0f, -0.140625f, 0.0f);
            msr.rotateXDegrees(-8.5f);
            BlockState air = Blocks.f_50016_.m_49966_();
            CachedBuffers.partial((PartialModel)CDGPartialModels.TURRET_OPERATOR_HAT, (BlockState)air).light(light).renderInto(ms, buffer.m_6299_(renderType));
        }
        ms.m_85849_();
    }

    private boolean shouldRenderOn(LivingEntity entity) {
        if (entity == null) {
            return false;
        }
        return ((IEntity)entity).getTurretPos() != null;
    }

    public static void registerOnAll(EntityRenderDispatcher renderManager) {
        for (EntityRenderer renderer : renderManager.getSkinMap().values()) {
            TurretOperatorHatLayer.registerOn(renderer);
        }
        for (EntityRenderer renderer : renderManager.f_114362_.values()) {
            TurretOperatorHatLayer.registerOn(renderer);
        }
    }

    public static void registerOn(EntityRenderer<?> entityRenderer) {
        if (!(entityRenderer instanceof LivingEntityRenderer)) {
            return;
        }
        LivingEntityRenderer livingRenderer = (LivingEntityRenderer)entityRenderer;
        EntityModel model = livingRenderer.m_7200_();
        if (!(model instanceof HierarchicalModel) && !(model instanceof AgeableListModel)) {
            return;
        }
        livingRenderer.m_115326_(new TurretOperatorHatLayer(livingRenderer));
    }

    private static ModelPart getHeadPart(AgeableListModel<?> model) {
        Iterator iterator = ((AgeableListModelAccessor)model).create$callHeadParts().iterator();
        if (iterator.hasNext()) {
            ModelPart part = (ModelPart)iterator.next();
            return part;
        }
        iterator = ((AgeableListModelAccessor)model).create$callBodyParts().iterator();
        if (iterator.hasNext()) {
            ModelPart part = (ModelPart)iterator.next();
            return part;
        }
        return null;
    }
}

