/*
 * Decompiled with CFR 0.152.
 */
package com.zigythebird.playeranimatorapi.playeranims;

import com.zigythebird.playeranimatorapi.data.PlayerAnimationData;
import com.zigythebird.playeranimatorapi.playeranims.CustomModifierLayer;
import com.zigythebird.playeranimatorapi.playeranims.PlayerAnimations;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationAccess;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ConditionalAnimations {
    private static Map<String, Function<PlayerAnimationData, ResourceLocation>> perModConditions = new HashMap<String, Function<PlayerAnimationData, ResourceLocation>>();

    public static void addModConditions(String namespace, Function<PlayerAnimationData, ResourceLocation> function) {
        perModConditions.put(namespace, function);
    }

    public static ResourceLocation getAnimationForCurrentConditions(PlayerAnimationData data) {
        if (perModConditions.containsKey(data.animationID().m_135827_())) {
            return perModConditions.get(data.animationID().m_135827_()).apply(data);
        }
        AbstractClientPlayer player = (AbstractClientPlayer)Minecraft.m_91087_().f_91073_.m_46003_(data.playerUUID());
        CustomModifierLayer animationContainer = (CustomModifierLayer)PlayerAnimationAccess.getPlayerAssociatedData((AbstractClientPlayer)player).get(PlayerAnimations.animationLayerId);
        ResourceLocation currentAnim = animationContainer.currentAnim;
        ResourceLocation baseAnim = data.animationID();
        ResourceLocation runningAnim = data.animationID().m_247449_(data.animationID().m_135815_() + "_run");
        ResourceLocation crouchedAnim = data.animationID().m_247449_(data.animationID().m_135815_() + "_crouch");
        ResourceLocation crawlingAnim = data.animationID().m_247449_(data.animationID().m_135815_() + "_crawl");
        ResourceLocation swimmingAnim = data.animationID().m_247449_(data.animationID().m_135815_() + "_swim");
        Map animations = PlayerAnimationRegistry.getAnimations();
        if (player.m_6047_() && currentAnim != crawlingAnim && animations.containsKey(crouchedAnim)) {
            return crouchedAnim;
        }
        if (player.m_20143_() && currentAnim != crawlingAnim && animations.containsKey(crawlingAnim)) {
            return crawlingAnim;
        }
        if (player.m_6067_() && currentAnim != swimmingAnim && animations.containsKey(swimmingAnim)) {
            return swimmingAnim;
        }
        if (player.m_20142_() && currentAnim != runningAnim && animations.containsKey(runningAnim)) {
            return runningAnim;
        }
        return baseAnim;
    }
}

