/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.crafting;

import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.p3pp3rf1y.sophisticatedcore.crafting.IWrapperRecipe;
import net.p3pp3rf1y.sophisticatedcore.crafting.RecipeWrapperSerializer;
import net.p3pp3rf1y.sophisticatedstorage.block.ChestBlock;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.item.WoodStorageBlockItem;

public class ShulkerBoxFromChestRecipe
extends ShapedRecipe
implements IWrapperRecipe<ShapedRecipe> {
    public static final Set<ResourceLocation> REGISTERED_RECIPES = new LinkedHashSet<ResourceLocation>();
    private final ShapedRecipe compose;

    public ShulkerBoxFromChestRecipe(ShapedRecipe compose) {
        super(compose.m_6423_(), compose.m_6076_(), compose.m_245232_(), compose.getRecipeWidth(), compose.getRecipeHeight(), compose.m_7527_(), compose.f_44149_);
        this.compose = compose;
        REGISTERED_RECIPES.add(compose.m_6423_());
    }

    public boolean m_5818_(CraftingContainer pInv, Level pLevel) {
        return super.m_5818_(pInv, pLevel) && this.getChest(pInv).map(c -> !WoodStorageBlockItem.isPacked(c)).orElse(false) != false;
    }

    public boolean m_5598_() {
        return true;
    }

    private Optional<ItemStack> getChest(CraftingContainer inv) {
        for (int slot = 0; slot < inv.m_6643_(); ++slot) {
            BlockItem blockItem;
            ItemStack slotStack = inv.m_8020_(slot);
            Item item = slotStack.m_41720_();
            if (!(item instanceof BlockItem) || !((blockItem = (BlockItem)item).m_40614_() instanceof ChestBlock)) continue;
            return Optional.of(slotStack);
        }
        return Optional.empty();
    }

    public ItemStack m_5874_(CraftingContainer inv, RegistryAccess registryAccess) {
        ItemStack shulker = super.m_5874_(inv, registryAccess);
        this.getChest(inv).ifPresent(chest -> {
            Item patt2342$temp;
            if (chest.m_41788_()) {
                shulker.m_41714_(chest.m_41786_());
            }
            if ((patt2342$temp = shulker.m_41720_()) instanceof StorageBlockItem) {
                StorageBlockItem storageBlockItem = (StorageBlockItem)patt2342$temp;
                StorageBlockItem.getMainColorFromStack(chest).ifPresent(mc -> storageBlockItem.setMainColor(shulker, (int)mc));
                StorageBlockItem.getAccentColorFromStack(chest).ifPresent(ac -> storageBlockItem.setAccentColor(shulker, (int)ac));
            }
        });
        return shulker;
    }

    public ShapedRecipe getCompose() {
        return this.compose;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModBlocks.SHULKER_BOX_FROM_CHEST_RECIPE_SERIALIZER.get();
    }

    public static class Serializer
    extends RecipeWrapperSerializer<ShapedRecipe, ShulkerBoxFromChestRecipe> {
        public Serializer() {
            super(ShulkerBoxFromChestRecipe::new, RecipeSerializer.f_44076_);
        }
    }
}

