/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.client.render;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BuiltInModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraftforge.client.model.ElementsModel;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;
import net.p3pp3rf1y.sophisticatedstorage.SophisticatedStorage;
import net.p3pp3rf1y.sophisticatedstorage.client.render.SimpleCompositeModel;
import org.apache.logging.log4j.util.Supplier;

public class CompositeElementsModel
extends BlockModel {
    private final List<BlockElement> elements = new ArrayList<BlockElement>();

    public CompositeElementsModel(@Nullable ResourceLocation parentLocation, Map<String, Either<Material, String>> textureMap) {
        super(parentLocation, Collections.emptyList(), textureMap, Boolean.valueOf(true), null, ItemTransforms.f_111786_, Collections.emptyList());
    }

    public BakedModel m_111449_(ModelBaker modelBaker, BlockModel owner, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ResourceLocation modelLocation, boolean guiLight3d) {
        if (this.m_111490_() == ModelBakery.f_119233_) {
            TextureAtlasSprite particleSprite = spriteGetter.apply(this.m_111480_("particle"));
            return new BuiltInModel(this.m_111491_(), this.getOverrides(modelBaker, owner, spriteGetter), particleSprite, this.m_111479_().m_111526_());
        }
        ElementsModel elementsModel = new ElementsModel(this.m_111436_());
        return elementsModel.bake((IGeometryBakingContext)this.customData, modelBaker, spriteGetter, modelState, this.getOverrides(modelBaker, owner, spriteGetter), modelLocation);
    }

    public List<BlockElement> m_111436_() {
        return this.elements;
    }

    public void m_5500_(Function<ResourceLocation, UnbakedModel> modelGetter) {
        super.m_5500_(modelGetter);
        this.copyElementsFromAllIncludedModels();
        this.copyTexturesFromAllIncludedModels();
    }

    private void copyElementsFromAllIncludedModels() {
        if (this.f_111418_ != null) {
            IUnbakedGeometry iUnbakedGeometry;
            this.elements.addAll(this.f_111418_.m_111436_());
            if (this.f_111418_.customData.hasCustomGeometry() && (iUnbakedGeometry = this.f_111418_.customData.getCustomGeometry()) instanceof SimpleCompositeModel) {
                SimpleCompositeModel simpleCompositeModel = (SimpleCompositeModel)iUnbakedGeometry;
                this.elements.addAll(simpleCompositeModel.getElements());
            }
        }
    }

    private void copyTexturesFromAllIncludedModels() {
        if (this.f_111418_ != null) {
            IUnbakedGeometry iUnbakedGeometry;
            this.f_111418_.f_111417_.forEach(this.f_111417_::putIfAbsent);
            if (this.f_111418_.customData.hasCustomGeometry() && (iUnbakedGeometry = this.f_111418_.customData.getCustomGeometry()) instanceof SimpleCompositeModel) {
                SimpleCompositeModel simpleCompositeModel = (SimpleCompositeModel)iUnbakedGeometry;
                simpleCompositeModel.getTextures().forEach(this.f_111417_::putIfAbsent);
            }
        }
    }

    public Material m_111480_(String textureName) {
        if (textureName.charAt(0) == '#') {
            textureName = textureName.substring(1);
        }
        ArrayList visitedTextureReferences = Lists.newArrayList();
        Either<Material, String> either;
        Optional optional;
        while (!(optional = (either = this.findTexture(textureName)).left()).isPresent()) {
            textureName = either.right().orElse("");
            if (visitedTextureReferences.contains(textureName)) {
                String finalTextureName = textureName;
                SophisticatedStorage.LOGGER.warn("Unable to resolve texture due to reference chain {}->{} in {}", new Supplier[]{() -> Joiner.on((String)"->").join((Iterable)visitedTextureReferences), () -> finalTextureName, () -> this.f_111416_});
                return new Material(InventoryMenu.f_39692_, MissingTextureAtlasSprite.m_118071_());
            }
            visitedTextureReferences.add(textureName);
        }
        return (Material)optional.get();
    }

    private Either<Material, String> findTexture(String textureName) {
        CompositeElementsModel blockmodel = this;
        while (blockmodel != null) {
            Either either = (Either)blockmodel.f_111417_.get(textureName);
            if (either != null) {
                return either;
            }
            blockmodel = blockmodel.f_111418_;
        }
        return Either.left((Object)new Material(InventoryMenu.f_39692_, MissingTextureAtlasSprite.m_118071_()));
    }
}

