/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.block;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.p3pp3rf1y.sophisticatedcore.controller.ControllerBlockEntityBase;
import net.p3pp3rf1y.sophisticatedcore.controller.IControllerBoundable;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;

public class StorageConnectorBlockEntity
extends BlockEntity
implements IControllerBoundable {
    @Nullable
    private BlockPos controllerPos = null;
    private boolean chunkBeingUnloaded = false;

    public StorageConnectorBlockEntity(BlockPos pos, BlockState blockState) {
        super(ModBlocks.STORAGE_CONNECTOR_BLOCK_ENTITY_TYPE.get(), pos, blockState);
    }

    public void setControllerPos(BlockPos controllerPos) {
        this.controllerPos = controllerPos;
        this.m_6596_();
    }

    public Optional<BlockPos> getControllerPos() {
        return Optional.ofNullable(this.controllerPos);
    }

    public void removeControllerPos() {
        this.controllerPos = null;
        this.m_6596_();
    }

    public BlockPos getStorageBlockPos() {
        return this.m_58899_();
    }

    public Level getStorageBlockLevel() {
        return this.m_58904_();
    }

    public void registerController(ControllerBlockEntityBase controllerBlockEntity) {
        this.setControllerPos(controllerBlockEntity.m_58899_());
    }

    public void unregisterController() {
        this.removeControllerPos();
    }

    public boolean canConnectStorages() {
        return true;
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        this.saveControllerPos(tag);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.loadControllerPos(tag);
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        this.chunkBeingUnloaded = true;
    }

    public void m_7651_() {
        if (!this.chunkBeingUnloaded && this.f_58857_ != null) {
            this.removeFromController();
        }
        super.m_7651_();
    }

    public void addToController(Level level, BlockPos pos, BlockPos controllerPos) {
        WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)controllerPos, ControllerBlockEntityBase.class).ifPresent(c -> c.addStorage(pos));
    }

    public void removeFromController() {
        if (this.controllerPos != null && !this.f_58857_.m_5776_()) {
            WorldHelper.getBlockEntity((BlockGetter)this.f_58857_, (BlockPos)this.controllerPos, ControllerBlockEntityBase.class).ifPresent(controller -> controller.removeBoundable(this.f_58858_));
            this.removeControllerPos();
        }
    }
}

