/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.block;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.p3pp3rf1y.sophisticatedstorage.Config;
import net.p3pp3rf1y.sophisticatedstorage.block.ShulkerBoxBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.SophisticatedOpenersCounter;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;

public class ShulkerBoxBlockEntity
extends StorageBlockEntity {
    public static final String STORAGE_TYPE = "shulker_box";
    private AnimationStatus animationStatus = AnimationStatus.CLOSED;
    private float progress;
    private float progressOld;
    public final SophisticatedOpenersCounter openersCounter = new SophisticatedOpenersCounter(){

        protected void m_142292_(Level level, BlockPos pos, BlockState state) {
            ShulkerBoxBlockEntity.this.animationStatus = AnimationStatus.OPENING;
            ShulkerBoxBlockEntity.this.playSound(state, SoundEvents.f_12409_);
            ShulkerBoxBlockEntity.doNeighborUpdates(ShulkerBoxBlockEntity.this.m_58904_(), ShulkerBoxBlockEntity.this.f_58858_, ShulkerBoxBlockEntity.this.m_58900_());
        }

        protected void m_142289_(Level level, BlockPos pos, BlockState state) {
            ShulkerBoxBlockEntity.this.animationStatus = AnimationStatus.CLOSING;
            ShulkerBoxBlockEntity.this.playSound(state, SoundEvents.f_12408_);
            ShulkerBoxBlockEntity.doNeighborUpdates(ShulkerBoxBlockEntity.this.m_58904_(), ShulkerBoxBlockEntity.this.f_58858_, ShulkerBoxBlockEntity.this.m_58900_());
        }

        protected void m_142148_(Level level, BlockPos pos, BlockState state, int previousOpenCount, int openCount) {
        }

        protected boolean m_142718_(Player player) {
            return false;
        }
    };

    public ShulkerBoxBlockEntity(BlockPos pos, BlockState state) {
        super(pos, state, (BlockEntityType<? extends StorageBlockEntity>)((BlockEntityType)ModBlocks.SHULKER_BOX_BLOCK_ENTITY_TYPE.get()));
    }

    public static void tick(@Nullable Level level, BlockPos pos, BlockState state, ShulkerBoxBlockEntity blockEntity) {
        blockEntity.updateAnimation(level, pos, state);
    }

    private void updateAnimation(@Nullable Level level, BlockPos pos, BlockState state) {
        this.progressOld = this.progress;
        switch (this.animationStatus) {
            case CLOSED: {
                this.progress = 0.0f;
                break;
            }
            case OPENING: {
                this.progress += 0.1f;
                if (this.progress >= 1.0f) {
                    this.animationStatus = AnimationStatus.OPENED;
                    this.progress = 1.0f;
                    if (level != null) {
                        ShulkerBoxBlockEntity.doNeighborUpdates(level, pos, state);
                    }
                }
                if (level == null) break;
                this.moveCollidedEntities(level, pos, state);
                break;
            }
            case CLOSING: {
                this.progress -= 0.1f;
                if (!(this.progress <= 0.0f)) break;
                this.animationStatus = AnimationStatus.CLOSED;
                this.progress = 0.0f;
                if (level == null) break;
                ShulkerBoxBlockEntity.doNeighborUpdates(level, pos, state);
                break;
            }
            case OPENED: {
                this.progress = 1.0f;
            }
        }
    }

    @Override
    protected boolean isAllowedInStorage(ItemStack stack) {
        Block block = Block.m_49814_((Item)stack.m_41720_());
        return !(block instanceof ShulkerBoxBlock) && !(block instanceof net.minecraft.world.level.block.ShulkerBoxBlock) && !Config.SERVER.shulkerBoxDisallowedItems.isItemDisallowed(stack.m_41720_());
    }

    private static void doNeighborUpdates(Level level, BlockPos pos, BlockState state) {
        state.m_60701_((LevelAccessor)level, pos, 3);
    }

    public AnimationStatus getAnimationStatus() {
        return this.animationStatus;
    }

    public AABB getBoundingBox(BlockState state) {
        return Shulker.m_149790_((Direction)((Direction)state.m_61143_(ShulkerBoxBlock.FACING)), (float)(0.5f * this.getProgress(1.0f)));
    }

    private void moveCollidedEntities(Level level, BlockPos pos, BlockState state) {
        Direction direction;
        AABB aabb;
        List list;
        if (state.m_60734_() instanceof ShulkerBoxBlock && !(list = level.m_45933_(null, aabb = Shulker.m_149793_((Direction)(direction = (Direction)state.m_61143_(ShulkerBoxBlock.FACING)), (float)this.progressOld, (float)this.progress).m_82338_(pos))).isEmpty()) {
            for (Entity entity : list) {
                if (entity.m_7752_() == PushReaction.IGNORE) continue;
                entity.m_6478_(MoverType.SHULKER_BOX, new Vec3((aabb.m_82362_() + 0.01) * (double)direction.m_122429_(), (aabb.m_82376_() + 0.01) * (double)direction.m_122430_(), (aabb.m_82385_() + 0.01) * (double)direction.m_122431_()));
            }
        }
    }

    @Override
    public SophisticatedOpenersCounter getOpenersCounter() {
        return this.openersCounter;
    }

    @Override
    protected String getStorageType() {
        return STORAGE_TYPE;
    }

    public float getProgress(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.progressOld, (float)this.progress);
    }

    public boolean isClosed() {
        return this.animationStatus == AnimationStatus.CLOSED;
    }

    public void setAnimationStatus(AnimationStatus animationStatus) {
        this.animationStatus = animationStatus;
    }

    @Override
    public boolean shouldDropContents() {
        return false;
    }

    @Override
    public void setShouldBeOpen(boolean shouldBeOpen) {
        if (shouldBeOpen) {
            if (this.animationStatus == AnimationStatus.CLOSED) {
                this.animationStatus = AnimationStatus.OPENING;
            }
        } else if (this.animationStatus == AnimationStatus.OPENED || this.animationStatus == AnimationStatus.OPENING) {
            this.animationStatus = AnimationStatus.CLOSING;
        }
    }

    public static enum AnimationStatus {
        CLOSED,
        OPENING,
        OPENED,
        CLOSING;

    }
}

