/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.registry;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.lithostitched.worldgen.modifier.util.BiomeEffects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.BiomeSpecialEffectsBuilder;
import net.minecraftforge.common.world.ClimateSettingsBuilder;
import net.minecraftforge.common.world.ModifiableBiomeInfo;

public class LithostitchedForgeBiomeModifiers {

    public record ReplaceEffectsBiomeModifier(HolderSet<Biome> biomes, BiomeEffects effects) implements BiomeModifier
    {
        public static final Codec<ReplaceEffectsBiomeModifier> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Biome.f_47432_.fieldOf("biomes").forGetter(ReplaceEffectsBiomeModifier::biomes), (App)BiomeEffects.CODEC.fieldOf("effects").forGetter(ReplaceEffectsBiomeModifier::effects)).apply((Applicative)builder, ReplaceEffectsBiomeModifier::new));

        public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder info) {
            if (phase == BiomeModifier.Phase.MODIFY && this.biomes().m_203333_(biome)) {
                BiomeSpecialEffectsBuilder builder = info.getSpecialEffects();
                this.tryApply(BiomeEffects::fogColor, arg_0 -> ((BiomeSpecialEffectsBuilder)builder).m_48019_(arg_0));
                this.tryApply(BiomeEffects::waterColor, arg_0 -> ((BiomeSpecialEffectsBuilder)builder).m_48034_(arg_0));
                this.tryApply(BiomeEffects::waterFogColor, arg_0 -> ((BiomeSpecialEffectsBuilder)builder).m_48037_(arg_0));
                this.tryApply(BiomeEffects::skyColor, arg_0 -> ((BiomeSpecialEffectsBuilder)builder).m_48040_(arg_0));
                this.tryApply(BiomeEffects::foliageColor, arg_0 -> ((BiomeSpecialEffectsBuilder)builder).m_48043_(arg_0));
                this.tryApply(BiomeEffects::grassColor, arg_0 -> ((BiomeSpecialEffectsBuilder)builder).m_48045_(arg_0));
                this.tryApply(BiomeEffects::grassColorModifier, arg_0 -> ((BiomeSpecialEffectsBuilder)builder).m_48031_(arg_0));
                this.tryApply(BiomeEffects::ambientParticle, arg_0 -> ((BiomeSpecialEffectsBuilder)builder).m_48029_(arg_0));
                this.tryApply(BiomeEffects::ambientSound, arg_0 -> ((BiomeSpecialEffectsBuilder)builder).m_48023_(arg_0));
                this.tryApply(BiomeEffects::moodSound, arg_0 -> ((BiomeSpecialEffectsBuilder)builder).m_48027_(arg_0));
                this.tryApply(BiomeEffects::additionsSound, arg_0 -> ((BiomeSpecialEffectsBuilder)builder).m_48025_(arg_0));
                this.tryApply(BiomeEffects::music, arg_0 -> ((BiomeSpecialEffectsBuilder)builder).m_48021_(arg_0));
            }
        }

        private <T> void tryApply(Function<BiomeEffects, Optional<T>> getter, Consumer<T> applier) {
            getter.apply(this.effects).ifPresent(applier);
        }

        public Codec<? extends BiomeModifier> codec() {
            return CODEC;
        }
    }

    public record ReplaceClimateBiomeModifier(HolderSet<Biome> biomes, Biome.ClimateSettings climateSettings) implements BiomeModifier
    {
        public static final Codec<ReplaceClimateBiomeModifier> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Biome.f_47432_.fieldOf("biomes").forGetter(ReplaceClimateBiomeModifier::biomes), (App)Biome.ClimateSettings.f_47679_.fieldOf("climate").forGetter(ReplaceClimateBiomeModifier::climateSettings)).apply((Applicative)builder, ReplaceClimateBiomeModifier::new));

        public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
            if (phase == BiomeModifier.Phase.MODIFY && this.biomes().m_203333_(biome)) {
                ClimateSettingsBuilder climateSettings = builder.getClimateSettings();
                climateSettings.setTemperature(this.climateSettings().f_47681_());
                climateSettings.setDownfall(this.climateSettings().f_47683_());
                climateSettings.setHasPrecipitation(this.climateSettings().f_263819_());
                climateSettings.setTemperatureModifier(this.climateSettings().f_47682_());
            }
        }

        public Codec<? extends BiomeModifier> codec() {
            return CODEC;
        }
    }
}

