/*
 * Decompiled with CFR 0.152.
 */
package dynamic_fps.impl.util;

import dynamic_fps.impl.DynamicFPSMod;
import dynamic_fps.impl.config.BatteryTrackerConfig;
import dynamic_fps.impl.config.DynamicFPSConfig;
import dynamic_fps.impl.feature.battery.BatteryTracker;
import dynamic_fps.impl.util.BatteryUtil;
import dynamic_fps.impl.util.Components;
import dynamic_fps.impl.util.ResourceLocations;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public final class HudInfoRenderer {
    public static void renderInfo(GuiGraphics guiGraphics) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91066_.f_92062_ || minecraft.f_91080_ != null) {
            return;
        }
        if (DynamicFPSConfig.INSTANCE.batteryTracker().enabled()) {
            HudInfoRenderer.drawBatteryOverlay(guiGraphics);
        }
        if (DynamicFPSMod.disabledByUser()) {
            HudInfoRenderer.drawCenteredText(guiGraphics, (Component)Components.translatable("gui", "hud.disabled", new Object[0]));
        } else if (DynamicFPSMod.isForcingLowFPS()) {
            HudInfoRenderer.drawCenteredText(guiGraphics, (Component)Components.translatable("gui", "hud.reducing", new Object[0]));
        }
    }

    private static void drawCenteredText(GuiGraphics guiGraphics, Component component) {
        int width = guiGraphics.m_280182_() / 2;
        Minecraft minecraft = Minecraft.m_91087_();
        guiGraphics.m_280653_(minecraft.f_91062_, component, width, 32, -1);
    }

    private static void drawBatteryOverlay(GuiGraphics graphics) {
        Minecraft minecraft = Minecraft.m_91087_();
        BatteryTrackerConfig config = DynamicFPSConfig.INSTANCE.batteryTracker();
        if (!config.showWhenDebug() && minecraft.f_91066_.f_92063_ || !BatteryTracker.hasBatteries()) {
            return;
        }
        if (!config.display().condition().isConditionMet()) {
            return;
        }
        int index = BatteryTracker.charge() / 10;
        String type = BatteryUtil.isCharging(BatteryTracker.status()) ? "charging" : "draining";
        ResourceLocation icon = ResourceLocations.of("dynamic_fps", "textures/battery/icon/" + type + "_" + index + ".png");
        int[] position = config.display().placement().get(minecraft.m_91268_());
        graphics.m_280398_(icon, position[0], position[1], 0, 0.0f, 0.0f, 16, 16, 16, 16);
        graphics.m_280488_(minecraft.f_91062_, BatteryTracker.charge() + "%", position[0] + 20, position[1] + 4, -1);
    }
}

