/*
 * Decompiled with CFR 0.152.
 */
package dynamic_fps.impl.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.blaze3d.audio.Listener;
import dynamic_fps.impl.feature.volume.SmoothVolumeHandler;
import dynamic_fps.impl.util.Logging;
import dynamic_fps.impl.util.duck.DuckSoundEngine;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.ChannelAccess;
import net.minecraft.client.sounds.SoundEngine;
import net.minecraft.sounds.SoundSource;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={SoundEngine.class})
public class SoundEngineMixin
implements DuckSoundEngine {
    @Shadow
    @Final
    private Options f_120218_;
    @Shadow
    private boolean f_120219_;
    @Shadow
    @Final
    private Listener f_120221_;
    @Shadow
    @Final
    private Map<SoundInstance, ChannelAccess.ChannelHandle> f_120226_;
    @Unique
    private static final Minecraft dynamic_fps$minecraft = Minecraft.m_91087_();

    @Shadow
    private float m_120327_(SoundInstance instance) {
        throw new RuntimeException("Failed to find SoundEngine.calculateVolume.");
    }

    @Override
    public void dynamic_fps$updateVolume(SoundSource source) {
        ArrayList<SoundInstance> sounds;
        if (!this.f_120219_) {
            return;
        }
        if (source.equals((Object)SoundSource.MASTER)) {
            float volume = this.f_120218_.m_92147_(source);
            this.f_120221_.m_83737_(this.dynamic_fps$adjustVolume(volume, source));
            return;
        }
        boolean isMusic = source.equals((Object)SoundSource.MUSIC) || source.equals((Object)SoundSource.RECORDS);
        try {
            sounds = new ArrayList<SoundInstance>(this.f_120226_.keySet());
        }
        catch (Throwable e) {
            Logging.getLogger().error("Unable to update source volume!", e);
            return;
        }
        for (SoundInstance instance : sounds) {
            ChannelAccess.ChannelHandle handle = this.f_120226_.get(instance);
            if (handle == null || !instance.m_8070_().equals((Object)source)) continue;
            float volume = this.m_120327_(instance);
            handle.m_120154_(channel -> {
                if (volume <= 0.0f) {
                    if (isMusic) {
                        channel.m_83677_();
                    } else if (!dynamic_fps$minecraft.m_91104_()) {
                        channel.m_83666_(volume);
                    }
                } else {
                    if (isMusic && !dynamic_fps$minecraft.m_91104_()) {
                        channel.m_83678_();
                    }
                    channel.m_83666_(volume);
                }
            });
        }
    }

    @Inject(method={"m_120312_(Lnet/minecraft/client/resources/sounds/SoundInstance;)V", "m_120276_(Lnet/minecraft/client/resources/sounds/SoundInstance;I)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void play(SoundInstance instance, CallbackInfo callbackInfo) {
        if (SmoothVolumeHandler.volumeMultiplier(instance.m_8070_()) == 0.0f) {
            callbackInfo.cancel();
        }
    }

    @ModifyReturnValue(method={"m_120258_(Lnet/minecraft/sounds/SoundSource;)F"}, at={@At(value="RETURN")})
    private float getVolume(float original, @Local(argsOnly=true) @Nullable SoundSource source) {
        return this.dynamic_fps$adjustVolume(original, source);
    }

    @Unique
    private float dynamic_fps$adjustVolume(float value, @Nullable SoundSource source) {
        if (source == null) {
            source = SoundSource.MASTER;
        }
        return value * SmoothVolumeHandler.volumeMultiplier(source);
    }
}

