/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.item.custom;

import java.util.List;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.config.ConfigDefaultValues;
import net.sweenus.simplyswords.item.UniqueSwordItem;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.HelperMethods;

public class StarsEdgeSwordItem
extends UniqueSwordItem {
    private static int stepMod = 0;

    public StarsEdgeSwordItem(Tier toolMaterial, int attackDamage, float attackSpeed, Item.Properties settings) {
        super(toolMaterial, attackDamage, attackSpeed, settings);
    }

    @Override
    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!attacker.m_9236_().m_5776_()) {
            float skillDamageModifier = Config.getFloat("celestialSurgeDamageModifier", "UniqueEffects", ConfigDefaultValues.celestialSurgeDamageModifier);
            float skillLifestealModifier = Config.getFloat("celestialSurgeLifestealModifier", "UniqueEffects", ConfigDefaultValues.celestialSurgeLifestealModifier);
            ServerLevel world = (ServerLevel)attacker.m_9236_();
            DamageSource damageSource = world.m_269111_().m_269264_();
            float abilityDamage = this.m_43299_();
            if (attacker instanceof Player) {
                Player player = (Player)attacker;
                damageSource = attacker.m_269291_().m_269075_(player);
            }
            HelperMethods.playHitSounds(attacker, target);
            if (world.m_46461_()) {
                target.f_19802_ = 0;
                target.m_6469_(damageSource, abilityDamage * skillDamageModifier);
            } else if (world.m_46462_()) {
                attacker.m_5634_(abilityDamage * skillLifestealModifier);
            }
        }
        return super.m_7579_(stack, target, attacker);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        int skillCooldown = (int)Config.getFloat("celestialSurgeCooldown", "UniqueEffects", ConfigDefaultValues.celestialSurgeCooldown);
        int skillDuration = (int)Config.getFloat("celestialSurgeDuration", "UniqueEffects", ConfigDefaultValues.celestialSurgeDuration);
        int skillStacks = (int)Config.getFloat("celestialSurgeStacks", "UniqueEffects", ConfigDefaultValues.celestialSurgeStacks);
        if (!user.m_21023_(MobEffects.f_19596_)) {
            user.m_6674_(hand);
            world.m_5594_(null, user.m_20183_(), (SoundEvent)SoundRegistry.ELEMENTAL_BOW_HOLY_SHOOT_IMPACT_02.get(), user.m_5720_(), 0.3f, 1.0f);
            user.m_20256_(user.m_20154_().m_82548_().m_82490_(1.5));
            user.m_20334_(user.m_20184_().f_82479_, 0.0, user.m_20184_().f_82481_);
            user.f_19864_ = true;
            HelperMethods.incrementStatusEffect((LivingEntity)user, MobEffects.f_19596_, skillDuration, 1, 2);
        } else {
            MobEffectInstance speedEffect = user.m_21124_(MobEffects.f_19596_);
            if (speedEffect != null && speedEffect.m_19557_() < skillDuration - 10) {
                world.m_5594_(null, user.m_20183_(), (SoundEvent)SoundRegistry.ELEMENTAL_BOW_HOLY_SHOOT_IMPACT_01.get(), user.m_5720_(), 0.5f, 1.3f);
                user.m_20256_(user.m_20154_().m_82490_(1.7));
                user.m_20334_(user.m_20184_().f_82479_, 0.0, user.m_20184_().f_82481_);
                user.f_19864_ = true;
                user.m_21195_(MobEffects.f_19596_);
                HelperMethods.incrementStatusEffect((LivingEntity)user, MobEffects.f_19606_, skillDuration / 2, 2, 3);
                HelperMethods.incrementStatusEffect((LivingEntity)user, MobEffects.f_19598_, skillDuration / 2, skillStacks, 7);
                user.m_36335_().m_41524_((Item)this, skillCooldown);
            }
        }
        return super.m_7203_(world, user, hand);
    }

    @Override
    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        if (stepMod > 0) {
            --stepMod;
        }
        if (stepMod <= 0) {
            stepMod = 7;
        }
        HelperMethods.createFootfalls(entity, stack, world, stepMod, ParticleTypes.f_123787_, ParticleTypes.f_123757_, ParticleTypes.f_123757_, true);
        super.m_6883_(stack, world, entity, slot, selected);
    }

    @Override
    public void m_7373_(ItemStack itemStack, Level world, List<Component> tooltip, TooltipFlag tooltipContext) {
        Style RIGHTCLICK = HelperMethods.getStyle("rightclick");
        Style ABILITY = HelperMethods.getStyle("ability");
        Style TEXT = HelperMethods.getStyle("text");
        float skillDamageModifier = Config.getFloat("celestialSurgeDamageModifier", "UniqueEffects", ConfigDefaultValues.celestialSurgeDamageModifier);
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.starsedgesworditem.tooltip1").m_6270_(ABILITY));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.starsedgesworditem.tooltip2").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237110_((String)"item.simplyswords.starsedgesworditem.tooltip3", (Object[])new Object[]{Float.valueOf(this.m_43299_() * skillDamageModifier)}).m_6270_(TEXT));
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.starsedgesworditem.tooltip4").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.onrightclick").m_6270_(RIGHTCLICK));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.starsedgesworditem.tooltip5").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.starsedgesworditem.tooltip6").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.starsedgesworditem.tooltip7").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.starsedgesworditem.tooltip8").m_6270_(TEXT));
        super.m_7373_(itemStack, world, tooltip, tooltipContext);
    }
}

