/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.item.custom;

import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.config.ConfigDefaultValues;
import net.sweenus.simplyswords.item.UniqueSwordItem;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.HelperMethods;

public class FireSwordItem
extends UniqueSwordItem {
    private static int stepMod = 0;

    public FireSwordItem(Tier toolMaterial, int attackDamage, float attackSpeed, Item.Properties settings) {
        super(toolMaterial, attackDamage, attackSpeed, settings);
    }

    @Override
    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!attacker.m_9236_().m_5776_()) {
            ServerLevel world = (ServerLevel)attacker.m_9236_();
            int fhitchance = (int)Config.getFloat("brimstoneChance", "UniqueEffects", ConfigDefaultValues.brimstoneChance);
            HelperMethods.playHitSounds(attacker, target);
            if (attacker.m_217043_().m_188503_(100) <= fhitchance && attacker instanceof Player) {
                Player player = (Player)attacker;
                int choose_sound = (int)(Math.random() * 3.0);
                List<LivingEntity> nearbyEntities = HelperMethods.getNearbyLivingEntities((Level)world, target.m_20182_(), 3.0);
                DamageSource damageSource = player.m_269291_().m_269104_((Entity)player, (Entity)player);
                for (LivingEntity livingEntity : nearbyEntities) {
                    if (!HelperMethods.checkFriendlyFire(livingEntity, attacker)) continue;
                    HelperMethods.spawnWaistHeightParticles(world, (ParticleOptions)ParticleTypes.f_123756_, (Entity)attacker, (Entity)target, 3);
                    HelperMethods.spawnOrbitParticles(world, livingEntity.m_20182_(), (ParticleOptions)ParticleTypes.f_123756_, 1.0, 3);
                    HelperMethods.spawnOrbitParticles(world, livingEntity.m_20182_(), (ParticleOptions)ParticleTypes.f_123778_, 2.0, 6);
                    HelperMethods.spawnOrbitParticles(world, livingEntity.m_20182_(), (ParticleOptions)ParticleTypes.f_123759_, 1.0, 10);
                    HelperMethods.spawnOrbitParticles(world, livingEntity.m_20182_(), (ParticleOptions)ParticleTypes.f_123813_, 0.5, 2);
                    HelperMethods.spawnOrbitParticles(world, livingEntity.m_20182_(), (ParticleOptions)ParticleTypes.f_123785_, 1.0, 10);
                    livingEntity.m_20254_(3);
                    livingEntity.m_147240_(1.0, 0.1, 0.1);
                    livingEntity.f_19802_ = 0;
                    livingEntity.m_6469_(damageSource, (float)HelperMethods.getAttackDamage(stack));
                    livingEntity.f_19802_ = 0;
                }
                if (choose_sound <= 1) {
                    world.m_6269_(null, (Entity)target, (SoundEvent)SoundRegistry.ELEMENTAL_BOW_FIRE_SHOOT_IMPACT_01.get(), target.m_5720_(), 0.5f, 1.2f);
                }
                if (choose_sound == 2) {
                    world.m_6269_(null, (Entity)target, (SoundEvent)SoundRegistry.ELEMENTAL_BOW_FIRE_SHOOT_IMPACT_02.get(), target.m_5720_(), 0.7f, 1.1f);
                }
                if (choose_sound == 3) {
                    world.m_6269_(null, (Entity)target, (SoundEvent)SoundRegistry.ELEMENTAL_BOW_FIRE_SHOOT_IMPACT_03.get(), target.m_5720_(), 0.9f, 1.0f);
                }
            }
        }
        return super.m_7579_(stack, target, attacker);
    }

    @Override
    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        if (stepMod > 0) {
            --stepMod;
        }
        if (stepMod <= 0) {
            stepMod = 7;
        }
        HelperMethods.createFootfalls(entity, stack, world, stepMod, ParticleTypes.f_123801_, ParticleTypes.f_123801_, ParticleTypes.f_123762_, true);
        super.m_6883_(stack, world, entity, slot, selected);
    }

    @Override
    public void m_7373_(ItemStack itemStack, Level world, List<Component> tooltip, TooltipFlag tooltipContext) {
        Style TEXT = HelperMethods.getStyle("text");
        Style ABILITY = HelperMethods.getStyle("ability");
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.firesworditem.tooltip1").m_6270_(ABILITY));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.firesworditem.tooltip2").m_6270_(TEXT));
        super.m_7373_(itemStack, world, tooltip, tooltipContext);
    }
}

