/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.item;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.config.ConfigDefaultValues;
import net.sweenus.simplyswords.registry.EffectRegistry;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.HelperMethods;
import net.sweenus.simplyswords.util.RunicMethods;

public class RunicSwordItem
extends SwordItem {
    public static int maxUseTime;

    public RunicSwordItem(Tier toolMaterial, int attackDamage, float attackSpeed, Item.Properties settings) {
        super(toolMaterial, attackDamage, attackSpeed, settings.m_41486_());
    }

    public boolean m_142305_(ItemStack stack, ItemStack otherStack, Slot slot, ClickAction clickType, Player player, SlotAccess cursorStackReference) {
        if (stack.m_41784_().m_128461_("runic_power").isEmpty()) {
            String runicPowerSelection = HelperMethods.chooseRunicPower();
            stack.m_41784_().m_128359_("runic_power", runicPowerSelection);
        }
        return false;
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!attacker.m_9236_().m_5776_()) {
            HelperMethods.playHitSounds(attacker, target);
            switch (stack.m_41784_().m_128461_("runic_power")) {
                case "freeze": {
                    RunicMethods.postHitRunicFreeze(target, attacker);
                    break;
                }
                case "wildfire": {
                    RunicMethods.postHitRunicWildfire(target, attacker);
                    break;
                }
                case "slow": {
                    RunicMethods.postHitRunicSlow(target, attacker);
                    break;
                }
                case "greater_slow": {
                    RunicMethods.postHitRunicGreaterSlow(target, attacker);
                    break;
                }
                case "swiftness": {
                    RunicMethods.postHitRunicSwiftness(attacker);
                    break;
                }
                case "greater_swiftness": {
                    RunicMethods.postHitRunicGreaterSwiftness(attacker);
                    break;
                }
                case "float": {
                    RunicMethods.postHitRunicFloat(target, attacker);
                    break;
                }
                case "greater_float": {
                    RunicMethods.postHitRunicGreaterFloat(target, attacker);
                    break;
                }
                case "zephyr": {
                    RunicMethods.postHitRunicZephyr(attacker);
                    break;
                }
                case "greater_zephyr": {
                    RunicMethods.postHitRunicGreaterZephyr(attacker);
                    break;
                }
                case "shielding": {
                    RunicMethods.postHitRunicShielding(attacker);
                    break;
                }
                case "greater_shielding": {
                    RunicMethods.postHitRunicGreaterShielding(attacker);
                    break;
                }
                case "stoneskin": {
                    RunicMethods.postHitRunicStoneskin(attacker);
                    break;
                }
                case "greater_stoneskin": {
                    RunicMethods.postHitRunicGreaterStoneskin(attacker);
                    break;
                }
                case "trailblaze": {
                    RunicMethods.postHitRunicTrailblaze(attacker);
                    break;
                }
                case "greater_trailblaze": {
                    RunicMethods.postHitRunicGreaterTrailblaze(attacker);
                    break;
                }
                case "weaken": {
                    RunicMethods.postHitRunicWeaken(target, attacker);
                    break;
                }
                case "greater_weaken": {
                    RunicMethods.postHitRunicGreaterWeaken(target, attacker);
                    break;
                }
                case "imbued": {
                    RunicMethods.postHitRunicImbued(stack, target, attacker);
                    break;
                }
                case "greater_imbued": {
                    RunicMethods.postHitRunicGreaterImbued(stack, target, attacker);
                    break;
                }
                case "pincushion": {
                    RunicMethods.postHitRunicPinCushion(target, attacker);
                    break;
                }
                case "greater_pincushion": {
                    RunicMethods.postHitRunicGreaterPinCushion(target, attacker);
                }
            }
        }
        return super.m_7579_(stack, target, attacker);
    }

    public void m_5551_(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks) {
        if (!world.f_46443_ && stack.m_41784_().m_128461_("runic_power").contains("momentum")) {
            RunicMethods.stoppedUsingRunicMomentum(stack, user);
        }
    }

    public void m_5929_(Level world, LivingEntity user, ItemStack stack, int remainingUseTicks) {
        if (!world.f_46443_) {
            if (stack.m_41784_().m_128461_("runic_power").equals("momentum")) {
                RunicMethods.usageTickRunicMomentum(stack, user, remainingUseTicks);
            } else if (stack.m_41784_().m_128461_("runic_power").equals("greater_momentum")) {
                RunicMethods.usageTickRunicGreaterMomentum(stack, user, remainingUseTicks);
            }
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        ItemStack itemStack = user.m_21120_(hand);
        if (itemStack.m_41773_() < itemStack.m_41776_() - 1) {
            switch (itemStack.m_41784_().m_128461_("runic_power")) {
                case "momentum": 
                case "greater_momentum": {
                    user.m_6672_(hand);
                    world.m_6269_(null, (Entity)user, (SoundEvent)SoundRegistry.ELEMENTAL_BOW_WIND_SHOOT_FLYBY_02.get(), user.m_5720_(), 0.3f, 1.2f);
                    return InteractionResultHolder.m_19096_((Object)itemStack);
                }
                case "ward": {
                    user.m_6672_(hand);
                    user.m_147207_(new MobEffectInstance((MobEffect)EffectRegistry.WARD.get(), 120, 0), (Entity)user);
                    user.m_36335_().m_41524_(itemStack.m_41720_(), 120);
                    user.m_21153_(user.m_21223_() / 2.0f);
                    world.m_6269_(null, (Entity)user, (SoundEvent)SoundRegistry.MAGIC_SWORD_SPELL_02.get(), user.m_5720_(), 0.3f, 1.2f);
                    return InteractionResultHolder.m_19096_((Object)itemStack);
                }
                case "immolation": {
                    user.m_6672_(hand);
                    user.m_147207_(new MobEffectInstance((MobEffect)EffectRegistry.IMMOLATION.get(), 36000, 0), (Entity)user);
                    user.m_36335_().m_41524_(itemStack.m_41720_(), 40);
                    world.m_6269_(null, (Entity)user, (SoundEvent)SoundRegistry.MAGIC_SWORD_SPELL_02.get(), user.m_5720_(), 0.3f, 0.6f);
                    return InteractionResultHolder.m_19096_((Object)itemStack);
                }
            }
        }
        return InteractionResultHolder.m_19100_((Object)itemStack);
    }

    public int m_8105_(ItemStack stack) {
        String power = stack.m_41784_().m_128461_("runic_power");
        if (power.equals("momentum")) {
            maxUseTime = 15;
        } else if (power.equals("ward") || power.equals("immolation")) {
            maxUseTime = 1;
        }
        return maxUseTime;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BLOCK;
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        LivingEntity user;
        if (entity instanceof LivingEntity && ((user = (LivingEntity)entity).m_6844_(EquipmentSlot.MAINHAND) == stack || user.m_6844_(EquipmentSlot.OFFHAND) == stack)) {
            if (entity.f_19797_ % 4 == 0 && Config.getBoolean("enablePassiveParticles", "General", ConfigDefaultValues.enablePassiveParticles)) {
                float randomx = (float)(Math.random() * 6.0);
                float randomz = (float)(Math.random() * 6.0);
                world.m_7106_((ParticleOptions)ParticleTypes.f_123809_, user.m_20185_() + user.m_204034_((Item)this).m_7096_(), user.m_20186_() + user.m_204034_((Item)this).m_7098_() + 1.3, user.m_20189_() + user.m_204034_((Item)this).m_7094_(), (double)(-3.0f + randomx), 0.0, (double)(-3.0f + randomz));
            }
            if (!world.f_46443_) {
                switch (stack.m_41784_().m_128461_("runic_power")) {
                    case "unstable": {
                        RunicMethods.inventoryTickRunicUnstable(user);
                        break;
                    }
                    case "active_defence": {
                        RunicMethods.inventoryTickRunicActiveDefence(world, user);
                        break;
                    }
                    case "frost_ward": {
                        RunicMethods.inventoryTickRunicFrostWard(world, user);
                    }
                }
            }
        }
        super.m_6883_(stack, world, entity, slot, selected);
    }

    public void m_7836_(ItemStack stack, Level world, Player player) {
        if (world.f_46443_) {
            return;
        }
        String runicPowerSelection = HelperMethods.chooseRunicPower();
        stack.m_41784_().m_128359_("runic_power", runicPowerSelection);
    }

    public Component m_7626_(ItemStack stack) {
        Style RUNIC = HelperMethods.getStyle("runic");
        return Component.m_237115_((String)this.m_5671_(stack)).m_6270_(RUNIC);
    }

    public void m_7373_(ItemStack itemStack, Level world, List<Component> tooltip, TooltipFlag tooltipContext) {
        Style RIGHTCLICK = HelperMethods.getStyle("rightclick");
        Style RUNIC = HelperMethods.getStyle("runic");
        Style TEXT = HelperMethods.getStyle("text");
        tooltip.add((Component)Component.m_237113_((String)"").m_6270_(TEXT));
        if (itemStack.m_41784_().m_128461_("runic_power").isEmpty()) {
            tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.unidentifiedsworditem.tooltip1").m_6270_(RUNIC));
            tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.unidentifiedsworditem.tooltip2").m_6270_(TEXT));
        } else {
            if (itemStack.m_41784_().m_128461_("runic_power").contains("greater")) {
                tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.greater_runic_power").m_6270_(RUNIC).m_130940_(ChatFormatting.BOLD));
            }
            switch (itemStack.m_41784_().m_128461_("runic_power")) {
                case "freeze": {
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.freezesworditem.tooltip1").m_6270_(RUNIC));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.freezesworditem.tooltip2").m_6270_(TEXT));
                    break;
                }
                case "wildfire": {
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.wildfiresworditem.tooltip1").m_6270_(RUNIC));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.wildfiresworditem.tooltip2").m_6270_(TEXT));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.wildfiresworditem.tooltip3").m_6270_(TEXT));
                    break;
                }
                case "slow": 
                case "greater_slow": {
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.slownesssworditem.tooltip1").m_6270_(RUNIC));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.slownesssworditem.tooltip2").m_6270_(TEXT));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.slownesssworditem.tooltip3").m_6270_(TEXT));
                    break;
                }
                case "swiftness": 
                case "greater_swiftness": {
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.speedsworditem.tooltip1").m_6270_(RUNIC));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.speedsworditem.tooltip2").m_6270_(TEXT));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.speedsworditem.tooltip3").m_6270_(TEXT));
                    break;
                }
                case "float": 
                case "greater_float": {
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.levitationsworditem.tooltip1").m_6270_(RUNIC));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.levitationsworditem.tooltip2").m_6270_(TEXT));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.levitationsworditem.tooltip3").m_6270_(TEXT));
                    break;
                }
                case "zephyr": 
                case "greater_zephyr": {
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.zephyrsworditem.tooltip1").m_6270_(RUNIC));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.zephyrsworditem.tooltip2").m_6270_(TEXT));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.zephyrsworditem.tooltip3").m_6270_(TEXT));
                    break;
                }
                case "shielding": 
                case "greater_shielding": {
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.shieldingsworditem.tooltip1").m_6270_(RUNIC));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.shieldingsworditem.tooltip2").m_6270_(TEXT));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.shieldingsworditem.tooltip3").m_6270_(TEXT));
                    break;
                }
                case "stoneskin": 
                case "greater_stoneskin": {
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.stoneskinsworditem.tooltip1").m_6270_(RUNIC));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.stoneskinsworditem.tooltip2").m_6270_(TEXT));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.stoneskinsworditem.tooltip3").m_6270_(TEXT));
                    break;
                }
                case "frost_ward": {
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.frostwardsworditem.tooltip1").m_6270_(RUNIC));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.frostwardsworditem.tooltip2").m_6270_(TEXT));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.frostwardsworditem.tooltip3").m_6270_(TEXT));
                    break;
                }
                case "trailblaze": 
                case "greater_trailblaze": {
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.trailblazesworditem.tooltip1").m_6270_(RUNIC));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.trailblazesworditem.tooltip2").m_6270_(TEXT));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.trailblazesworditem.tooltip3").m_6270_(TEXT));
                    break;
                }
                case "active_defence": {
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.activedefencesworditem.tooltip1").m_6270_(RUNIC));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.activedefencesworditem.tooltip2").m_6270_(TEXT));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.activedefencesworditem.tooltip3").m_6270_(TEXT));
                    break;
                }
                case "weaken": 
                case "greater_weaken": {
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.weakensworditem.tooltip1").m_6270_(RUNIC));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.weakensworditem.tooltip2").m_6270_(TEXT));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.weakensworditem.tooltip3").m_6270_(TEXT));
                    break;
                }
                case "unstable": {
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.unstablesworditem.tooltip1").m_6270_(RUNIC));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.unstablesworditem.tooltip2").m_6270_(TEXT));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.unstablesworditem.tooltip3").m_6270_(TEXT));
                    break;
                }
                case "momentum": 
                case "greater_momentum": {
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.momentumsworditem.tooltip1").m_6270_(RUNIC));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.momentumsworditem.tooltip2").m_6270_(TEXT));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.momentumsworditem.tooltip3").m_6270_(TEXT));
                    break;
                }
                case "imbued": 
                case "greater_imbued": {
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.imbuedsworditem.tooltip1").m_6270_(RUNIC));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.imbuedsworditem.tooltip2").m_6270_(TEXT));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.imbuedsworditem.tooltip3").m_6270_(TEXT));
                    break;
                }
                case "pincushion": 
                case "greater_pincushion": {
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.pincushionsworditem.tooltip1").m_6270_(RUNIC));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.pincushionsworditem.tooltip2").m_6270_(TEXT));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.pincushionsworditem.tooltip3").m_6270_(TEXT));
                    break;
                }
                case "ward": {
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.wardsworditem.tooltip1").m_6270_(RUNIC));
                    tooltip.add((Component)Component.m_237113_((String)""));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.onrightclick").m_6270_(RIGHTCLICK));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.wardsworditem.tooltip2").m_6270_(TEXT));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.wardsworditem.tooltip3").m_6270_(TEXT));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.wardsworditem.tooltip4").m_6270_(TEXT));
                    break;
                }
                case "immolation": {
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.immolationsworditem.tooltip1").m_6270_(RUNIC));
                    tooltip.add((Component)Component.m_237113_((String)""));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.onrightclick").m_6270_(RIGHTCLICK));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.immolationsworditem.tooltip2").m_6270_(TEXT));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.immolationsworditem.tooltip3").m_6270_(TEXT));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.immolationsworditem.tooltip4").m_6270_(TEXT));
                }
            }
        }
    }
}

