/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.effect;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.AABB;
import net.sweenus.simplyswords.effect.WideOrbitingEffect;
import net.sweenus.simplyswords.effect.instance.SimplySwordsStatusEffectInstance;
import net.sweenus.simplyswords.item.custom.BrambleSwordItem;
import net.sweenus.simplyswords.registry.EffectRegistry;
import net.sweenus.simplyswords.util.HelperMethods;

public class SporeSwarmEffect
extends WideOrbitingEffect {
    public SporeSwarmEffect(MobEffectCategory statusEffectCategory, int color) {
        super(statusEffectCategory, color);
        this.setParticleType1((ParticleOptions)ParticleTypes.f_123762_);
        this.setParticleType2((ParticleOptions)ParticleTypes.f_123783_);
        this.setParticleType3((ParticleOptions)ParticleTypes.f_123785_);
    }

    @Override
    public void m_6742_(LivingEntity livingEntity, int amplifier) {
        if (!livingEntity.m_9236_().m_5776_()) {
            ServerLevel world = (ServerLevel)livingEntity.m_9236_();
            double x = livingEntity.m_20185_();
            double y = livingEntity.m_20186_();
            double z = livingEntity.m_20189_();
            double radius = 1.0 + (double)amplifier * 0.5;
            int maxAmp = 49;
            if (livingEntity.f_19797_ % 15 == 0) {
                AABB box = new AABB(x + radius, y + 1.0, z + radius, x - radius, y - 1.0, z - radius);
                for (Entity e : world.m_6249_((Entity)livingEntity, box, EntitySelector.f_20403_)) {
                    LivingEntity ee;
                    if (!(e instanceof LivingEntity) || !HelperMethods.checkFriendlyFire(ee = (LivingEntity)e, livingEntity)) continue;
                    HelperMethods.incrementStatusEffect(ee, MobEffects.f_19597_, 40, 1, 3);
                    HelperMethods.incrementStatusEffect(ee, MobEffects.f_19599_, 40, 1, 2);
                    if (!(livingEntity.m_21205_().m_41720_() instanceof BrambleSwordItem) && !(livingEntity.m_21206_().m_41720_() instanceof BrambleSwordItem)) {
                        maxAmp = 9;
                    }
                    if (livingEntity.m_21205_().m_41720_() instanceof BrambleSwordItem && livingEntity.m_21206_().m_41720_() instanceof BrambleSwordItem) {
                        maxAmp = 74;
                    }
                    SimplySwordsStatusEffectInstance effect = HelperMethods.incrementSimplySwordsStatusEffect(ee, (MobEffect)EffectRegistry.PAIN.get(), 60, 1, maxAmp);
                    effect.setSourceEntity(livingEntity);
                    effect.setAdditionalData(0);
                    ee.m_7292_((MobEffectInstance)effect);
                    HelperMethods.spawnWaistHeightParticles(world, (ParticleOptions)ParticleTypes.f_123762_, (Entity)ee, (Entity)livingEntity, 10);
                    HelperMethods.incrementStatusEffect(livingEntity, (MobEffect)EffectRegistry.SPORE_SWARM.get(), 200, 1, 4);
                }
            }
        }
        super.m_6742_(livingEntity, amplifier);
    }

    @Override
    public boolean m_6584_(int duration, int amplifier) {
        return super.m_6584_(duration, amplifier);
    }
}

