/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.util;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.merchantpug.apugli.access.ItemStackAccess;
import net.merchantpug.apugli.platform.Services;
import net.merchantpug.apugli.power.EdibleItemPower;
import net.merchantpug.apugli.registry.power.ApugliPowers;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import org.jetbrains.annotations.Nullable;

public class CoreUtil {
    public static int getModifiedEnchantmentLevel(int original, ItemStack stack, Enchantment enchantment) {
        Entity entity = ((ItemStackAccess)stack).apugli$getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (ApugliPowers.MODIFY_ENCHANTMENT_LEVEL.get().getEntityItemEnchants().containsKey(living.m_20148_())) {
                return (int)Services.PLATFORM.applyModifiers(living, ApugliPowers.MODIFY_ENCHANTMENT_LEVEL.get(), original, p -> ApugliPowers.MODIFY_ENCHANTMENT_LEVEL.get().doesApply(p, enchantment, living.m_9236_(), stack));
            }
        }
        return original;
    }

    public static Map<Enchantment, Integer> getModifiedEnchantments(Map<Enchantment, Integer> original, ItemStack stack) {
        Entity entity = ((ItemStackAccess)stack).apugli$getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (ApugliPowers.MODIFY_ENCHANTMENT_LEVEL.get().getEntityItemEnchants().containsKey(living.m_20148_())) {
                ListTag serializedEnchantments = CoreUtil.serializeEnchantments(original);
                return EnchantmentHelper.m_44882_((ListTag)ApugliPowers.MODIFY_ENCHANTMENT_LEVEL.get().getEnchantments(stack, serializedEnchantments));
            }
        }
        return original;
    }

    private static ListTag serializeEnchantments(Map<Enchantment, Integer> deserialized) {
        ListTag tag = new ListTag();
        List entryList = deserialized.entrySet().stream().toList();
        for (int i = 0; i < entryList.size(); ++i) {
            ResourceLocation key = EnchantmentHelper.m_182432_((Enchantment)((Enchantment)((Map.Entry)entryList.get(i)).getKey()));
            if (key == null) continue;
            tag.add(i, (Tag)EnchantmentHelper.m_182443_((ResourceLocation)key, (int)((Integer)((Map.Entry)entryList.get(i)).getValue())));
        }
        return tag;
    }

    public static boolean doEdibleItemPowersApply(ItemStack stack, @Nullable LivingEntity entity) {
        return entity != null && Services.POWER.getPowers(entity, ApugliPowers.EDIBLE_ITEM.get()).stream().anyMatch(p -> p.doesApply(entity.m_9236_(), stack));
    }

    public static FoodProperties getEdibleItemPowerFoodProperties(ItemStack stack, @Nullable LivingEntity entity) {
        if (entity == null) {
            return stack.m_41720_().getFoodProperties(stack, null);
        }
        Optional<EdibleItemPower> power = Services.POWER.getPowers(entity, ApugliPowers.EDIBLE_ITEM.get()).stream().filter(p -> p.doesApply(entity.m_9236_(), stack)).findFirst();
        return power.map(EdibleItemPower::getFoodComponent).orElse(stack.m_41720_().getFoodProperties(stack, entity));
    }
}

