/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.power.integration.pehkui;

import com.google.auto.service.AutoService;
import com.mojang.serialization.Codec;
import io.github.edwinmindcraft.apoli.api.ApoliAPI;
import io.github.edwinmindcraft.apoli.api.component.IPowerContainer;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredPower;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.merchantpug.apugli.integration.pehkui.PehkuiUtil;
import net.merchantpug.apugli.power.AbstractValueModifyingPower;
import net.merchantpug.apugli.power.configuration.FabricValueModifyingConfiguration;
import net.merchantpug.apugli.power.factory.ModifyScalePowerFactory;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.fml.ModList;

@AutoService(value={ModifyScalePowerFactory.class})
public class ModifyScalePower
extends AbstractValueModifyingPower
implements ModifyScalePowerFactory<ConfiguredPower<FabricValueModifyingConfiguration, ?>> {
    public ModifyScalePower() {
        super((Codec<FabricValueModifyingConfiguration>)ModifyScalePowerFactory.getSerializableData().xmap(FabricValueModifyingConfiguration::new, FabricValueModifyingConfiguration::data).codec());
        this.ticking(true);
    }

    protected PowerData access(ConfiguredPower<FabricValueModifyingConfiguration, ?> configuration, IPowerContainer container) {
        return (PowerData)configuration.getPowerData(container, () -> new PowerData(configuration, container.getOwner()));
    }

    public void onAdded(ConfiguredPower<FabricValueModifyingConfiguration, ?> power, Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            PehkuiUtil.onAddedOrRespawnedScalePower(power, living);
        }
    }

    public void onRespawn(ConfiguredPower<FabricValueModifyingConfiguration, ?> power, Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            PehkuiUtil.onAddedOrRespawnedScalePower(power, living);
        }
    }

    public void onRemoved(ConfiguredPower<FabricValueModifyingConfiguration, ?> power, Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            PehkuiUtil.onRemovedScalePower(power, living);
        }
    }

    public void onLost(ConfiguredPower<FabricValueModifyingConfiguration, ?> power, Entity entity) {
        PehkuiUtil.resetScalePower(this.access(power, (IPowerContainer)ApoliAPI.getPowerContainer((Entity)entity)).apoliScaleModifier);
    }

    public void serialize(ConfiguredPower<FabricValueModifyingConfiguration, ?> configuration, IPowerContainer container, CompoundTag tag) {
        Entity entity = container.getOwner();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            PehkuiUtil.serializeScalePower(configuration, living, tag);
        }
    }

    public void deserialize(ConfiguredPower<FabricValueModifyingConfiguration, ?> configuration, IPowerContainer container, CompoundTag tag) {
        Entity entity = container.getOwner();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            PehkuiUtil.deserializeScalePower(configuration, living, tag);
        }
    }

    @Override
    public ResourceLocation getPowerId(ConfiguredPower<FabricValueModifyingConfiguration, ?> power) {
        return power.getRegistryName();
    }

    @Override
    public Object getApoliScaleModifier(ConfiguredPower<FabricValueModifyingConfiguration, ?> power, Entity entity) {
        return this.access(power, (IPowerContainer)ApoliAPI.getPowerContainer((Entity)entity)).apoliScaleModifier;
    }

    @Override
    public List<?> getDelayModifiers(ConfiguredPower<FabricValueModifyingConfiguration, ?> power, Entity entity) {
        ArrayList modifiers = new ArrayList();
        this.getDataFromPower(power).ifPresent("delay_modifiers", modifiers::addAll);
        this.getDataFromPower(power).ifPresent("delay_modifier", modifiers::add);
        return modifiers;
    }

    @Override
    public Set<ResourceLocation> getCachedScaleIds(ConfiguredPower<FabricValueModifyingConfiguration, ?> power, Entity entity) {
        return this.access(power, (IPowerContainer)ApoliAPI.getPowerContainer((Entity)entity)).cachedScaleIds;
    }

    public static class PowerData {
        private final Object apoliScaleModifier;
        private final Set<ResourceLocation> cachedScaleIds;

        public PowerData(ConfiguredPower<FabricValueModifyingConfiguration, ?> power, Entity entity) {
            if (ModList.get().isLoaded("pehkui") && entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                this.cachedScaleIds = PehkuiUtil.getTypesFromCache(((FabricValueModifyingConfiguration)power.getConfiguration()).data());
                this.apoliScaleModifier = PehkuiUtil.createApoliScaleModifier(power, living, ((FabricValueModifyingConfiguration)power.getConfiguration()).data());
            } else {
                this.cachedScaleIds = Set.of();
                this.apoliScaleModifier = null;
            }
        }
    }
}

