/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.power.factory;

import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.merchantpug.apugli.access.ItemStackAccess;
import net.merchantpug.apugli.mixin.xplatform.common.accessor.SlotArgumentAccessor;
import net.merchantpug.apugli.network.s2c.ModifyEnchantmentLevelPacket;
import net.merchantpug.apugli.platform.Services;
import net.merchantpug.apugli.power.factory.ValueModifyingPowerFactory;
import net.merchantpug.apugli.registry.power.ApugliPowers;
import net.merchantpug.apugli.util.ComparableItemStack;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public interface ModifyEnchantmentLevelPowerFactory<P>
extends ValueModifyingPowerFactory<P> {
    public static final ConcurrentHashMap<UUID, ItemStack> ENTITY_EMPTY_STACK_MAP = new ConcurrentHashMap();

    public static boolean isWorkableEmptyStack(Entity entity, SlotAccess slotAccess) {
        return slotAccess != null && slotAccess != SlotAccess.f_147290_ && slotAccess.m_142196_().m_41619_() && ENTITY_EMPTY_STACK_MAP.containsKey(entity.m_20148_()) && slotAccess.m_142196_() == ENTITY_EMPTY_STACK_MAP.get(entity.m_20148_());
    }

    public static ItemStack getWorkableEmptyStack(@NotNull Entity entity) {
        if (!ApugliPowers.MODIFY_ENCHANTMENT_LEVEL.get().getEntityItemEnchants().containsKey(entity.m_20148_())) {
            return ItemStack.f_41583_;
        }
        if (!ENTITY_EMPTY_STACK_MAP.containsKey(entity.m_20148_())) {
            ItemStack stack = new ItemStack((Void)null);
            ((ItemStackAccess)stack).apugli$setEntity(entity);
            ENTITY_EMPTY_STACK_MAP.put(entity.m_20148_(), stack);
        }
        return ENTITY_EMPTY_STACK_MAP.get(entity.m_20148_());
    }

    public static SerializableData getSerializableData() {
        return ValueModifyingPowerFactory.getSerializableData().add("enchantment", SerializableDataTypes.ENCHANTMENT).add("item_condition", Services.CONDITION.itemDataType(), null);
    }

    default public void onAdded(P power, Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity living = (LivingEntity)entity;
        this.getEntityItemEnchants().computeIfAbsent(living.m_20148_(), _living -> new ConcurrentHashMap());
        ConcurrentHashMap cache = this.getPowerModifierCache().computeIfAbsent(living.m_20148_(), _living -> new ConcurrentHashMap());
        cache.compute(power, (p, _val) -> new Tuple((Object)0, (Object)false));
        if (entity.m_9236_().m_5776_()) {
            return;
        }
        Services.PLATFORM.sendS2CTrackingAndSelf(new ModifyEnchantmentLevelPacket(entity.m_19879_(), Services.POWER.getPowerId(power), false), entity);
    }

    default public void tick(P power, Entity entity) {
        for (int slot : SlotArgumentAccessor.apugli$getSlots().values()) {
            ItemStack stack;
            SlotAccess slotAccess = entity.m_141942_(slot);
            if (slotAccess == SlotAccess.f_147290_ || ((ItemStackAccess)slotAccess.m_142196_()).apugli$getEntity() != null || !(stack = slotAccess.m_142196_()).m_41619_() || ModifyEnchantmentLevelPowerFactory.isWorkableEmptyStack(entity, slotAccess)) continue;
            slotAccess.m_142104_(ModifyEnchantmentLevelPowerFactory.getWorkableEmptyStack(entity));
        }
    }

    default public void onRemoved(P power, Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity living = (LivingEntity)entity;
        this.getPowerModifierCache().computeIfAbsent(living.m_20148_(), _living -> new ConcurrentHashMap()).remove(power);
        if (Services.POWER.getPowers(living, this).size() - 1 == 0) {
            for (int slot : SlotArgumentAccessor.apugli$getSlots().values()) {
                SlotAccess slotAccess = entity.m_141942_(slot);
                if (slotAccess == SlotAccess.f_147290_ || !ModifyEnchantmentLevelPowerFactory.isWorkableEmptyStack(entity, slotAccess)) continue;
                slotAccess.m_142104_(ItemStack.f_41583_);
            }
            this.getEntityItemEnchants().remove(living.m_20148_());
        }
        if (entity.m_9236_().m_5776_()) {
            return;
        }
        Services.PLATFORM.sendS2CTrackingAndSelf(new ModifyEnchantmentLevelPacket(entity.m_19879_(), Services.POWER.getPowerId(power), true), entity);
    }

    default public boolean doesApply(P power, Enchantment enchantment, Level level, ItemStack self) {
        return enchantment.equals(this.getDataFromPower(power).get("enchantment")) && this.checkItemCondition(power, level, self);
    }

    default public boolean checkItemCondition(P power, Level level, ItemStack self) {
        return !this.getDataFromPower(power).isPresent("item_condition") || Services.CONDITION.checkItem(this.getDataFromPower(power), "item_condition", level, self);
    }

    default public Optional<Integer> findEnchantIndex(ResourceLocation id, ListTag enchants) {
        for (int i = 0; i < enchants.size(); ++i) {
            String string = enchants.m_128728_(i).m_128461_("id");
            ResourceLocation enchantId = ResourceLocation.m_135820_((String)string);
            if (enchantId == null || !enchantId.equals((Object)id)) continue;
            return Optional.of(i);
        }
        return Optional.empty();
    }

    default public ListTag generateEnchantments(ListTag enchants, ItemStack self) {
        if (self == null) {
            return enchants;
        }
        Entity entity = ((ItemStackAccess)self).apugli$getEntity();
        if (!(entity instanceof LivingEntity)) {
            return enchants;
        }
        LivingEntity living = (LivingEntity)entity;
        ListTag newEnchants = enchants.m_6426_();
        List powers = Services.POWER.getPowers(living, this);
        for (Object power : powers) {
            Enchantment enchantment = (Enchantment)this.getDataFromPower(power).get("enchantment");
            ResourceLocation id = BuiltInRegistries.f_256876_.m_7981_((Object)enchantment);
            if (!this.doesApply(power, enchantment, entity.m_9236_(), self)) continue;
            Optional<Integer> idx = this.findEnchantIndex(id, newEnchants);
            if (idx.isPresent()) {
                CompoundTag existingEnchant = newEnchants.m_128728_(idx.get().intValue());
                int lvl = existingEnchant.m_128451_("lvl");
                int newLvl = (int)Services.PLATFORM.applyModifiers((Entity)living, this.getModifiers(power, (Entity)living), (double)lvl);
                existingEnchant.m_128405_("lvl", newLvl);
                newEnchants.set(idx.get().intValue(), (Tag)existingEnchant);
                continue;
            }
            CompoundTag newEnchant = new CompoundTag();
            newEnchant.m_128359_("id", id.toString());
            newEnchant.m_128405_("lvl", (int)Services.PLATFORM.applyModifiers((Entity)living, this.getModifiers(power, (Entity)living), 0.0));
            newEnchants.add((Object)newEnchant);
        }
        return newEnchants;
    }

    default public ListTag getEnchantments(ItemStack self, ListTag originalTag) {
        Entity entity;
        if (self != null && (entity = ((ItemStackAccess)self).apugli$getEntity()) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (this.getEntityItemEnchants().containsKey(living.m_20148_())) {
                ConcurrentHashMap<ComparableItemStack, ListTag> itemEnchants = this.getEntityItemEnchants().get(living.m_20148_());
                ComparableItemStack comparableStack = new ComparableItemStack(self);
                if (this.shouldReapplyEnchantments(living, comparableStack)) {
                    itemEnchants.computeIfAbsent(comparableStack, tag -> originalTag);
                    return itemEnchants.compute(comparableStack, (tagEnchants, tag) -> this.generateEnchantments(originalTag, self));
                }
                return itemEnchants.getOrDefault(comparableStack, originalTag);
            }
        }
        return originalTag;
    }

    default public Map<Enchantment, Integer> getItemEnchantments(ItemStack self) {
        Entity entity = ((ItemStackAccess)self).apugli$getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (this.getEntityItemEnchants().containsKey(living.m_20148_())) {
                ConcurrentHashMap<ComparableItemStack, ListTag> itemEnchants = this.getEntityItemEnchants().get(living.m_20148_());
                ComparableItemStack comparableItemStack = new ComparableItemStack(self);
                return EnchantmentHelper.m_44882_((ListTag)itemEnchants.computeIfAbsent(comparableItemStack, stack -> stack.stack().m_41785_()));
            }
        }
        return EnchantmentHelper.m_44831_((ItemStack)self);
    }

    default public int getEnchantmentLevel(Enchantment enchantment, LivingEntity living) {
        if (this.getEntityItemEnchants().containsKey(living.m_20148_())) {
            int i = 0;
            for (ItemStack stack : living.m_20158_()) {
                int j = this.getItemEnchantmentLevel(enchantment, stack);
                if (j <= i) continue;
                i = j;
            }
            return i;
        }
        return EnchantmentHelper.m_44836_((Enchantment)enchantment, (LivingEntity)living);
    }

    default public int getItemEnchantmentLevel(Enchantment enchantment, ItemStack self) {
        if (self == null) {
            return 0;
        }
        Entity entity = ((ItemStackAccess)self).apugli$getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (this.getEntityItemEnchants().containsKey(living.m_20148_())) {
                ListTag newEnchants;
                ConcurrentHashMap<ComparableItemStack, ListTag> itemEnchants = this.getEntityItemEnchants().get(living.m_20148_());
                ComparableItemStack comparableStack = new ComparableItemStack(self);
                ResourceLocation id = BuiltInRegistries.f_256876_.m_7981_((Object)enchantment);
                Optional<Integer> idx = this.findEnchantIndex(id, newEnchants = itemEnchants.getOrDefault(comparableStack, self.m_41785_()));
                if (idx.isPresent()) {
                    CompoundTag existingEnchant = newEnchants.m_128728_(idx.get().intValue());
                    return existingEnchant.m_128451_("lvl");
                }
                return 0;
            }
        }
        return EnchantmentHelper.m_44843_((Enchantment)enchantment, (ItemStack)self);
    }

    default public boolean updateIfDifferent(ConcurrentHashMap<P, Tuple<Integer, Boolean>> map, P power, int modifierValue, boolean conditionValue) {
        map.computeIfAbsent(power, p -> new Tuple((Object)0, (Object)false));
        boolean value = false;
        if ((Integer)map.get(power).m_14418_() != modifierValue) {
            map.get(power).m_145023_((Object)modifierValue);
            value = true;
        }
        if ((Boolean)map.get(power).m_14419_() != conditionValue) {
            map.get(power).m_145025_((Object)conditionValue);
            value = true;
        }
        return value;
    }

    default public boolean shouldReapplyEnchantments(LivingEntity living, ComparableItemStack stack) {
        List powers = Services.POWER.getPowers(living, this, true);
        ConcurrentHashMap<ComparableItemStack, ListTag> enchants = this.getEntityItemEnchants().get(living.m_20148_());
        ConcurrentHashMap cache = this.getPowerModifierCache().computeIfAbsent(living.m_20148_(), _living -> new ConcurrentHashMap());
        return !enchants.containsKey(stack) || powers.stream().anyMatch(power -> this.updateIfDifferent(cache, power, (int)Services.PLATFORM.applyModifiers((Entity)living, this.getModifiers(power, (Entity)living), 0.0), Services.POWER.isActive(power, living) && this.checkItemCondition(power, living.m_9236_(), stack.stack())));
    }

    public ConcurrentHashMap<UUID, ConcurrentHashMap<ComparableItemStack, ListTag>> getEntityItemEnchants();

    public ConcurrentHashMap<UUID, ConcurrentHashMap<P, Tuple<Integer, Boolean>>> getPowerModifierCache();
}

