/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.power;

import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataType;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.merchantpug.apugli.platform.Services;
import net.merchantpug.apugli.power.factory.SimplePowerFactory;
import net.merchantpug.apugli.registry.power.ApugliPowers;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;

public class EdibleItemPower
extends Power {
    private final Predicate<Tuple<Level, ItemStack>> predicate;
    private final FoodProperties foodComponent;
    private final EatAnimation useAction;
    private final ItemStack returnStack;
    private final SoundEvent sound;
    private final Consumer<Entity> entityActionWhenEaten;
    private final Consumer<Tuple<Level, Mutable<ItemStack>>> itemActionWhenEaten;

    public EdibleItemPower(PowerType<?> type, LivingEntity entity, Predicate<Tuple<Level, ItemStack>> predicate, FoodProperties foodComponent, EatAnimation useAction, ItemStack returnStack, SoundEvent sound, Consumer<Entity> entityActionWhenEaten, Consumer<Tuple<Level, Mutable<ItemStack>>> itemActionWhenEaten) {
        super(type, entity);
        this.predicate = predicate;
        this.foodComponent = foodComponent;
        this.useAction = useAction;
        this.returnStack = returnStack;
        this.sound = sound;
        this.entityActionWhenEaten = entityActionWhenEaten;
        this.itemActionWhenEaten = itemActionWhenEaten;
    }

    public boolean doesApply(Level level, ItemStack stack) {
        return this.predicate.test((Tuple<Level, ItemStack>)new Tuple((Object)level, (Object)stack));
    }

    public FoodProperties getFoodComponent() {
        return this.foodComponent;
    }

    public EatAnimation getUseAction() {
        return this.useAction;
    }

    public ItemStack getReturnStack() {
        return this.returnStack;
    }

    public SoundEvent getSound() {
        return this.sound;
    }

    public static void executeEntityActions(LivingEntity entity, ItemStack stack) {
        Services.POWER.getPowers(entity, ApugliPowers.EDIBLE_ITEM.get()).stream().filter(p -> p.doesApply(entity.m_9236_(), stack) && p.entityActionWhenEaten != null).forEach(p -> p.entityActionWhenEaten.accept((Entity)entity));
    }

    public static ItemStack executeItemActions(LivingEntity entity, ItemStack stack, ItemStack originalStack) {
        MutableObject mutable = new MutableObject((Object)stack.m_41777_());
        Services.POWER.getPowers(entity, ApugliPowers.EDIBLE_ITEM.get()).stream().filter(p -> p.doesApply(entity.m_9236_(), originalStack) && p.itemActionWhenEaten != null).forEach(arg_0 -> EdibleItemPower.lambda$executeItemActions$3(entity, (Mutable)mutable, arg_0));
        return (ItemStack)mutable.getValue();
    }

    private static /* synthetic */ void lambda$executeItemActions$3(LivingEntity entity, Mutable mutable, EdibleItemPower p) {
        p.itemActionWhenEaten.accept((Tuple<Level, Mutable<ItemStack>>)new Tuple((Object)entity.m_9236_(), (Object)mutable));
    }

    public static enum EatAnimation {
        EAT,
        DRINK;

    }

    public static class Factory
    extends SimplePowerFactory<EdibleItemPower> {
        public Factory() {
            super("edible_item", new SerializableData().add("item_condition", Services.CONDITION.itemDataType()).add("food_component", SerializableDataTypes.FOOD_COMPONENT).add("use_action", SerializableDataType.enumValue(EatAnimation.class), (Object)EatAnimation.EAT).add("return_stack", SerializableDataTypes.ITEM_STACK, null).add("sound", SerializableDataTypes.SOUND_EVENT, null).add("entity_action", Services.ACTION.entityDataType(), null).add("item_action", Services.ACTION.itemDataType(), null), data -> (type, player) -> new EdibleItemPower((PowerType<?>)type, (LivingEntity)player, Services.CONDITION.itemPredicate((SerializableData.Instance)data, "item_condition"), (FoodProperties)data.get("food_component"), (EatAnimation)((Object)((Object)((Object)data.get("use_action")))), (ItemStack)data.get("return_stack"), (SoundEvent)data.get("sound"), Services.ACTION.entityConsumer((SerializableData.Instance)data, "entity_action"), Services.ACTION.itemConsumer((SerializableData.Instance)data, "item_action")));
            this.allowCondition();
        }

        @Override
        public Class<EdibleItemPower> getPowerClass() {
            return EdibleItemPower.class;
        }
    }
}

