/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.network.s2c;

import java.util.HashSet;
import java.util.Set;
import net.merchantpug.apugli.Apugli;
import net.merchantpug.apugli.client.util.TextureUtilClient;
import net.merchantpug.apugli.network.s2c.ApugliPacketS2C;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.tuple.Triple;

public record UpdateUrlTexturesPacket(Set<Triple<ResourceLocation, String, ResourceLocation>> urlTextures) implements ApugliPacketS2C
{
    public static final ResourceLocation ID = Apugli.asResource("update_url_textures");

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.urlTextures.size());
        for (Triple<ResourceLocation, String, ResourceLocation> entry : this.urlTextures) {
            buf.m_130085_((ResourceLocation)entry.getLeft());
            buf.m_130070_((String)entry.getMiddle());
            buf.writeBoolean(entry.getRight() != null);
            if (entry.getRight() == null) continue;
            buf.m_130085_((ResourceLocation)entry.getRight());
        }
    }

    public static UpdateUrlTexturesPacket decode(FriendlyByteBuf buf) {
        int powerTypesSize = buf.readInt();
        HashSet<Triple<ResourceLocation, String, ResourceLocation>> powerData = new HashSet<Triple<ResourceLocation, String, ResourceLocation>>();
        for (int i = 0; i < powerTypesSize; ++i) {
            ResourceLocation textureId = buf.m_130281_();
            String textureUrl = buf.m_130277_();
            boolean hasTextureLocation = buf.readBoolean();
            ResourceLocation textureLocation = null;
            if (hasTextureLocation) {
                textureLocation = buf.m_130281_();
            }
            powerData.add((Triple<ResourceLocation, String, ResourceLocation>)Triple.of((Object)textureId, (Object)textureUrl, (Object)textureLocation));
        }
        return new UpdateUrlTexturesPacket(powerData);
    }

    @Override
    public ResourceLocation getFabricId() {
        return ID;
    }

    @Override
    public void handle() {
        Minecraft.m_91087_().execute(() -> {
            this.urlTextures.forEach(value -> {
                if (value.getRight() != null && TextureUtilClient.doesTextureExist((ResourceLocation)value.getRight())) {
                    return;
                }
                TextureUtilClient.registerPowerTexture((ResourceLocation)value.getLeft(), (String)value.getMiddle(), false);
            });
            TextureUtilClient.update();
        });
    }
}

