/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.network.s2c;

import com.mojang.serialization.DynamicOps;
import io.github.edwinmindcraft.apoli.api.power.IActivePower;
import java.util.HashSet;
import java.util.Set;
import net.merchantpug.apugli.Apugli;
import net.merchantpug.apugli.capability.entity.KeyPressCapability;
import net.merchantpug.apugli.network.s2c.ApugliPacketS2C;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public record SyncKeysLessenedPacket(int entityId, Set<IActivePower.Key> addedKeys, Set<IActivePower.Key> removedKeys) implements ApugliPacketS2C
{
    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.entityId);
        buf.writeInt(this.addedKeys.size());
        for (IActivePower.Key key : this.addedKeys) {
            IActivePower.Key.CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)key).resultOrPartial(msg -> {
                buf.writeBoolean(false);
                Apugli.LOG.error("Failed to encode added active power key. {}", (Object)key);
            }).ifPresent(tag -> {
                buf.writeBoolean(true);
                buf.m_130079_((CompoundTag)tag);
            });
        }
        buf.writeInt(this.removedKeys.size());
        for (IActivePower.Key key : this.removedKeys) {
            IActivePower.Key.CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)key).resultOrPartial(msg -> {
                buf.writeBoolean(false);
                Apugli.LOG.error("Failed to encode added active power key. {}", (Object)key);
            }).ifPresent(tag -> {
                buf.writeBoolean(true);
                buf.m_130079_((CompoundTag)tag);
            });
        }
    }

    public static SyncKeysLessenedPacket decode(FriendlyByteBuf buf) {
        int entityId = buf.readInt();
        HashSet<IActivePower.Key> addedKeys = new HashSet<IActivePower.Key>();
        int addedKeySize = buf.readInt();
        for (int i = 0; i < addedKeySize; ++i) {
            if (!buf.readBoolean()) continue;
            CompoundTag tag = buf.m_130260_();
            IActivePower.Key.CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)tag).resultOrPartial(msg -> Apugli.LOG.error("Failed to decode active power key. {}", msg)).ifPresent(addedKeys::add);
        }
        HashSet<IActivePower.Key> removedKeys = new HashSet<IActivePower.Key>();
        int removedKeySize = buf.readInt();
        for (int i = 0; i < removedKeySize; ++i) {
            if (!buf.readBoolean()) continue;
            CompoundTag tag = buf.m_130260_();
            IActivePower.Key.CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)tag).resultOrPartial(msg -> Apugli.LOG.error("Failed to decode active power key. {}", msg)).ifPresent(removedKeys::add);
        }
        return new SyncKeysLessenedPacket(entityId, addedKeys, removedKeys);
    }

    @Override
    public ResourceLocation getFabricId() {
        throw new RuntimeException("ApugliPacket#getFabricId is not meant to be used in Forge specific packets.");
    }

    @Override
    public void handle() {
        Minecraft.m_91087_().execute(new Runnable(){

            @Override
            public void run() {
                Entity entity = Minecraft.m_91087_().f_91073_.m_6815_(SyncKeysLessenedPacket.this.entityId);
                if (!(entity instanceof Player)) {
                    Apugli.LOG.warn("Could not find player entity to sync keys with.");
                    return;
                }
                Player player = (Player)entity;
                player.getCapability(KeyPressCapability.INSTANCE).ifPresent(capability -> {
                    for (IActivePower.Key key : SyncKeysLessenedPacket.this.addedKeys) {
                        capability.addKey(key);
                    }
                    for (IActivePower.Key key : SyncKeysLessenedPacket.this.removedKeys) {
                        capability.removeKey(key);
                    }
                });
            }
        });
    }
}

