/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.network.s2c;

import com.mojang.serialization.DynamicOps;
import io.github.edwinmindcraft.apoli.api.power.IActivePower;
import java.util.HashSet;
import java.util.Set;
import net.merchantpug.apugli.Apugli;
import net.merchantpug.apugli.capability.entity.KeyPressCapability;
import net.merchantpug.apugli.network.s2c.ApugliPacketS2C;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public record SyncKeyPressCapabilityPacket(int entityId, Set<IActivePower.Key> previouslyUsedKeys, Set<IActivePower.Key> currentlyUsedKeys) implements ApugliPacketS2C
{
    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.entityId);
        buf.writeInt(this.previouslyUsedKeys.size());
        for (IActivePower.Key key : this.previouslyUsedKeys) {
            IActivePower.Key.CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)key).resultOrPartial(msg -> {
                buf.writeBoolean(false);
                Apugli.LOG.error("Failed to encode previously used active power key for syncing. {}", (Object)key);
            }).ifPresent(tag -> {
                buf.writeBoolean(true);
                buf.m_130079_((CompoundTag)tag);
            });
        }
        buf.writeInt(this.currentlyUsedKeys.size());
        for (IActivePower.Key key : this.currentlyUsedKeys) {
            IActivePower.Key.CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)key).resultOrPartial(msg -> {
                buf.writeBoolean(false);
                Apugli.LOG.error("Failed to encode currently used active power key for syncing. {}", (Object)key);
            }).ifPresent(tag -> {
                buf.writeBoolean(true);
                buf.m_130079_((CompoundTag)tag);
            });
        }
    }

    public static SyncKeyPressCapabilityPacket decode(FriendlyByteBuf buf) {
        int entityId = buf.readInt();
        HashSet<IActivePower.Key> previouslyUsedKeys = new HashSet<IActivePower.Key>();
        int previouslyUsedKeySize = buf.readInt();
        for (int i = 0; i < previouslyUsedKeySize; ++i) {
            if (!buf.readBoolean()) continue;
            CompoundTag tag = buf.m_130260_();
            IActivePower.Key.CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)tag).resultOrPartial(msg -> Apugli.LOG.error("Failed to decode active power key while syncing. {}", msg)).ifPresent(previouslyUsedKeys::add);
        }
        HashSet<IActivePower.Key> currentlyUsedKeys = new HashSet<IActivePower.Key>();
        int currentlyUsedKeySize = buf.readInt();
        for (int i = 0; i < currentlyUsedKeySize; ++i) {
            if (!buf.readBoolean()) continue;
            CompoundTag tag = buf.m_130260_();
            IActivePower.Key.CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)tag).resultOrPartial(msg -> Apugli.LOG.error("Failed to decode active power key while syncing. {}", msg)).ifPresent(currentlyUsedKeys::add);
        }
        return new SyncKeyPressCapabilityPacket(entityId, previouslyUsedKeys, currentlyUsedKeys);
    }

    @Override
    public ResourceLocation getFabricId() {
        throw new RuntimeException("ApugliPacket#getFabricId is not meant to be used in Forge specific packets.");
    }

    @Override
    public void handle() {
        Minecraft.m_91087_().execute(new Runnable(){

            @Override
            public void run() {
                Entity entity = Minecraft.m_91087_().f_91073_.m_6815_(SyncKeyPressCapabilityPacket.this.entityId);
                if (!(entity instanceof Player)) {
                    Apugli.LOG.warn("Could not find player entity to sync keys with.");
                    return;
                }
                Player player = (Player)entity;
                player.getCapability(KeyPressCapability.INSTANCE).ifPresent(capability -> {
                    for (IActivePower.Key key : SyncKeyPressCapabilityPacket.this.currentlyUsedKeys) {
                        capability.addKey(key);
                    }
                    for (IActivePower.Key key : SyncKeyPressCapabilityPacket.this.previouslyUsedKeys) {
                        capability.addPreviousKey(key);
                    }
                });
            }
        });
    }
}

