/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.network.s2c;

import net.merchantpug.apugli.Apugli;
import net.merchantpug.apugli.network.s2c.ApugliPacketS2C;
import net.merchantpug.apugli.platform.Services;
import net.merchantpug.apugli.registry.power.ApugliPowers;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public record ModifyEnchantmentLevelPacket(int entityId, ResourceLocation powerId, boolean remove) implements ApugliPacketS2C
{
    public static final ResourceLocation ID = Apugli.asResource("modify_enchantment_level");

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.entityId());
        buf.m_130085_(this.powerId());
        buf.writeBoolean(this.remove());
    }

    public static ModifyEnchantmentLevelPacket decode(FriendlyByteBuf buf) {
        return new ModifyEnchantmentLevelPacket(buf.readInt(), buf.m_130281_(), buf.readBoolean());
    }

    @Override
    public ResourceLocation getFabricId() {
        return ID;
    }

    @Override
    public void handle() {
        Minecraft.m_91087_().execute(new Runnable(){

            @Override
            public void run() {
                Entity entity = Minecraft.m_91087_().f_91073_.m_6815_(ModifyEnchantmentLevelPacket.this.entityId());
                if (!(entity instanceof LivingEntity)) {
                    return;
                }
                LivingEntity living = (LivingEntity)entity;
                Object power = Services.POWER.getPowerFromId(entity, ModifyEnchantmentLevelPacket.this.powerId());
                if (power == null) {
                    return;
                }
                if (ModifyEnchantmentLevelPacket.this.remove()) {
                    ApugliPowers.MODIFY_ENCHANTMENT_LEVEL.get().onRemoved(power, (Entity)living);
                } else {
                    ApugliPowers.MODIFY_ENCHANTMENT_LEVEL.get().onAdded(power, (Entity)living);
                }
            }
        });
    }
}

