/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.mixin.xplatform.common;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import java.util.List;
import net.merchantpug.apugli.access.EntityAccess;
import net.merchantpug.apugli.mixin.xplatform.common.accessor.LivingEntityAccessor;
import net.merchantpug.apugli.platform.Services;
import net.merchantpug.apugli.power.CustomSoundPower;
import net.merchantpug.apugli.power.HoverPower;
import net.merchantpug.apugli.power.StepHeightPower;
import net.merchantpug.apugli.registry.power.ApugliPowers;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public abstract class EntityMixin
implements EntityAccess {
    @Shadow
    private Level f_19853_;
    @Unique
    private boolean apugli$moving;
    @Unique
    private int apugli$modifiedFreezeTicks;

    @Shadow
    public abstract AABB m_20191_();

    @Shadow
    public abstract double m_20185_();

    @Shadow
    public abstract double m_20186_();

    @Shadow
    public abstract double m_20189_();

    @Shadow
    public abstract int m_146888_();

    @Shadow
    public abstract Level m_9236_();

    @Shadow
    public abstract Vec3 m_20182_();

    @Inject(method={"playStepSound"}, at={@At(value="HEAD")}, cancellable=true)
    private void apugli$modifyStepSound(BlockPos pos, BlockState state, CallbackInfo ci) {
        Entity entity = (Entity)this;
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity living = (LivingEntity)entity;
        List powers = Services.POWER.getPowers(living, ApugliPowers.CUSTOM_FOOTSTEP.get());
        if (powers.isEmpty()) {
            return;
        }
        if (powers.stream().anyMatch(CustomSoundPower::isMuted)) {
            ci.cancel();
        }
        powers.forEach(power -> power.playSound((Entity)living));
        ci.cancel();
    }

    @Inject(method={"baseTick"}, at={@At(value="HEAD", shift=At.Shift.BY, by=2)})
    private void apugli$setApugliMovingFalse(CallbackInfo ci) {
        this.apugli$moving = false;
    }

    @Inject(method={"move"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;setPos(DDD)V")})
    private void apugli$setApugliMovingTrue(MoverType movementType, Vec3 movement, CallbackInfo ci) {
        if (movement != Vec3.f_82478_) {
            this.apugli$moving = true;
        }
    }

    @Override
    public boolean apugli$isMoving() {
        return this.apugli$moving;
    }

    @Inject(method={"collide"}, at={@At(value="HEAD")}, cancellable=true)
    private void apugli$handleHoverCorrection(Vec3 movement, CallbackInfoReturnable<Vec3> cir) {
        Entity entity = (Entity)this;
        if (entity instanceof LivingEntity) {
            LivingEntity thisAsLiving = (LivingEntity)entity;
            double lowerCorrectionRange = StepHeightPower.getLowerCorrectionRange(thisAsLiving).orElse(HoverPower.getCorrectionRange(thisAsLiving).orElse(0.0));
            double upperCorrectionRange = StepHeightPower.getUpperCorrectionRange(thisAsLiving).orElse(HoverPower.getCorrectionRange(thisAsLiving).orElse(0.0));
            if (lowerCorrectionRange > 0.0 || upperCorrectionRange > 0.0) {
                Vec3 vec3d4;
                AABB box = this.m_20191_();
                List collisionList = this.f_19853_.m_183134_((Entity)thisAsLiving, box.m_82369_(movement));
                Vec3 vec3 = vec3d4 = movement.m_82556_() == 0.0 ? movement : Entity.m_198894_((Entity)thisAsLiving, (Vec3)movement, (AABB)box, (Level)this.f_19853_, (List)collisionList);
                if (movement.f_82479_ != vec3d4.f_82479_ || movement.f_82481_ != vec3d4.f_82481_) {
                    Vec3 vec3d3;
                    Vec3 vec3d2;
                    Vec3 vec3d;
                    double correction;
                    double checkAddition;
                    boolean handledLowerRange = false;
                    for (correction = 0.0; correction <= lowerCorrectionRange; correction += checkAddition) {
                        vec3d = Entity.m_198894_((Entity)thisAsLiving, (Vec3)new Vec3(movement.f_82479_, correction, movement.f_82481_), (AABB)box, (Level)this.f_19853_, (List)collisionList);
                        vec3d2 = Entity.m_198894_((Entity)thisAsLiving, (Vec3)new Vec3(0.0, correction, 0.0), (AABB)box.m_82363_(movement.f_82479_, 0.0, movement.f_82481_), (Level)this.f_19853_, (List)collisionList);
                        vec3d3 = Entity.m_198894_((Entity)thisAsLiving, (Vec3)new Vec3(movement.f_82479_, 0.0, movement.f_82481_), (AABB)box, (Level)this.f_19853_, (List)collisionList).m_82549_(vec3d2);
                        if (vec3d3.m_165925_() > vec3d.m_165925_()) {
                            vec3d = vec3d3;
                        }
                        if (vec3d.m_165925_() > vec3d4.m_165925_()) {
                            cir.setReturnValue((Object)vec3d.m_82549_(Entity.m_198894_((Entity)thisAsLiving, (Vec3)new Vec3(0.0, -vec3d.m_7098_() + Math.max(0.0, (double)((float)movement.f_82480_)), 0.0), (AABB)box.m_82383_(vec3d), (Level)this.f_19853_, (List)collisionList)));
                            if (Services.POWER.getPowers(thisAsLiving, ApugliPowers.STEP_HEIGHT.get()).stream().anyMatch(power -> power.canCorrectLowerHeight() && power.shouldAllowJumpAfter())) {
                                ((LivingEntityAccessor)thisAsLiving).apugli$setNoJumpDelay(0);
                            }
                            handledLowerRange = true;
                            break;
                        }
                        checkAddition = lowerCorrectionRange % 1.0;
                        if (checkAddition != 0.0) continue;
                        checkAddition = 1.0;
                    }
                    if (handledLowerRange) {
                        return;
                    }
                    for (correction = 0.0; correction <= upperCorrectionRange; correction += checkAddition) {
                        vec3d = Entity.m_198894_((Entity)thisAsLiving, (Vec3)new Vec3(movement.f_82479_, -correction, movement.f_82481_), (AABB)box, (Level)this.f_19853_, (List)collisionList);
                        vec3d2 = Entity.m_198894_((Entity)thisAsLiving, (Vec3)new Vec3(0.0, -correction, 0.0), (AABB)box.m_82363_(movement.f_82479_, 0.0, movement.f_82481_), (Level)this.f_19853_, (List)collisionList);
                        vec3d3 = Entity.m_198894_((Entity)thisAsLiving, (Vec3)new Vec3(movement.f_82479_, 0.0, movement.f_82481_), (AABB)box, (Level)this.f_19853_, (List)collisionList).m_82549_(vec3d2);
                        if (vec3d3.m_165925_() > vec3d.m_165925_()) {
                            vec3d = vec3d3;
                        }
                        if (vec3d.m_165925_() > vec3d4.m_165925_()) {
                            cir.setReturnValue((Object)vec3d.m_82549_(Entity.m_198894_((Entity)thisAsLiving, (Vec3)new Vec3(0.0, -vec3d.m_7098_() + Math.min(0.0, (double)((float)movement.f_82480_)), 0.0), (AABB)box.m_82383_(vec3d), (Level)this.f_19853_, (List)collisionList)));
                            break;
                        }
                        checkAddition = lowerCorrectionRange % 1.0;
                        if (checkAddition != 0.0) continue;
                        checkAddition = 1.0;
                    }
                }
            }
        }
    }

    @ModifyReturnValue(method={"getTicksRequiredToFreeze"}, at={@At(value="RETURN")})
    private int apugli$modifyTicksRequiredToFreeze(int original) {
        Entity entity = (Entity)this;
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (Services.POWER.hasPower(living, ApugliPowers.FREEZE.get())) {
                int newValue;
                this.apugli$modifiedFreezeTicks = newValue = (int)Services.PLATFORM.applyModifiers(living, ApugliPowers.FREEZE.get(), (double)original);
                return newValue;
            }
            if (this.apugli$modifiedFreezeTicks > 0) {
                if (this.m_146888_() > 0) {
                    return this.apugli$modifiedFreezeTicks;
                }
                this.apugli$modifiedFreezeTicks = 0;
            }
        }
        return original;
    }

    @ModifyReturnValue(method={"canFreeze"}, at={@At(value="RETURN")})
    private boolean apugli$allowFreezing(boolean original) {
        LivingEntity living;
        Entity entity = (Entity)this;
        if (entity instanceof LivingEntity && Services.POWER.hasPower(living = (LivingEntity)entity, ApugliPowers.FREEZE.get())) {
            return true;
        }
        return original;
    }
}

