/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.condition.factory.entity;

import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.util.Comparison;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.Iterator;
import java.util.function.Predicate;
import net.merchantpug.apugli.condition.factory.IConditionFactory;
import net.merchantpug.apugli.platform.Services;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;

public class EntityInRadiusCondition
implements IConditionFactory<Entity> {
    @Override
    public SerializableData getSerializableData() {
        return new SerializableData().add("condition", Services.CONDITION.entityDataType(), null).add("bientity_condition", Services.CONDITION.biEntityDataType(), null).add("radius", SerializableDataTypes.DOUBLE).add("compare_to", SerializableDataTypes.INT, (Object)1).add("comparison", ApoliDataTypes.COMPARISON, (Object)Comparison.GREATER_THAN_OR_EQUAL);
    }

    @Override
    public boolean check(SerializableData.Instance data, Entity entity) {
        Entity target;
        Predicate<Entity> entityCondition = Services.CONDITION.entityPredicate(data, "condition");
        Predicate<Tuple<Entity, Entity>> biEntityCondition = Services.CONDITION.biEntityPredicate(data, "bientity_condition");
        int stopAt = -1;
        Comparison comparison = (Comparison)data.get("comparison");
        int compareTo = data.getInt("compare_to");
        switch (comparison) {
            case EQUAL: 
            case LESS_THAN_OR_EQUAL: 
            case GREATER_THAN: {
                stopAt = compareTo + 1;
                break;
            }
            case LESS_THAN: 
            case GREATER_THAN_OR_EQUAL: {
                stopAt = compareTo;
            }
        }
        int count = 0;
        Iterator iterator = entity.m_9236_().m_45933_(entity, entity.m_20191_().m_82400_(data.getDouble("radius"))).iterator();
        while (iterator.hasNext() && ((target = (Entity)iterator.next()) == null || entityCondition != null && !entityCondition.test(target) || biEntityCondition != null && !biEntityCondition.test((Tuple<Entity, Entity>)new Tuple((Object)entity, (Object)target)) || ++count != stopAt)) {
        }
        return comparison.compare((double)count, (double)compareTo);
    }
}

