/*
 * Decompiled with CFR 0.152.
 */
package net.merchantpug.apugli.action.factory.entity;

import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.util.Space;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.merchantpug.apugli.access.ExplosionAccess;
import net.merchantpug.apugli.action.factory.IActionFactory;
import net.merchantpug.apugli.network.s2c.SyncExplosionPacket;
import net.merchantpug.apugli.platform.Services;
import net.merchantpug.apugli.util.RaycastUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class ExplosionRaycastAction
implements IActionFactory<Entity> {
    @Override
    public SerializableData getSerializableData() {
        return new SerializableData().add("distance", SerializableDataTypes.DOUBLE, null).add("particle", SerializableDataTypes.PARTICLE_EFFECT_OR_TYPE, null).add("spacing", SerializableDataTypes.DOUBLE, (Object)0.5).add("direction", SerializableDataTypes.VECTOR, null).add("space", ApoliDataTypes.SPACE, (Object)Space.WORLD).add("block_action", Services.ACTION.blockDataType(), null).add("bientity_action", Services.ACTION.biEntityDataType(), null).add("action_on_hit", Services.ACTION.entityDataType(), null).add("power", SerializableDataTypes.FLOAT).add("destruction_type", ApoliDataTypes.BACKWARDS_COMPATIBLE_DESTRUCTION_TYPE, (Object)Explosion.BlockInteraction.KEEP).add("damage_self", SerializableDataTypes.BOOLEAN, (Object)false).add("indestructible", Services.CONDITION.blockDataType(), null).add("destructible", Services.CONDITION.blockDataType(), null).add("create_fire", SerializableDataTypes.BOOLEAN, (Object)false).add("damage_modifier", Services.PLATFORM.getModifierDataType(), null).add("damage_modifiers", Services.PLATFORM.getModifiersDataType(), null).add("knockback_modifier", Services.PLATFORM.getModifierDataType(), null).add("knockback_modifiers", Services.PLATFORM.getModifiersDataType(), null).add("volume_modifier", Services.PLATFORM.getModifierDataType(), null).add("volume_modifiers", Services.PLATFORM.getModifiersDataType(), null).add("pitch_modifier", Services.PLATFORM.getModifierDataType(), null).add("pitch_modifiers", Services.PLATFORM.getModifiersDataType(), null).add("targetable_bientity_condition", Services.CONDITION.biEntityDataType(), null).add("explosion_damage_bientity_condition", Services.CONDITION.biEntityDataType(), null).add("use_charged", SerializableDataTypes.BOOLEAN, (Object)false).add("charged_condition", Services.CONDITION.entityDataType(), null).add("charged_modifier", Services.PLATFORM.getModifierDataType(), null).add("charged_modifiers", Services.PLATFORM.getModifiersDataType(), null);
    }

    @Override
    public void execute(SerializableData.Instance data, Entity entity) {
        HitResult.Type entityHitResultType;
        if (entity.m_9236_().f_46443_) {
            return;
        }
        double blockDistance = data.isPresent("distance") ? data.getDouble("distance") : Services.PLATFORM.getReachDistance(entity);
        BlockHitResult blockHitResult = RaycastUtil.raycastBlock(entity, blockDistance, (Vec3)data.get("direction"), (Space)data.get("space"));
        HitResult.Type blockHitResultType = blockHitResult.m_6662_();
        double entityDistance = data.isPresent("distance") ? data.getDouble("distance") : Services.PLATFORM.getAttackRange(entity);
        EntityHitResult entityHitResult = RaycastUtil.raycastEntity(blockHitResult, entity, entityDistance, (Vec3)data.get("direction"), (Space)data.get("space"), Services.CONDITION.biEntityPredicate(data, "targetable_bientity_condition"));
        HitResult.Type type = entityHitResultType = entityHitResult != null ? entityHitResult.m_6662_() : HitResult.Type.MISS;
        if (entityHitResultType == HitResult.Type.ENTITY) {
            this.createParticlesAtHitPos(data, entity, (HitResult)entityHitResult);
            this.onHitEntity(data, entity, entityHitResult);
        } else if (blockHitResultType == HitResult.Type.BLOCK) {
            this.createParticlesAtHitPos(data, entity, (HitResult)blockHitResult);
            this.onHitBlock(data, entity, blockHitResult);
        }
    }

    protected void createParticlesAtHitPos(SerializableData.Instance data, Entity entity, HitResult hitResult) {
        if (!data.isPresent("particle") || entity.m_9236_().m_5776_()) {
            return;
        }
        ParticleOptions particleEffect = (ParticleOptions)data.get("particle");
        double distanceTo = hitResult.m_82448_(entity);
        for (double d = data.getDouble("spacing"); d < distanceTo; d += data.getDouble("spacing")) {
            double lerpValue = Mth.m_14008_((double)(d / distanceTo), (double)0.0, (double)1.0);
            ((ServerLevel)entity.m_9236_()).m_8767_(particleEffect, Mth.m_14139_((double)lerpValue, (double)entity.m_20185_(), (double)hitResult.m_82450_().m_7096_()), Mth.m_14139_((double)lerpValue, (double)entity.m_20186_(), (double)hitResult.m_82450_().m_7098_()), Mth.m_14139_((double)lerpValue, (double)entity.m_20189_(), (double)hitResult.m_82450_().m_7094_()), 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    protected void onHitBlock(SerializableData.Instance data, Entity entity, BlockHitResult result) {
        if (!data.isPresent("block_action") && !data.isPresent("action_on_hit")) {
            return;
        }
        Services.ACTION.executeBlock(data, "block_action", entity.m_9236_(), result.m_82425_(), result.m_82434_());
        this.summonExplosion(data, entity, (HitResult)result);
        this.executeSelfAction(data, entity);
    }

    protected void onHitEntity(SerializableData.Instance data, Entity actor, EntityHitResult result) {
        if (!data.isPresent("bientity_action") && !data.isPresent("action_on_hit")) {
            return;
        }
        Entity target = result.m_82443_();
        Services.ACTION.executeBiEntity(data, "bientity_action", actor, target);
        this.summonExplosion(data, actor, (HitResult)result);
        this.executeSelfAction(data, actor);
    }

    protected void executeSelfAction(SerializableData.Instance data, Entity entity) {
        if (!data.isPresent("action_on_hit") || !entity.m_6084_()) {
            return;
        }
        Services.ACTION.executeEntity(data, "action_on_hit", entity);
    }

    protected float applyChargedModifiers(SerializableData.Instance data, Entity entity, float power) {
        List chargedModifiers = this.getModifiers(data, "charged_modifier", "charged_modifiers");
        if (!chargedModifiers.isEmpty() && Services.CONDITION.checkEntity(data, "charged_condition", entity)) {
            return (float)Services.PLATFORM.applyModifiers(entity, chargedModifiers, (double)data.getFloat("power"));
        }
        return power;
    }

    protected void summonExplosion(SerializableData.Instance data, Entity entity, HitResult result) {
        float power = data.getFloat("power");
        if (data.getBoolean("use_charged")) {
            power = this.applyChargedModifiers(data, entity, power);
        }
        boolean damageSelf = data.getBoolean("damage_self");
        boolean createFire = data.getBoolean("create_fire");
        Explosion.BlockInteraction destructionType = (Explosion.BlockInteraction)data.get("destruction_type");
        ExplosionDamageCalculator calculator = null;
        boolean indestructible = false;
        String blockConditionFieldKey = null;
        if (data.isPresent("destructible")) {
            calculator = this.createBlockConditionedExplosionDamageCalculator(data, "indestructible", entity.m_9236_(), false);
            blockConditionFieldKey = "destructible";
        } else if (data.isPresent("indestructible")) {
            calculator = this.createBlockConditionedExplosionDamageCalculator(data, "destructible", entity.m_9236_(), true);
            indestructible = true;
            blockConditionFieldKey = "indestructible";
        }
        if (calculator != null) {
            Explosion explosion = new Explosion(entity.m_9236_(), damageSelf ? null : entity, null, calculator, result.m_82450_().m_7096_(), result.m_82450_().m_7098_(), result.m_82450_().m_7094_(), power, createFire, destructionType);
            ((ExplosionAccess)explosion).apugli$setExplosionDamageModifiers(this.getModifiers(data, "damage_modifier", "damage_modifiers"));
            ((ExplosionAccess)explosion).apugli$setExplosionKnockbackModifiers(this.getModifiers(data, "knockback_modifier", "knockback_modifiers"));
            ((ExplosionAccess)explosion).apugli$setExplosionVolumeModifiers(this.getModifiers(data, "volume_modifier", "volume_modifiers"));
            ((ExplosionAccess)explosion).apugli$setExplosionPitchModifiers(this.getModifiers(data, "pitch_modifier", "pitch_modifiers"));
            ((ExplosionAccess)explosion).apugli$setBiEntityPredicate(data.get("explosion_damage_bientity_condition"));
            explosion.m_46061_();
            explosion.m_46075_(false);
            Services.PLATFORM.sendS2CTrackingAndSelf(new SyncExplosionPacket<Object, Object>(entity.m_19879_(), result.m_82450_().m_7096_(), result.m_82450_().m_7098_(), result.m_82450_().m_7094_(), this.getModifiers(data, "damage_modifier", "damage_modifiers"), this.getModifiers(data, "knockback_modifier", "knockback_modifiers"), this.getModifiers(data, "volume_modifier", "volume_modifiers"), this.getModifiers(data, "pitch_modifier", "pitch_modifiers"), data.get("explosion_damage_bientity_condition"), true, data.get(blockConditionFieldKey), indestructible, power), entity);
        } else {
            Explosion explosion = new Explosion(entity.m_9236_(), damageSelf ? null : entity, null, null, result.m_82450_().m_7096_(), result.m_82450_().m_7098_(), result.m_82450_().m_7094_(), power, createFire, destructionType);
            ((ExplosionAccess)explosion).apugli$setExplosionDamageModifiers(this.getModifiers(data, "damage_modifier", "damage_modifiers"));
            ((ExplosionAccess)explosion).apugli$setExplosionKnockbackModifiers(this.getModifiers(data, "knockback_modifier", "knockback_modifiers"));
            ((ExplosionAccess)explosion).apugli$setExplosionVolumeModifiers(this.getModifiers(data, "volume_modifier", "volume_modifiers"));
            ((ExplosionAccess)explosion).apugli$setExplosionPitchModifiers(this.getModifiers(data, "pitch_modifier", "pitch_modifiers"));
            ((ExplosionAccess)explosion).apugli$setBiEntityPredicate(data.get("explosion_damage_bientity_condition"));
            explosion.m_46061_();
            explosion.m_46075_(false);
            Services.PLATFORM.sendS2CTrackingAndSelf(new SyncExplosionPacket<Object, Object>(entity.m_19879_(), result.m_82450_().m_7096_(), result.m_82450_().m_7098_(), result.m_82450_().m_7094_(), this.getModifiers(data, "damage_modifier", "damage_modifiers"), this.getModifiers(data, "knockback_modifier", "knockback_modifiers"), this.getModifiers(data, "volume_modifier", "volume_modifiers"), this.getModifiers(data, "pitch_modifier", "pitch_modifiers"), data.get("explosion_damage_bientity_condition"), false, null, false, power), entity);
        }
    }

    private <M> List<M> getModifiers(SerializableData.Instance data, String modifierKey, String modifiersKey) {
        ArrayList modifiers = new ArrayList();
        data.ifPresent(modifiersKey, modifiers::addAll);
        data.ifPresent(modifierKey, modifiers::add);
        return modifiers;
    }

    private ExplosionDamageCalculator createBlockConditionedExplosionDamageCalculator(final SerializableData.Instance data, final String fieldName, final Level levelIn, final boolean indestructible) {
        return new ExplosionDamageCalculator(){

            public Optional<Float> m_6617_(Explosion explosion, BlockGetter level, BlockPos pos, BlockState blockState, FluidState fluidState) {
                Optional ovr;
                Optional def = super.m_6617_(explosion, level, pos, blockState, fluidState);
                Optional<Object> optional = ovr = Services.CONDITION.checkBlock(data, fieldName, levelIn, pos) == indestructible ? Optional.of(Float.valueOf(Blocks.f_49990_.m_7325_())) : Optional.empty();
                return ovr.isPresent() ? (def.isPresent() ? (((Float)def.get()).floatValue() > ((Float)ovr.get()).floatValue() ? def : ovr) : ovr) : def;
            }
        };
    }
}

