/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.pe.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import java.util.Map;
import java.util.Set;
import net.lopymine.pe.ParticleEffects;
import net.lopymine.pe.capture.ParticleCaptures;
import net.lopymine.pe.utils.ArgbUtils;
import net.lopymine.pe.utils.ListUtils;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin {
    @Shadow
    public abstract Map<MobEffect, MobEffectInstance> m_21221_();

    @Shadow
    public abstract RandomSource m_217043_();

    @WrapOperation(at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;addParticle(Lnet/minecraft/core/particles/ParticleOptions;DDDDDD)V")}, method={"tickEffects"})
    private void swapParticle(Level instance, ParticleOptions parameters, double x, double y, double z, double velocityX, double velocityY, double velocityZ, Operation<Void> original) {
        Runnable originalCall = () -> original.call(new Object[]{instance, parameters, x, y, z, velocityX, velocityY, velocityZ});
        if (!ParticleEffects.getConfig().isModEnabled()) {
            this.particleEffects$markDebugData(51, originalCall);
            return;
        }
        Set<MobEffect> effects = this.m_21221_().keySet();
        if (!effects.isEmpty()) {
            MobEffect statusEffect = (MobEffect)ListUtils.getRandomElement(effects.stream().toList(), this.m_217043_());
            if (statusEffect == null) {
                this.particleEffects$markDebugData(52, originalCall);
                return;
            }
            int color = statusEffect.m_19484_();
            double red = (double)ArgbUtils.getRed(color) / 255.0;
            double green = (double)ArgbUtils.getGreen(color) / 255.0;
            double blue = (double)ArgbUtils.getBlue(color) / 255.0;
            ParticleCaptures.setParticle(parameters);
            original.call(new Object[]{instance, parameters, x, y, z, red, green, blue});
            ParticleCaptures.setParticle(null);
        } else {
            ParticleCaptures.setParticle(parameters);
            originalCall.run();
            ParticleCaptures.setParticle(null);
        }
    }

    @Unique
    private void particleEffects$markDebugData(int data, Runnable originalCall) {
        ParticleCaptures.setDebugData(data);
        originalCall.run();
        ParticleCaptures.setDebugData(null);
    }
}

