/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.pe.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import java.util.List;
import net.lopymine.pe.ParticleEffects;
import net.lopymine.pe.capture.ParticleCaptures;
import net.lopymine.pe.manager.ParticleEffectsManager;
import net.lopymine.pe.utils.ArgbUtils;
import net.lopymine.pe.utils.ListUtils;
import net.lopymine.pe.utils.PEType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AreaEffectCloud.class})
public abstract class AreaEffectCloudEntityMixin
extends Entity {
    @Unique
    private boolean particleEffects$needReset;
    @Unique
    private boolean particleEffects$needResetDebugData;

    @Shadow
    public abstract int m_19744_();

    public AreaEffectCloudEntityMixin(EntityType<?> type, Level world) {
        super(type, world);
    }

    @WrapOperation(at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/AreaEffectCloud;getParticle()Lnet/minecraft/core/particles/ParticleOptions;")}, method={"tick"})
    private ParticleOptions swapParticleType(AreaEffectCloud instance, Operation<ParticleOptions> original) {
        ParticleOptions originalParticle = (ParticleOptions)original.call(new Object[]{instance});
        if (!ParticleEffects.getConfig().isModEnabled()) {
            return this.particleEffects$markDebugData(31, originalParticle);
        }
        int color = this.m_19744_();
        List<ParticleOptions> list = ParticleEffectsManager.getParticleEffects(ArgbUtils.getColorWithoutAlpha(color));
        if (list == null) {
            return this.particleEffects$markDebugData(33, originalParticle);
        }
        if (list.isEmpty()) {
            return this.particleEffects$markDebugData(34, originalParticle);
        }
        ParticleOptions particleEffect = ListUtils.getRandomElement(list, this.m_9236_().m_213780_());
        if (particleEffect == null) {
            return this.particleEffects$markDebugData(35, originalParticle);
        }
        ((PEType)particleEffect).particleEffects$setColor(color);
        ParticleCaptures.setParticle(particleEffect);
        this.particleEffects$needReset = true;
        return particleEffect;
    }

    @Inject(at={@At(value="TAIL")}, method={"tick"})
    private void resetParticle(CallbackInfo ci) {
        if (this.particleEffects$needReset) {
            this.particleEffects$needReset = false;
            ParticleCaptures.setParticle(null);
        }
        if (this.particleEffects$needResetDebugData) {
            this.particleEffects$needResetDebugData = false;
            ParticleCaptures.setDebugData(null);
        }
    }

    @Unique
    private ParticleOptions particleEffects$markDebugData(int data, ParticleOptions originalParticle) {
        ParticleCaptures.setDebugData(data);
        this.particleEffects$needResetDebugData = true;
        return originalParticle;
    }
}

