/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.integration.jei.transfer;

import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import umpaz.brewinandchewin.common.block.entity.KegBlockEntity;
import umpaz.brewinandchewin.common.block.entity.container.KegMenu;
import umpaz.brewinandchewin.common.crafting.KegFermentingRecipe;
import umpaz.brewinandchewin.common.crafting.KegPouringRecipe;
import umpaz.brewinandchewin.common.registry.BnCRecipeTypes;
import umpaz.brewinandchewin.integration.jei.transfer.FermentingTransfer;

public class FermentingTransferServer {
    public static void setItems(Player player, KegFermentingRecipe recipe, FermentingTransfer.TransferOperations transferOperations, List<Slot> craftingSlots, List<Slot> inventorySlots, boolean maxTransfer) {
        AbstractContainerMenu abstractContainerMenu = player.f_36096_;
        if (!(abstractContainerMenu instanceof KegMenu)) {
            return;
        }
        KegMenu kegMenu = (KegMenu)abstractContainerMenu;
        Map<Slot, Pair<Slot, ItemStack>> recipeSlotToRequiredItemStack = FermentingTransferServer.calculateRequiredStacks(transferOperations, player);
        List<Pair<Slot, Pair<ItemStack, Integer>>> requiredFluidStacks = FermentingTransferServer.calculateRequiredFluidOrEmptyingStacks(transferOperations.fluidResults, player, (Either<KegFermentingRecipe, KegMenu>)Either.left((Object)recipe));
        List<Pair<Slot, Pair<ItemStack, Integer>>> requiredEmptyingStacks = FermentingTransferServer.calculateRequiredFluidOrEmptyingStacks(transferOperations.emptyingResults, player, (Either<KegFermentingRecipe, KegMenu>)Either.right((Object)((Object)kegMenu)));
        if (recipeSlotToRequiredItemStack == null || requiredFluidStacks == null || requiredEmptyingStacks == null) {
            return;
        }
        boolean transferAsCompleteSets = !maxTransfer;
        Map<Slot, ItemStack> recipeSlotToTakenStacks = FermentingTransferServer.takeItemsFromInventory(player, recipeSlotToRequiredItemStack, craftingSlots, inventorySlots, transferAsCompleteSets, maxTransfer);
        List<ItemStack> emptyingSlotToTakenStacks = FermentingTransferServer.takeFluidOrEmptyingItemsFromInventory(player, kegMenu, requiredEmptyingStacks, craftingSlots, inventorySlots, transferAsCompleteSets, maxTransfer, false);
        List<ItemStack> fluidSlotToTakenStacks = FermentingTransferServer.takeFluidOrEmptyingItemsFromInventory(player, kegMenu, requiredFluidStacks, craftingSlots, inventorySlots, transferAsCompleteSets, maxTransfer, true);
        if (recipeSlotToTakenStacks.isEmpty() && fluidSlotToTakenStacks.isEmpty() && emptyingSlotToTakenStacks.isEmpty()) {
            return;
        }
        boolean sameFluid = recipe.getFluidIngredient() != null && recipe.getFluidIngredient().isFluidEqual(kegMenu.kegTank.getFluid());
        List<ItemStack> clearedFluidItems = FermentingTransferServer.extractFromFluidTank(emptyingSlotToTakenStacks, kegMenu, false, null);
        if (sameFluid && !maxTransfer) {
            fluidSlotToTakenStacks = clearedFluidItems;
        } else {
            FermentingTransferServer.stowItems(player, inventorySlots, clearedFluidItems);
        }
        List<ItemStack> fluidItems = FermentingTransferServer.extractFromFluidTank(fluidSlotToTakenStacks, kegMenu, true, !maxTransfer ? recipe : null);
        List<ItemStack> clearedCraftingItems = FermentingTransferServer.clearCraftingGrid(craftingSlots, player);
        List<ItemStack> remainderItems = FermentingTransferServer.putItemsIntoCraftingGrid(recipeSlotToTakenStacks);
        FermentingTransferServer.stowItems(player, inventorySlots, fluidItems);
        FermentingTransferServer.stowItems(player, inventorySlots, clearedCraftingItems);
        FermentingTransferServer.stowItems(player, inventorySlots, remainderItems);
        kegMenu.blockEntity.m_6596_();
        player.m_9236_().m_7260_(kegMenu.blockEntity.m_58899_(), kegMenu.blockEntity.m_58900_(), kegMenu.blockEntity.m_58900_(), 2);
    }

    @NotNull
    private static Map<Slot, ItemStack> takeItemsFromInventory(Player player, Map<Slot, Pair<Slot, ItemStack>> recipeSlotToRequiredItemStack, List<Slot> craftingSlots, List<Slot> inventorySlots, boolean transferAsCompleteSets, boolean maxTransfer) {
        Map<Slot, ItemStack> foundItemsInSet;
        if (!maxTransfer) {
            return FermentingTransferServer.removeOneSetOfItemsFromInventory(player, recipeSlotToRequiredItemStack, craftingSlots, inventorySlots, transferAsCompleteSets);
        }
        HashMap<Slot, ItemStack> recipeSlotToResult = new HashMap<Slot, ItemStack>(recipeSlotToRequiredItemStack.size());
        while (!(foundItemsInSet = FermentingTransferServer.removeOneSetOfItemsFromInventory(player, recipeSlotToRequiredItemStack, craftingSlots, inventorySlots, transferAsCompleteSets)).isEmpty()) {
            Set<Slot> fullSlots = FermentingTransferServer.merge(recipeSlotToResult, foundItemsInSet);
            for (Slot fullSlot : fullSlots) {
                recipeSlotToRequiredItemStack.remove(fullSlot);
            }
        }
        return recipeSlotToResult;
    }

    private static Map<Slot, ItemStack> removeOneSetOfItemsFromInventory(Player player, Map<Slot, Pair<Slot, ItemStack>> recipeSlotToRequiredItemStack, List<Slot> craftingSlots, List<Slot> inventorySlots, boolean transferAsCompleteSets) {
        HashMap<Slot, ItemStack> originalSlotContents = null;
        if (transferAsCompleteSets) {
            originalSlotContents = new HashMap<Slot, ItemStack>();
        }
        HashMap<Slot, ItemStack> foundItemsInSet = new HashMap<Slot, ItemStack>(recipeSlotToRequiredItemStack.size());
        for (Map.Entry<Slot, Pair<Slot, ItemStack>> entry : recipeSlotToRequiredItemStack.entrySet()) {
            Slot hint;
            Slot recipeSlot = entry.getKey();
            ItemStack requiredStack = (ItemStack)entry.getValue().getSecond();
            Slot slot = FermentingTransferServer.getSlotWithStack(player, requiredStack, craftingSlots, inventorySlots, hint = (Slot)entry.getValue().getFirst()).orElse(null);
            if (slot != null) {
                if (originalSlotContents != null && !originalSlotContents.containsKey(slot)) {
                    originalSlotContents.put(slot, slot.m_7993_().m_41777_());
                }
                ItemStack removedItemStack = slot.m_6201_(1);
                foundItemsInSet.put(recipeSlot, removedItemStack);
                continue;
            }
            if (!transferAsCompleteSets) continue;
            for (Map.Entry slotEntry : originalSlotContents.entrySet()) {
                ItemStack stack = (ItemStack)slotEntry.getValue();
                ((Slot)slotEntry.getKey()).m_5852_(stack);
            }
            return Map.of();
        }
        return foundItemsInSet;
    }

    @NotNull
    private static List<ItemStack> takeFluidOrEmptyingItemsFromInventory(Player player, KegMenu kegMenu, List<Pair<Slot, Pair<ItemStack, Integer>>> requiredItemStacks, List<Slot> craftingSlots, List<Slot> inventorySlots, boolean transferAsCompleteSets, boolean maxTransfer, boolean insert) {
        Pair<List<ItemStack>, Integer> foundItemsInSet;
        if (!maxTransfer) {
            return (List)FermentingTransferServer.removeOneSetOfFluidOrEmptyingItemsFromInventory(player, requiredItemStacks, craftingSlots, inventorySlots, transferAsCompleteSets).getFirst();
        }
        ArrayList<ItemStack> recipeSlotToResult = new ArrayList<ItemStack>(requiredItemStacks.size());
        for (int fluidCapacity = 0; !(insert && fluidCapacity >= kegMenu.kegTank.getCapacity() || !insert && fluidCapacity >= kegMenu.kegTank.getFluidAmount() || ((List)(foundItemsInSet = FermentingTransferServer.removeOneSetOfFluidOrEmptyingItemsFromInventory(player, requiredItemStacks, craftingSlots, inventorySlots, transferAsCompleteSets)).getFirst()).isEmpty()); fluidCapacity += ((Integer)foundItemsInSet.getSecond()).intValue()) {
            recipeSlotToResult.addAll((Collection)foundItemsInSet.getFirst());
        }
        return recipeSlotToResult;
    }

    private static Pair<List<ItemStack>, Integer> removeOneSetOfFluidOrEmptyingItemsFromInventory(Player player, List<Pair<Slot, Pair<ItemStack, Integer>>> requiredItemStacks, List<Slot> craftingSlots, List<Slot> inventorySlots, boolean transferAsCompleteSets) {
        HashMap<Slot, ItemStack> originalSlotContents = null;
        if (transferAsCompleteSets) {
            originalSlotContents = new HashMap<Slot, ItemStack>();
        }
        ArrayList<ItemStack> foundItemsInSet = new ArrayList<ItemStack>(requiredItemStacks.size());
        int fluidAmount = 0;
        for (Pair<Slot, Pair<ItemStack, Integer>> entry : requiredItemStacks) {
            Slot hint;
            ItemStack requiredStack = (ItemStack)((Pair)entry.getSecond()).getFirst();
            Slot slot = FermentingTransferServer.getSlotWithStack(player, requiredStack, craftingSlots, inventorySlots, hint = (Slot)entry.getFirst()).orElse(null);
            if (slot != null) {
                if (originalSlotContents != null && !originalSlotContents.containsKey(slot)) {
                    originalSlotContents.put(slot, slot.m_7993_().m_41777_());
                }
                ItemStack removedItemStack = slot.m_6201_(requiredStack.m_41613_());
                foundItemsInSet.add(removedItemStack);
                fluidAmount += ((Integer)((Pair)entry.getSecond()).getSecond()).intValue();
                continue;
            }
            if (!transferAsCompleteSets) continue;
            for (Map.Entry slotEntry : originalSlotContents.entrySet()) {
                ItemStack stack = (ItemStack)slotEntry.getValue();
                ((Slot)slotEntry.getKey()).m_5852_(stack);
            }
            return Pair.of(List.of(), (Object)0);
        }
        return Pair.of(foundItemsInSet, (Object)fluidAmount);
    }

    private static Set<Slot> merge(Map<Slot, ItemStack> result, Map<Slot, ItemStack> addition) {
        HashSet<Slot> fullSlots = new HashSet<Slot>();
        addition.forEach((slot, itemStack) -> {
            assert (itemStack.m_41613_() == 1);
            ItemStack resultItemStack = (ItemStack)result.get(slot);
            if (resultItemStack == null) {
                resultItemStack = itemStack;
                result.put((Slot)slot, resultItemStack);
            } else {
                assert (ItemStack.m_150942_((ItemStack)resultItemStack, (ItemStack)itemStack));
                resultItemStack.m_41769_(itemStack.m_41613_());
            }
            if (resultItemStack.m_41613_() == slot.m_5866_(resultItemStack)) {
                fullSlots.add((Slot)slot);
            }
        });
        return fullSlots;
    }

    @Nullable
    private static Map<Slot, Pair<Slot, ItemStack>> calculateRequiredStacks(FermentingTransfer.TransferOperations transferOperations, Player player) {
        HashMap<Slot, Pair<Slot, ItemStack>> recipeSlotToRequired = new HashMap<Slot, Pair<Slot, ItemStack>>(transferOperations.results.size());
        for (Pair<Slot, Slot> transferOperation : transferOperations.results) {
            Slot recipeSlot = (Slot)transferOperation.getSecond();
            Slot inventorySlot = (Slot)transferOperation.getFirst();
            if (!inventorySlot.m_8010_(player)) {
                return null;
            }
            ItemStack slotStack = inventorySlot.m_7993_();
            if (slotStack.m_41619_()) {
                return null;
            }
            ItemStack stack = slotStack.m_41777_();
            stack.m_41764_(1);
            recipeSlotToRequired.put(recipeSlot, (Pair<Slot, ItemStack>)Pair.of((Object)inventorySlot, (Object)stack));
        }
        return recipeSlotToRequired;
    }

    @Nullable
    private static List<Pair<Slot, Pair<ItemStack, Integer>>> calculateRequiredFluidOrEmptyingStacks(List<Pair<Slot, Integer>> slots, Player player, Either<KegFermentingRecipe, KegMenu> pouringRecipeSource) {
        if (pouringRecipeSource.left().isPresent() && ((KegFermentingRecipe)pouringRecipeSource.left().get()).getFluidIngredient() == null) {
            return List.of();
        }
        ArrayList<Pair<Slot, Pair<ItemStack, Integer>>> recipeSlotToRequired = new ArrayList<Pair<Slot, Pair<ItemStack, Integer>>>(slots.size());
        for (Pair<Slot, Integer> inventorySlot : slots) {
            if (!((Slot)inventorySlot.getFirst()).m_8010_(player)) {
                return null;
            }
            ItemStack slotStack = ((Slot)inventorySlot.getFirst()).m_7993_();
            if (slotStack.m_41619_()) {
                return null;
            }
            ItemStack stack = slotStack.m_41777_();
            int fluidStackAmount = 1;
            List<KegPouringRecipe> pouringRecipes = Minecraft.m_91087_().f_91073_.m_7465_().m_44013_((RecipeType)BnCRecipeTypes.KEG_POURING.get()).stream().filter(kegPouringRecipe -> (pouringRecipeSource.left().isEmpty() || kegPouringRecipe.canFill()) && kegPouringRecipe.getFluid(stack).isFluidEqual((FluidStack)pouringRecipeSource.map(KegFermentingRecipe::getFluidIngredient, menu -> menu.kegTank.getFluid()))).toList();
            Optional<KegPouringRecipe> optionalData = pouringRecipes.stream().filter(pouring -> {
                if (pouring.isStrict()) {
                    return ItemStack.m_150942_((ItemStack)stack, (ItemStack)((ItemStack)pouringRecipeSource.map(ignored -> pouring.getOutput(), ignored -> pouring.getContainer())));
                }
                return ItemStack.m_41656_((ItemStack)stack, (ItemStack)((ItemStack)pouringRecipeSource.map(ignored -> pouring.getOutput(), ignored -> pouring.getContainer())));
            }).findFirst();
            if (optionalData.isPresent()) {
                fluidStackAmount = (Integer)pouringRecipeSource.map(fermentingRecipe -> fermentingRecipe.getFluidIngredient().getAmount(), kegMenu -> kegMenu.kegTank.getFluidAmount()) / optionalData.get().getAmount();
            }
            stack.m_41764_(fluidStackAmount);
            recipeSlotToRequired.add((Pair<Slot, Pair<ItemStack, Integer>>)Pair.of((Object)((Slot)inventorySlot.getFirst()), (Object)Pair.of((Object)stack, (Object)((Integer)inventorySlot.getSecond()))));
        }
        return recipeSlotToRequired;
    }

    private static void stowItems(Player player, List<Slot> inventorySlots, List<ItemStack> itemStacks) {
        for (ItemStack itemStack : itemStacks) {
            ItemStack remainder = FermentingTransferServer.stowItem(inventorySlots, itemStack);
            if (remainder.m_41619_() || player.m_150109_().m_36054_(remainder)) continue;
            player.m_36176_(remainder, false);
        }
    }

    private static List<ItemStack> extractFromFluidTank(List<ItemStack> emptyingStacks, KegMenu kegMenu, boolean insert, @Nullable KegFermentingRecipe recipe) {
        ArrayList<ItemStack> remainderItems = new ArrayList<ItemStack>();
        KegBlockEntity blockEntity = kegMenu.blockEntity;
        for (ItemStack stack : emptyingStacks) {
            List<KegPouringRecipe> pouringRecipes;
            Optional<KegPouringRecipe> optionalData;
            if (insert && kegMenu.kegTank.getFluidAmount() >= (recipe != null ? recipe.getFluidIngredient().getAmount() : kegMenu.kegTank.getCapacity()) || !insert && kegMenu.kegTank.isEmpty()) break;
            int toExtract = stack.m_41613_();
            if (recipe != null && recipe.getFluidIngredient() != null && (optionalData = (pouringRecipes = Minecraft.m_91087_().f_91073_.m_7465_().m_44013_((RecipeType)BnCRecipeTypes.KEG_POURING.get()).stream().filter(kegPouringRecipe -> (!insert || kegPouringRecipe.canFill()) && kegPouringRecipe.getFluid(stack).isFluidEqual(recipe.getFluidIngredient())).toList()).stream().filter(pouring -> {
                if (pouring.isStrict()) {
                    return ItemStack.m_150942_((ItemStack)stack, (ItemStack)pouring.getOutput());
                }
                return ItemStack.m_41656_((ItemStack)stack, (ItemStack)pouring.getOutput());
            }).findFirst()).isPresent()) {
                toExtract = recipe.getFluidIngredient().getAmount() / optionalData.get().getAmount();
            }
            List<ItemStack> extracted = blockEntity.extractInGui(stack, toExtract);
            for (ItemStack extract : extracted) {
                if (extract.m_41619_()) continue;
                remainderItems.add(extract);
            }
        }
        return remainderItems;
    }

    private static List<ItemStack> clearCraftingGrid(List<Slot> craftingSlots, Player player) {
        ArrayList<ItemStack> clearedCraftingItems = new ArrayList<ItemStack>();
        for (Slot craftingSlot : craftingSlots) {
            if (!craftingSlot.m_8010_(player) || !craftingSlot.m_6657_()) continue;
            ItemStack craftingItem = craftingSlot.m_6201_(Integer.MAX_VALUE);
            clearedCraftingItems.add(craftingItem);
        }
        return clearedCraftingItems;
    }

    private static List<ItemStack> putItemsIntoCraftingGrid(Map<Slot, ItemStack> recipeSlotToTakenStacks) {
        int slotStackLimit = FermentingTransferServer.getSlotStackLimit(recipeSlotToTakenStacks);
        ArrayList<ItemStack> remainderItems = new ArrayList<ItemStack>();
        recipeSlotToTakenStacks.forEach((slot, stack) -> {
            if (slot.m_7993_().m_41619_() && slot.m_5857_(stack)) {
                ItemStack remainder = slot.m_150656_(stack, slotStackLimit);
                if (!remainder.m_41619_()) {
                    remainderItems.add(remainder);
                }
            } else {
                remainderItems.add((ItemStack)stack);
            }
        });
        return remainderItems;
    }

    private static int getSlotStackLimit(Map<Slot, ItemStack> recipeSlotToTakenStacks) {
        return recipeSlotToTakenStacks.entrySet().stream().mapToInt(e -> {
            ItemStack transferItem;
            Slot craftingSlot = (Slot)e.getKey();
            if (craftingSlot.m_5857_(transferItem = (ItemStack)e.getValue())) {
                return craftingSlot.m_5866_(transferItem);
            }
            return Integer.MAX_VALUE;
        }).min().orElse(Integer.MAX_VALUE);
    }

    private static ItemStack stowItem(Collection<Slot> slots, ItemStack stack) {
        if (stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        ItemStack remainder = stack.m_41777_();
        for (Slot slot : slots) {
            ItemStack inventoryStack = slot.m_7993_();
            if (inventoryStack.m_41619_() || !inventoryStack.m_41753_()) continue;
            slot.m_150659_(remainder);
            if (!remainder.m_41619_()) continue;
            return ItemStack.f_41583_;
        }
        for (Slot slot : slots) {
            if (!slot.m_7993_().m_41619_()) continue;
            slot.m_150659_(remainder);
            if (!remainder.m_41619_()) continue;
            return ItemStack.f_41583_;
        }
        return remainder;
    }

    private static Optional<Slot> getSlotWithStack(Player player, ItemStack stack, List<Slot> craftingSlots, List<Slot> inventorySlots, Slot hint) {
        return FermentingTransferServer.getSlotWithStack(player, craftingSlots, stack).or(() -> FermentingTransferServer.getValidatedHintSlot(player, stack, hint)).or(() -> FermentingTransferServer.getSlotWithStack(player, inventorySlots, stack));
    }

    private static Optional<Slot> getValidatedHintSlot(Player player, ItemStack stack, Slot hint) {
        if (hint.m_8010_(player) && !hint.m_7993_().m_41619_() && ItemStack.m_150942_((ItemStack)stack, (ItemStack)hint.m_7993_())) {
            return Optional.of(hint);
        }
        return Optional.empty();
    }

    private static Optional<Slot> getSlotWithStack(Player player, Collection<Slot> slots, ItemStack itemStack) {
        return slots.stream().filter(slot -> {
            ItemStack slotStack = slot.m_7993_();
            return ItemStack.m_150942_((ItemStack)itemStack, (ItemStack)slotStack) && slot.m_8010_(player);
        }).findFirst();
    }
}

