/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.common.block.entity.container;

import it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.CompoundIngredient;
import net.minecraftforge.common.crafting.StrictNBTIngredient;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import umpaz.brewinandchewin.common.block.entity.KegBlockEntity;
import umpaz.brewinandchewin.common.block.entity.container.KegMenu;
import umpaz.brewinandchewin.common.crafting.KegFermentingRecipe;
import umpaz.brewinandchewin.common.mixin.StackedContentsRecipePickerAccessor;
import umpaz.brewinandchewin.common.registry.BnCRecipeTypes;

public class KegStackedContents
extends StackedContents {
    public final KegMenu menu;
    public final RecipeManager recipeManager;
    private boolean ignoreItems = false;
    private boolean ignoreFluids = false;

    public KegStackedContents(KegMenu menu, RecipeManager manager) {
        this.menu = menu;
        this.recipeManager = manager;
    }

    public void setIgnoreItems(boolean value) {
        this.ignoreItems = value;
    }

    public void setIgnoreFluids(boolean value) {
        this.ignoreFluids = value;
    }

    public boolean shouldIgnoreItems() {
        return this.ignoreItems;
    }

    public boolean isFluidItem(Recipe<?> recipe, int itemIndex) {
        return new RecipePicker(recipe).isFluidItem(itemIndex);
    }

    public boolean m_36478_(Recipe<?> recipe, @Nullable IntList stackingIndexList, int amount) {
        if (recipe instanceof KegFermentingRecipe) {
            KegFermentingRecipe fermentingRecipe = (KegFermentingRecipe)recipe;
            if (!KegBlockEntity.isValidTemp(this.menu.getKegTemperature(), fermentingRecipe.getTemperature())) {
                return false;
            }
        }
        return new RecipePicker(recipe).m_36512_(amount, stackingIndexList);
    }

    public int m_36471_(Recipe<?> recipe, int amount, @Nullable IntList stackingIndexList) {
        return new RecipePicker(recipe).m_36525_(amount, stackingIndexList);
    }

    public class RecipePicker
    extends StackedContents.RecipePicker {
        private final Int2IntMap stackCountRequirements;

        public RecipePicker(Recipe<?> recipe) {
            super((StackedContents)KegStackedContents.this, recipe);
            this.stackCountRequirements = new Int2IntArrayMap();
            if (recipe instanceof KegFermentingRecipe) {
                KegFermentingRecipe fermentingRecipe = (KegFermentingRecipe)recipe;
                boolean modified = false;
                FluidTank kegTank = KegStackedContents.this.menu.kegTank;
                StackedContentsRecipePickerAccessor accessor = (StackedContentsRecipePickerAccessor)((Object)this);
                if (KegStackedContents.this.ignoreItems) {
                    accessor.brewinandchewin$getIngredients().clear();
                    modified = true;
                }
                if (!KegStackedContents.this.ignoreFluids) {
                    if (fermentingRecipe.getFluidIngredient() == null && !kegTank.isEmpty()) {
                        List<PouringEntry> fluidContainerStacks = KegStackedContents.this.recipeManager.m_44013_((RecipeType)BnCRecipeTypes.KEG_POURING.get()).stream().filter(kegPouringRecipe -> kegPouringRecipe.getRawFluid().m_6212_(kegTank.getFluid().getRawFluid())).map(r -> new PouringEntry(r.getContainer(), r.getAmount(), r.isStrict())).toList();
                        if (!fluidContainerStacks.isEmpty()) {
                            for (PouringEntry entry : fluidContainerStacks) {
                                int itemAmount = kegTank.getFluid().getAmount() / entry.fluidAmount();
                                this.stackCountRequirements.put(StackedContents.m_36496_((ItemStack)entry.stack()), itemAmount);
                            }
                            Ingredient extractIngredient = Ingredient.m_43927_((ItemStack[])((ItemStack[])fluidContainerStacks.stream().map(PouringEntry::stack).toArray(ItemStack[]::new)));
                            extractIngredient.checkInvalidation();
                            extractIngredient.m_43908_();
                            extractIngredient.m_43931_();
                            accessor.brewinandchewin$getIngredients().add(extractIngredient);
                            modified = true;
                        }
                    } else if (fermentingRecipe.getFluidIngredient() != null) {
                        Object fluidContainerStacks;
                        List fluidOutputStacks = KegStackedContents.this.recipeManager.m_44013_((RecipeType)BnCRecipeTypes.KEG_POURING.get()).stream().filter(kegPouringRecipe -> kegPouringRecipe.canFill() && kegPouringRecipe.getRawFluid().m_6212_(fermentingRecipe.getFluidIngredient().getRawFluid())).map(r -> new PouringEntry(r.getOutput(), r.getAmount(), r.isStrict())).collect(Collectors.toCollection(ArrayList::new));
                        int tankAmount = kegTank.getFluidAmount();
                        if (!(kegTank.isEmpty() || kegTank.getFluid().isFluidEqual(fermentingRecipe.getFluidIngredient()) || (fluidContainerStacks = KegStackedContents.this.recipeManager.m_44013_((RecipeType)BnCRecipeTypes.KEG_POURING.get()).stream().filter(kegPouringRecipe -> kegPouringRecipe.getRawFluid().m_6212_(kegTank.getFluid().getRawFluid())).map(r -> new PouringEntry(r.getContainer(), r.getAmount(), r.isStrict())).toList()).isEmpty())) {
                            Iterator itemAmount = fluidContainerStacks.iterator();
                            while (itemAmount.hasNext()) {
                                PouringEntry entry = (PouringEntry)itemAmount.next();
                                int itemAmount2 = kegTank.getFluid().getAmount() / entry.fluidAmount();
                                tankAmount -= itemAmount2 * entry.fluidAmount();
                                this.stackCountRequirements.put(StackedContents.m_36496_((ItemStack)entry.stack()), itemAmount2);
                            }
                            Ingredient extractIngredient = Ingredient.m_43927_((ItemStack[])((ItemStack[])fluidContainerStacks.stream().map(PouringEntry::stack).toArray(ItemStack[]::new)));
                            extractIngredient.m_43908_();
                            extractIngredient.m_43931_();
                            accessor.brewinandchewin$getIngredients().add(extractIngredient);
                            modified = true;
                        }
                        if (!kegTank.isEmpty() && !kegTank.getFluid().isFluidEqual(fermentingRecipe.getFluidIngredient()) || tankAmount < fermentingRecipe.getFluidIngredient().getAmount()) {
                            for (PouringEntry entry : List.copyOf(fluidOutputStacks)) {
                                int itemAmount = Math.max(fermentingRecipe.getFluidIngredient().getAmount(), entry.fluidAmount() - tankAmount) / entry.fluidAmount() - tankAmount % fermentingRecipe.getFluidIngredient().getAmount() / entry.fluidAmount();
                                if (itemAmount <= 0 || itemAmount * entry.fluidAmount() + tankAmount > kegTank.getCapacity()) {
                                    fluidOutputStacks.remove(entry);
                                    continue;
                                }
                                this.stackCountRequirements.put(StackedContents.m_36496_((ItemStack)entry.stack()), itemAmount);
                            }
                            if (!fluidOutputStacks.isEmpty()) {
                                Ingredient fillIngredient = Ingredient.m_43927_((ItemStack[])((ItemStack[])fluidOutputStacks.stream().map(PouringEntry::stack).toArray(ItemStack[]::new)));
                                if (fluidOutputStacks.stream().anyMatch(PouringEntry::strict)) {
                                    fillIngredient = CompoundIngredient.of((Ingredient[])((Ingredient[])fluidOutputStacks.stream().map(p -> {
                                        if (p.strict()) {
                                            return StrictNBTIngredient.of((ItemStack)p.stack());
                                        }
                                        return Ingredient.m_43929_((ItemLike[])new ItemLike[]{p.stack().m_41720_()});
                                    }).toArray(Ingredient[]::new)));
                                }
                                fillIngredient.m_43908_();
                                fillIngredient.m_43931_();
                                accessor.brewinandchewin$getIngredients().add(fillIngredient);
                                modified = true;
                            }
                        }
                    }
                }
                if (!modified) {
                    return;
                }
                accessor.brewinandchewin$getIngredients().removeIf(Ingredient::m_43947_);
                accessor.brewinandchewin$setIngredientCount(accessor.brewinandchewin$getIngredients().size());
                accessor.brewinandchewin$setItems(accessor.brewinandchewin$invokeGetUniqueAvailableIngredientItems());
                accessor.brewinandchewin$setItemCount(accessor.brewinandchewin$getItems().length);
                accessor.brewinandchewin$setData(new BitSet(accessor.brewinandchewin$getIngredientCount() + accessor.brewinandchewin$getItemCount() + accessor.brewinandchewin$getIngredientCount() + accessor.brewinandchewin$getIngredientCount() * accessor.brewinandchewin$getItemCount()));
                for (int i = 0; i < accessor.brewinandchewin$getIngredients().size(); ++i) {
                    IntList intlist = accessor.brewinandchewin$getIngredients().get(i).m_43931_();
                    for (int j = 0; j < accessor.brewinandchewin$getItemCount(); ++j) {
                        if (!intlist.contains(accessor.brewinandchewin$getItems()[j])) continue;
                        int bitIndex = accessor.brewinandchewin$invokeGetIndex(true, j, i);
                        accessor.brewinandchewin$getData().set(bitIndex);
                    }
                }
            }
        }

        public boolean isFluidItem(int itemIndex) {
            return this.stackCountRequirements.containsKey(itemIndex);
        }

        public boolean hasFluidAmount(int originalAmount, int itemIndex) {
            return !this.isFluidItem(itemIndex) || originalAmount >= this.stackCountRequirements.get(itemIndex);
        }

        public KegStackedContents getOuter() {
            return KegStackedContents.this;
        }
    }

    public record PouringEntry(ItemStack stack, int fluidAmount, boolean strict) {
    }
}

