/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.worldgen.feature.tree;

import biomesoplenty.worldgen.feature.configurations.TwigletTreeConfiguration;
import biomesoplenty.worldgen.feature.tree.BOPTreeFeature;
import com.mojang.serialization.Codec;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.CocoaBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;

public class TwigletTreeFeature
extends BOPTreeFeature<TwigletTreeConfiguration> {
    public TwigletTreeFeature(Codec<TwigletTreeConfiguration> codec) {
        super(codec);
    }

    protected boolean m_225257_(WorldGenLevel world, RandomSource random, BlockPos startPos, BiConsumer<BlockPos, BlockState> roots, BiConsumer<BlockPos, BlockState> logs, FoliagePlacer.FoliageSetter leaves, TreeConfiguration configBase) {
        TwigletTreeConfiguration config = (TwigletTreeConfiguration)configBase;
        while (startPos.m_123342_() >= world.m_141937_() + 1 && startPos.m_123342_() <= world.m_151558_() - 1 && (world.m_46859_(startPos) || world.m_8055_(startPos).m_204336_(BlockTags.f_13035_))) {
            startPos = startPos.m_7495_();
        }
        if (world.m_8055_(startPos).m_60734_() == Blocks.f_50752_) {
            return false;
        }
        int height = config.minHeight + random.m_188503_(1 + config.maxHeight - config.minHeight);
        int baseHeight = height / 3;
        BlockPos pos = startPos.m_7494_();
        for (int y = 0; y < height; ++y) {
            float leafChance;
            if (!this.placeLog((LevelAccessor)world, pos.m_6630_(y), logs, config)) {
                return true;
            }
            float f = leafChance = (height - y) % 2 == 0 ? config.leafChanceEven : config.leafChanceOdd;
            if (y <= baseHeight) continue;
            if (random.m_188501_() < leafChance) {
                this.placeLeaves((LevelAccessor)world, pos.m_7918_(1, y, 0), leaves, config);
            }
            if (random.m_188501_() < leafChance) {
                this.placeLeaves((LevelAccessor)world, pos.m_7918_(-1, y, 0), leaves, config);
            }
            if (random.m_188501_() < leafChance) {
                this.placeLeaves((LevelAccessor)world, pos.m_7918_(0, y, 1), leaves, config);
            }
            if (random.m_188501_() < leafChance) {
                this.placeLeaves((LevelAccessor)world, pos.m_7918_(0, y, -1), leaves, config);
            }
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                BlockPos fruitPos = pos.m_7918_(dir.m_122429_(), y, dir.m_122431_());
                BlockState trunkFruit = config.trunkFruitProvider.m_213972_(random, fruitPos);
                if (trunkFruit.m_60734_() == Blocks.f_50016_ || random.m_188503_(4) != 0) continue;
                if (trunkFruit.m_60734_() == Blocks.f_50262_) {
                    fruitPos = pos.m_7918_(dir.m_122424_().m_122429_(), 0, dir.m_122424_().m_122431_());
                }
                this.generateTrunkFruit((LevelAccessor)world, random.m_188503_(3), fruitPos, dir, config);
            }
        }
        this.placeLeaves((LevelAccessor)world, pos.m_7918_(0, height, 0), leaves, config);
        return true;
    }

    private void generateTrunkFruit(LevelAccessor world, int age, BlockPos pos, Direction direction, TwigletTreeConfiguration config) {
        BlockState trunkFruit = config.trunkFruitProvider.m_213972_(world.m_213780_(), pos);
        if (trunkFruit == Blocks.f_50262_.m_49966_()) {
            if (world.m_8055_(pos).m_60734_() == Blocks.f_50016_ || world.m_8055_(pos).m_60734_() instanceof BushBlock) {
                this.m_5974_((LevelWriter)world, pos, (BlockState)((BlockState)trunkFruit.m_61124_((Property)CocoaBlock.f_51736_, (Comparable)Integer.valueOf(age))).m_61124_((Property)CocoaBlock.f_54117_, (Comparable)direction));
            }
        } else if (world.m_8055_(pos).m_60734_() == Blocks.f_50016_ || world.m_8055_(pos).m_60734_() instanceof BushBlock) {
            this.m_5974_((LevelWriter)world, pos, (BlockState)trunkFruit.m_61124_((Property)CocoaBlock.f_54117_, (Comparable)direction));
        }
    }
}

