/*
 * Decompiled with CFR 0.152.
 */
package tallestegg.guardvillagers.configuration;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="guardvillagers", bus=Mod.EventBusSubscriber.Bus.MOD)
public class GuardConfig {
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final CommonConfig COMMON;
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final ClientConfig CLIENT;
    public static boolean RaidAnimals;
    public static boolean WitchesVillager;
    public static boolean IllusionerRaids;
    public static boolean AttackAllMobs;
    public static boolean VillagersRunFromPolarBears;
    public static boolean IllagersRunFromPolarBears;
    public static boolean GuardsRunFromPolarBears;
    public static boolean GuardsOpenDoors;
    public static boolean GuardAlwaysShield;
    public static boolean GuardFormation;
    public static boolean FriendlyFire;
    public static boolean ConvertVillagerIfHaveHOTV;
    public static boolean BlackSmithHealing;
    public static boolean ClericHealing;
    public static double GuardVillagerHelpRange;
    public static float amountOfHealthRegenerated;
    public static boolean guardArrowsHurtVillagers;
    public static boolean armorerRepairGuardArmor;
    public static boolean giveGuardStuffHOTV;
    public static boolean setGuardPatrolHotv;
    public static boolean followHero;
    public static boolean guardSteve;
    public static int reputationRequirement;
    public static List<String> MobBlackList;

    public static void loadConfig(ForgeConfigSpec config, String path) {
        CommentedFileConfig file = (CommentedFileConfig)CommentedFileConfig.builder((File)new File(path)).sync().autosave().writingMode(WritingMode.REPLACE).build();
        file.load();
        config.setConfig((CommentedConfig)file);
    }

    public static void bakeCommonConfig() {
        RaidAnimals = (Boolean)GuardConfig.COMMON.RaidAnimals.get();
        WitchesVillager = (Boolean)GuardConfig.COMMON.WitchesVillager.get();
        IllusionerRaids = (Boolean)GuardConfig.COMMON.IllusionerRaids.get();
        AttackAllMobs = (Boolean)GuardConfig.COMMON.AttackAllMobs.get();
        VillagersRunFromPolarBears = (Boolean)GuardConfig.COMMON.VillagersRunFromPolarBears.get();
        IllagersRunFromPolarBears = (Boolean)GuardConfig.COMMON.IllagersRunFromPolarBears.get();
        GuardsRunFromPolarBears = (Boolean)GuardConfig.COMMON.GuardsRunFromPolarBears.get();
        GuardsOpenDoors = (Boolean)GuardConfig.COMMON.GuardsOpenDoors.get();
        GuardAlwaysShield = (Boolean)GuardConfig.COMMON.GuardRaiseShield.get();
        GuardFormation = (Boolean)GuardConfig.COMMON.GuardFormation.get();
        FriendlyFire = (Boolean)GuardConfig.COMMON.FriendlyFire.get();
        MobBlackList = (List)GuardConfig.COMMON.MobBlackList.get();
        ConvertVillagerIfHaveHOTV = (Boolean)GuardConfig.COMMON.ConvertVillagerIfHaveHOTV.get();
        BlackSmithHealing = (Boolean)GuardConfig.COMMON.BlacksmithHealing.get();
        ClericHealing = (Boolean)GuardConfig.COMMON.ClericHealing.get();
        GuardVillagerHelpRange = (Double)GuardConfig.COMMON.GuardVillagerHelpRange.get();
        amountOfHealthRegenerated = ((Double)GuardConfig.COMMON.amountOfHealthRegenerated.get()).floatValue();
        guardArrowsHurtVillagers = (Boolean)GuardConfig.COMMON.guardArrowsHurtVillagers.get();
        armorerRepairGuardArmor = (Boolean)GuardConfig.COMMON.armorersRepairGuardArmor.get();
        giveGuardStuffHOTV = (Boolean)GuardConfig.COMMON.giveGuardStuffHOTV.get();
        setGuardPatrolHotv = (Boolean)GuardConfig.COMMON.setGuardPatrolHotv.get();
        reputationRequirement = (Integer)GuardConfig.COMMON.reputationRequirement.get();
        followHero = (Boolean)GuardConfig.COMMON.followHero.get();
    }

    public static void bakeClientConfig() {
        guardSteve = (Boolean)GuardConfig.CLIENT.GuardSteve.get();
    }

    @SubscribeEvent
    public static void onModConfigEvent(ModConfigEvent.Loading configEvent) {
        if (configEvent.getConfig().getSpec() == COMMON_SPEC) {
            GuardConfig.bakeCommonConfig();
        } else if (configEvent.getConfig().getSpec() == CLIENT_SPEC) {
            GuardConfig.bakeClientConfig();
        }
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(CommonConfig::new);
        COMMON = (CommonConfig)specPair.getLeft();
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        Pair specPair1 = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        CLIENT = (ClientConfig)specPair1.getLeft();
        CLIENT_SPEC = (ForgeConfigSpec)specPair1.getRight();
    }

    public static class CommonConfig {
        public final ForgeConfigSpec.BooleanValue RaidAnimals;
        public final ForgeConfigSpec.BooleanValue WitchesVillager;
        public final ForgeConfigSpec.BooleanValue IllusionerRaids;
        public final ForgeConfigSpec.BooleanValue AttackAllMobs;
        public final ForgeConfigSpec.BooleanValue VillagersRunFromPolarBears;
        public final ForgeConfigSpec.BooleanValue IllagersRunFromPolarBears;
        public final ForgeConfigSpec.BooleanValue GuardsRunFromPolarBears;
        public final ForgeConfigSpec.BooleanValue GuardsOpenDoors;
        public final ForgeConfigSpec.BooleanValue GuardRaiseShield;
        public final ForgeConfigSpec.BooleanValue GuardFormation;
        public final ForgeConfigSpec.BooleanValue FriendlyFire;
        public final ForgeConfigSpec.BooleanValue ConvertVillagerIfHaveHOTV;
        public final ForgeConfigSpec.BooleanValue multiFollow;
        public final ForgeConfigSpec.BooleanValue BlacksmithHealing;
        public final ForgeConfigSpec.BooleanValue ClericHealing;
        public final ForgeConfigSpec.DoubleValue GuardVillagerHelpRange;
        public final ForgeConfigSpec.DoubleValue amountOfHealthRegenerated;
        public final ForgeConfigSpec.DoubleValue healthModifier;
        public final ForgeConfigSpec.DoubleValue speedModifier;
        public final ForgeConfigSpec.DoubleValue followRangeModifier;
        public final ForgeConfigSpec.BooleanValue ironGolemFloat;
        public final ForgeConfigSpec.BooleanValue guardArrowsHurtVillagers;
        public final ForgeConfigSpec.BooleanValue armorersRepairGuardArmor;
        public final ForgeConfigSpec.ConfigValue<List<String>> MobBlackList;
        public final ForgeConfigSpec.ConfigValue<List<String>> MobWhiteList;
        public final ForgeConfigSpec.BooleanValue giveGuardStuffHOTV;
        public final ForgeConfigSpec.BooleanValue setGuardPatrolHotv;
        public final ForgeConfigSpec.BooleanValue followHero;
        public final ForgeConfigSpec.BooleanValue guardTeleport;
        public final ForgeConfigSpec.IntValue reputationRequirement;
        public final ForgeConfigSpec.IntValue reputationRequirementToBeAttacked;
        public final ForgeConfigSpec.DoubleValue chanceToDropEquipment;
        public final ForgeConfigSpec.BooleanValue MobsAttackGuards;
        public final ForgeConfigSpec.BooleanValue guardPatrol;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> convertibleProfessions;
        public final ForgeConfigSpec.DoubleValue chanceToBreakEquipment;
        public final ForgeConfigSpec.BooleanValue convertGuardOnDeath;
        public final ForgeConfigSpec.DoubleValue guardCrossbowAttackRadius;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> professionsThatHeal;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> professionsThatRepairGolems;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> professionsThatRepairGuards;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> structuresThatSpawnGuards;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> mobsGuardsProtectTargeted;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> mobsGuardsProtectHurt;
        public final ForgeConfigSpec.IntValue maxClericHeal;
        public final ForgeConfigSpec.IntValue maxGolemRepair;
        public final ForgeConfigSpec.IntValue maxVillageRepair;
        public final ForgeConfigSpec.BooleanValue guardSinkToFightUnderWater;
        public final ForgeConfigSpec.IntValue guardSpawnInVillage;
        public final ForgeConfigSpec.DoubleValue friendlyFireCheckValue;
        public final ForgeConfigSpec.IntValue depthGuardHuntUnderwater;

        public CommonConfig(ForgeConfigSpec.Builder builder) {
            builder.push("raids and illagers");
            this.RaidAnimals = builder.comment("Illagers In Raids Attack Animals?").translation("guardvillagers.config.RaidAnimals").define("Illagers in raids attack animals?", true);
            this.WitchesVillager = builder.comment("Witches Attack Villagers?").translation("guardvillagers.config.WitchesVillager").define("Witches attack villagers?", true);
            this.IllusionerRaids = builder.comment("This will make Illusioners get involved in raids").translation("guardvillagers.config.IllusionerRaids").define("Have Illusioners in raids?", false);
            this.IllagersRunFromPolarBears = builder.comment("This makes Illagers run from polar bears, as anyone with common sense would.").translation("guardvillagers.config.IllagersRunFromPolarBears").define("Have Illagers have some common sense?", true);
            builder.pop();
            builder.push("mob ai in general");
            this.AttackAllMobs = builder.comment("Guards will attack all hostiles with this option, when set to false guards will only attack zombies and illagers.").translation("guardvillagers.config.AttackAllMobs").define("Guards attack all mobs?", true);
            this.MobsAttackGuards = builder.comment("Hostiles attack guards, by default only illagers and zombies will attack guards, the mob blacklist below will effect this option").define("All mobs attack guards", false);
            this.MobBlackList = builder.comment("Guards won't attack mobs in this list at all, for example, putting \"minecraft:creeper\" in this list will make guards ignore creepers.").define("Mob Blacklist", (Object)Lists.newArrayList((Object[])new String[]{"minecraft:villager", "minecraft:iron_golem", "minecraft:wandering_trader", "guardvillagers:guard", "minecraft:creeper", "alexsmobs:komodo_dragon", "minecraft:enderman"}));
            this.MobWhiteList = builder.comment("Guards will additionally attack mobs ids put in this list, for example, putting \"minecraft:cow\" in this list will make guards attack cows.").define("Mob Whitelist", new ArrayList());
            builder.pop();
            builder.push("villager stuff");
            this.professionsThatHeal = builder.defineListAllowEmpty("Profession Whitelist for healing ai for clerics", (List)Lists.newArrayList((Object[])new String[]{"cleric"}), obj -> true);
            this.professionsThatRepairGolems = builder.defineListAllowEmpty("Profession Whitelist for golem repair ai", (List)Lists.newArrayList((Object[])new String[]{"armorer", "weaponsmith"}), obj -> true);
            this.professionsThatRepairGuards = builder.defineListAllowEmpty("Profession Whitelist for guard weaponry repair ai", (List)Lists.newArrayList((Object[])new String[]{"weaponsmith", "armorer"}), obj -> true);
            this.maxClericHeal = builder.defineInRange("How many times a cleric can heal a guard in one day", 3, 0, 1000000);
            this.maxGolemRepair = builder.defineInRange("How many times a smith villager can heal a golem in one day", 3, 0, 1000000);
            this.maxVillageRepair = builder.defineInRange("How many times a villager can heal a guard's equipment in one day", 3, 0, 1000000);
            this.armorersRepairGuardArmor = builder.translation("guardvillagers.config.armorvillager").define("Allow armorers and weaponsmiths repair guard items when down below half durability?", true);
            this.ConvertVillagerIfHaveHOTV = builder.comment("This will make it so villagers will only be converted into guards if the player has hero of the village").translation("guardvillagers.config.hotv").define("Make it so players have to have hero of the village to convert villagers into guards?", false);
            this.BlacksmithHealing = builder.translation("guardvillagers.config.blacksmith").define("Have it so blacksmiths heal golems under 60 health?", true);
            this.ClericHealing = builder.translation("guardvillagers.config.cleric").define("Have it so clerics heal guards and players with hero of the village?", true);
            this.VillagersRunFromPolarBears = builder.comment("This makes villagers run from polar bears, as anyone with common sense would.").translation("guardvillagers.config.VillagersRunFromPolarBears").define("Have Villagers have some common sense?", true);
            this.convertibleProfessions = builder.comment("Professions that can be converted into guards").define("Profession Whitelist for guard conversion", (Object)Lists.newArrayList((Object[])new String[]{"nitwit", "none"}), obj -> true);
            builder.pop();
            builder.push("golem stuff");
            this.ironGolemFloat = builder.define("Allow Iron Golems to float on water?", false);
            builder.pop();
            builder.push("guard stuff");
            this.guardSpawnInVillage = builder.defineInRange("How many guards should spawn in a village?", 6, 0, 100000000);
            this.guardSinkToFightUnderWater = builder.define("Allow guards to sink temporarily to fight mobs that are under water?", true);
            this.depthGuardHuntUnderwater = builder.comment("If a guard is fighting a mob underwater and the vertical distance between that mob and the guard is larger than this, the guard will instead float up to not take the risk of drowning").defineInRange("Depth value for guards fighting underwater mobs", 8, 0, 100000000);
            this.mobsGuardsProtectTargeted = builder.defineListAllowEmpty("Mobs that guards actively protect when they get targeted", (List)Lists.newArrayList((Object[])new String[]{"minecraft:villager", "guardvillagers:guard", "minecraft:iron_golem"}), obj -> true);
            this.mobsGuardsProtectHurt = builder.comment("Mobs in this list also won't get hurt by a guard's arrow if the config option to disable guard arrows hurting villagers is enabled.").defineListAllowEmpty("Mobs that guards actively protect when they get hurt", (List)Lists.newArrayList((Object[])new String[]{"minecraft:villager", "guardvillagers:guard", "minecraft:iron_golem"}), obj -> true);
            this.structuresThatSpawnGuards = builder.comment("Guards are placed in the middle, thus more advanced placement should be done via datapacks").define("Structure pieces that spawn guards", (Object)Lists.newArrayList((Object[])new String[]{"minecraft:village/common/iron_golem"}), obj -> true);
            this.guardCrossbowAttackRadius = builder.defineInRange("Guard crossbow attack radius", 8.0, 0.0, 1.0E8);
            this.convertGuardOnDeath = builder.define("Allow guards to convert to zombie villagers upon being killed by zombies?", true);
            this.multiFollow = builder.translation("guardvillagers.config.multifollow").define("Allow the player to right click on bells to mass order guards to follow them?", true);
            this.guardPatrol = builder.define("Have guards patrol the village regularly?", false);
            this.chanceToDropEquipment = builder.defineInRange("Chance to drop equipment", 100.0, (double)-999.9f, 999.0);
            this.GuardsRunFromPolarBears = builder.comment("This makes Guards run from polar bears, as anyone with common sense would.").translation("guardvillagers.config.IllagersRunFromPolarBears").define("Have Guards have some common sense?", false);
            this.GuardsOpenDoors = builder.comment("This lets Guards open doors.").translation("guardvillagers.config.GuardsOpenDoors").define("Have Guards open doors?", true);
            this.GuardRaiseShield = builder.comment("This will make guards raise their shields all the time, on default they will only raise their shields under certain conditions").translation("guardvillagers.config.GuardRaiseShield").define("Have Guards raise their shield all the time?", false);
            this.chanceToBreakEquipment = builder.defineInRange("Chance for guards to lose durability", 1.0, (double)-999.9f, 999.0);
            this.guardTeleport = builder.define("Allow guards to teleport if following the player", true);
            this.GuardFormation = builder.comment("This makes guards form a phalanx").translation("guardvillagers.config.GuardFormation").define("Have guards form a phalanx?", true);
            this.FriendlyFire = builder.translation("guardvillagers.config.FriendlyFire").define("Have guards attempt to avoid firing into other friendlies?", true);
            this.friendlyFireCheckValue = builder.comment("Angle is determined by taking the arccos of the inputted value, for example -1 is a straight 180 degree angle thus if that value is inputted guards will only check straight ahead to see if any friendly mobs are in the way.").defineInRange("Angle of how ranged guards determine if a friendly mob is in front of them before firing", -0.9, -1000000.0, 1000000.0);
            this.GuardVillagerHelpRange = builder.translation("guardvillagers.config.range").comment("This is the range in which the guards will be aggroed to mobs that are attacking villagers. Higher values are more resource intensive, and setting this to zero will disable the goal.").defineInRange("Range", 50.0, -500.0, 500.0);
            this.amountOfHealthRegenerated = builder.translation("guardvillagers.config.amountofHealthRegenerated").comment("How much health a guard regenerates.").defineInRange("Guard health regeneration amount", 1.0, -500.0, 500.0);
            this.guardArrowsHurtVillagers = builder.translation("guardvillagers.config.guardArrows").define("Allow guard arrows to damage villagers, iron golems, or other guards? The i-frames will still be shown for them but they won't lose any health if this is set to false", true);
            this.giveGuardStuffHOTV = builder.translation("guardvillagers.config.hotvArmor").define("Allow players to give guards stuff only if they have the hero of the village effect?", false);
            this.setGuardPatrolHotv = builder.translation("guardvillagers.config.hotvPatrolPoint").define("Allow players to set guard patrol points only if they have hero of the village", false);
            this.reputationRequirement = builder.defineInRange("Minimum reputation requirement for guards to give you access to their inventories", 15, Integer.MIN_VALUE, Integer.MAX_VALUE);
            this.healthModifier = builder.defineInRange("Guard health", 20.0, -500.0, 900.0);
            this.speedModifier = builder.defineInRange("Guard speed", 0.5, -500.0, 900.0);
            this.followRangeModifier = builder.defineInRange("Guard follow range", 20.0, 0.0, 900.0);
            this.followHero = builder.define("Have guards only follow the player if they have hero of the village?", true);
            this.reputationRequirementToBeAttacked = builder.defineInRange("How low of a reputation of a player should have to be instantly aggroed upon by guards and golems?", -100, -9999, 9999);
            builder.pop();
        }
    }

    public static class ClientConfig {
        public final ForgeConfigSpec.BooleanValue GuardSteve;
        public final ForgeConfigSpec.BooleanValue bigHeadBabyVillager;
        public final ForgeConfigSpec.BooleanValue guardInventoryNumbers;

        public ClientConfig(ForgeConfigSpec.Builder builder) {
            this.GuardSteve = builder.comment("Textures not included, make your own textures by making a resource pack that adds guard_steve_0 - 6").translation("guardvillagers.config.steveModel").define("Have guards use the steve model?", false);
            this.bigHeadBabyVillager = builder.define("Have baby villagers have big heads like in bedrock?", true);
            this.guardInventoryNumbers = builder.comment("Note that this option will automatically activate if a guard has more hearts than default").define("Display guard health in icons", true);
        }
    }
}

