/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.origins.client;

import com.google.common.collect.ImmutableList;
import io.github.apace100.origins.screen.ChooseOriginScreen;
import io.github.apace100.origins.screen.ViewOriginScreen;
import io.github.apace100.origins.screen.WaitForNextLayerScreen;
import io.github.apace100.origins.util.PowerKeyManager;
import io.github.edwinmindcraft.calio.api.event.CalioDynamicRegistryEvent;
import io.github.edwinmindcraft.origins.api.OriginsAPI;
import io.github.edwinmindcraft.origins.api.capabilities.IOriginContainer;
import io.github.edwinmindcraft.origins.api.origin.OriginLayer;
import io.github.edwinmindcraft.origins.client.OriginsClient;
import io.github.edwinmindcraft.origins.client.screen.WaitForPowersScreen;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="origins")
public class OriginsClientEventHandler {
    @SubscribeEvent
    public static void renderTick(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            Screen screen;
            Minecraft instance = Minecraft.m_91087_();
            if (OriginsClient.AWAITING_DISPLAY.get() && instance.f_91080_ == null && instance.f_91074_ != null) {
                IOriginContainer.get((Entity)instance.f_91074_).ifPresent(container -> {
                    List<Holder.Reference> layers = OriginsAPI.getActiveLayers().stream().filter(x -> !container.hasOrigin((Holder<OriginLayer>)x)).sorted(Comparator.comparing(Holder::m_203334_)).toList();
                    if (layers.size() > 0) {
                        instance.m_91152_((Screen)new ChooseOriginScreen((List<Holder<OriginLayer>>)ImmutableList.copyOf(layers), 0, OriginsClient.SHOW_DIRT_BACKGROUND));
                        OriginsClient.AWAITING_DISPLAY.set(false);
                    }
                });
            }
            if (OriginsClient.WAITING_FOR_POWERS.get()) {
                Minecraft.m_91087_().m_91152_((Screen)new WaitForPowersScreen(OriginsClient.SHOW_DIRT_BACKGROUND, OriginsClient.WAITING_POWERS, OriginsClient.SELECTION_WAS_ORB));
                OriginsClient.WAITING_POWERS.clear();
                OriginsClient.WAITING_FOR_POWERS.set(false);
            }
            if (OriginsClient.OPEN_NEXT_LAYER.get() && (screen = instance.f_91080_) instanceof WaitForNextLayerScreen) {
                WaitForNextLayerScreen screen2 = (WaitForNextLayerScreen)screen;
                screen2.openSelection();
            }
        }
    }

    @SubscribeEvent
    public static void onKeyPressed(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            while (io.github.apace100.origins.OriginsClient.viewCurrentOriginKeybind.m_90859_()) {
                if (Minecraft.m_91087_().f_91080_ instanceof ViewOriginScreen) continue;
                Minecraft.m_91087_().m_91152_((Screen)new ViewOriginScreen());
            }
        }
    }

    @SubscribeEvent
    public static void onCalioRegistryClear(CalioDynamicRegistryEvent.Reload event) {
        PowerKeyManager.clearCache();
    }
}

