/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.util;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import org.jetbrains.annotations.Nullable;

public class DeferredHolder<T>
implements Holder<T> {
    protected final ResourceKey<T> key;
    @Nullable
    private Holder<T> holder = null;

    public static <T> Codec<DeferredHolder<T>> codec(ResourceKey<? extends Registry<T>> registryKey) {
        return ResourceKey.m_195966_(registryKey).xmap(DeferredHolder::new, DeferredHolder::getKey);
    }

    public static <T> DeferredHolder<T> create(ResourceKey<? extends Registry<T>> registryKey, ResourceLocation valueName) {
        return DeferredHolder.create(ResourceKey.m_135785_(registryKey, (ResourceLocation)valueName));
    }

    public static <T> DeferredHolder<T> create(ResourceLocation registryName, ResourceLocation valueName) {
        return DeferredHolder.create(ResourceKey.m_135788_((ResourceLocation)registryName), valueName);
    }

    public static <T> DeferredHolder<T> create(ResourceKey<T> key) {
        return new DeferredHolder<T>(key);
    }

    protected DeferredHolder(ResourceKey<T> key) {
        this.key = Objects.requireNonNull(key);
        this.bind(false);
    }

    public T m_203334_() {
        this.bind(true);
        if (this.holder == null) {
            throw new NullPointerException("Trying to access unbound value: " + String.valueOf(this.key));
        }
        return (T)this.holder.m_203334_();
    }

    public T get() {
        return this.m_203334_();
    }

    public Optional<T> asOptional() {
        return this.m_203633_() ? Optional.of(this.m_203334_()) : Optional.empty();
    }

    @Nullable
    protected Registry<T> getRegistry() {
        return (Registry)BuiltInRegistries.f_257047_.m_7745_(this.key.m_211136_());
    }

    protected final void bind(boolean throwOnMissingRegistry) {
        if (this.holder != null) {
            return;
        }
        Registry<T> registry = this.getRegistry();
        if (registry != null) {
            this.holder = registry.m_203636_(this.key).orElse(null);
        } else if (throwOnMissingRegistry) {
            throw new IllegalStateException("Registry not present for " + String.valueOf(this) + ": " + String.valueOf(this.key.m_211136_()));
        }
    }

    public ResourceLocation getId() {
        return this.key.m_135782_();
    }

    public ResourceKey<T> getKey() {
        return this.key;
    }

    public boolean equals(Object obj) {
        Holder h;
        if (this == obj) {
            return true;
        }
        return obj instanceof Holder && (h = (Holder)obj).m_203376_() == Holder.Kind.REFERENCE && h.m_203543_().get() == this.key;
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public String toString() {
        return String.format(Locale.ENGLISH, "DeferredHolder{%s}", this.key);
    }

    public boolean m_203633_() {
        this.bind(false);
        return this.holder != null && this.holder.m_203633_();
    }

    public boolean m_203373_(ResourceLocation id) {
        return id.equals((Object)this.key.m_135782_());
    }

    public boolean m_203565_(ResourceKey<T> key) {
        return key == this.key;
    }

    public boolean m_203425_(Predicate<ResourceKey<T>> filter) {
        return filter.test(this.key);
    }

    public boolean m_203656_(TagKey<T> tag) {
        this.bind(false);
        return this.holder != null && this.holder.m_203656_(tag);
    }

    public Stream<TagKey<T>> m_203616_() {
        this.bind(false);
        return this.holder != null ? this.holder.m_203616_() : Stream.empty();
    }

    public Either<ResourceKey<T>, T> m_203439_() {
        return Either.left(this.key);
    }

    public Optional<ResourceKey<T>> m_203543_() {
        return Optional.of(this.key);
    }

    public Holder.Kind m_203376_() {
        return Holder.Kind.REFERENCE;
    }

    public boolean m_203401_(HolderOwner<T> owner) {
        this.bind(false);
        return this.holder != null && this.holder.m_203401_(owner);
    }
}

