/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.item.loader;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import snownee.kiwi.customization.item.KItemSettings;
import snownee.kiwi.customization.item.loader.ConfiguredItemTemplate;
import snownee.kiwi.customization.item.loader.ItemDefinitionProperties;
import snownee.kiwi.customization.item.loader.KItemTemplate;
import snownee.kiwi.util.codec.CustomizationCodecs;

public record KItemDefinition(ConfiguredItemTemplate template, ItemDefinitionProperties properties) {
    public KItemDefinition(ConfiguredItemTemplate template, ItemDefinitionProperties properties) {
        this.template = template;
        this.properties = template.template().properties().map(properties::merge).orElse(properties);
    }

    public static Codec<KItemDefinition> codec(Map<ResourceLocation, KItemTemplate> templates) {
        KItemTemplate defaultTemplate = templates.get(new ResourceLocation("item"));
        Preconditions.checkNotNull((Object)defaultTemplate);
        ConfiguredItemTemplate defaultConfiguredTemplate = new ConfiguredItemTemplate(defaultTemplate);
        return RecordCodecBuilder.create(instance -> instance.group((App)CustomizationCodecs.strictOptionalField(ConfiguredItemTemplate.codec(templates), "template", defaultConfiguredTemplate).forGetter(KItemDefinition::template), (App)ItemDefinitionProperties.mapCodec().forGetter(KItemDefinition::properties)).apply((Applicative)instance, KItemDefinition::new));
    }

    public KItemSettings.Builder createSettings(ResourceLocation id) {
        KItemSettings.Builder builder = KItemSettings.builder();
        ItemDefinitionProperties.PartialVanillaProperties vanilla = this.properties.vanillaProperties();
        builder.configure($ -> {
            vanilla.maxStackSize().ifPresent(arg_0 -> ((Item.Properties)$).m_41487_(arg_0));
            vanilla.maxDamage().ifPresent(arg_0 -> ((Item.Properties)$).m_41503_(arg_0));
            vanilla.craftingRemainingItem().map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.f_257033_).m_6246_(arg_0)).ifPresent(arg_0 -> ((Item.Properties)$).m_41495_(arg_0));
            vanilla.food().ifPresent(arg_0 -> ((Item.Properties)$).m_41489_(arg_0));
            vanilla.rarity().ifPresent(arg_0 -> ((Item.Properties)$).m_41497_(arg_0));
        });
        return builder;
    }

    public Item createItem(ResourceLocation id) {
        KItemSettings.Builder builder = this.createSettings(id);
        return this.template.template().createItem(id, builder.get(), this.template.json());
    }
}

