/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.builder;

import com.google.common.collect.Sets;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHandler;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.tooltip.BelowOrAboveWidgetTooltipPositioner;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2f;
import org.joml.Vector2i;
import org.lwjgl.glfw.GLFW;
import snownee.kiwi.customization.builder.ItemButton;
import snownee.kiwi.customization.builder.PanelLayout;
import snownee.kiwi.customization.network.CConvertItemPacket;
import snownee.kiwi.loader.Platform;
import snownee.kiwi.util.LerpedFloat;
import snownee.kiwi.util.MultilineTooltip;
import snownee.kiwi.util.NotNullByDefault;

@NotNullByDefault
public class ConvertScreen
extends Screen {
    private static ConvertScreen lingeringScreen;
    private final boolean inContainer;
    private final boolean inCreativeContainer;
    @Nullable
    private final Slot slot;
    private final int slotIndex;
    private final Collection<CConvertItemPacket.Group> groups;
    private final LerpedFloat openProgress = LerpedFloat.linear();
    private PanelLayout layout;
    private final Vector2i originalMousePos;
    private final ItemStack sourceItem;
    private ClientTooltipPositioner forcedTooltipPositioner;
    private final Set<Item> chosenItems = Sets.newIdentityHashSet();
    @Nullable
    private AbstractWidget lastFocused;

    private static Vector2i getMousePos() {
        Minecraft mc = Minecraft.m_91087_();
        MouseHandler mouseHandler = mc.f_91067_;
        return new Vector2i((int)mouseHandler.m_91589_(), (int)mouseHandler.m_91594_());
    }

    public ConvertScreen(@Nullable Screen parent, @Nullable Slot slot, int slotIndex, List<CConvertItemPacket.Group> groups) {
        super((Component)Component.m_237115_((String)"gui.kiwi.builder.convert"));
        this.slot = slot;
        this.slotIndex = slotIndex;
        this.groups = groups;
        this.inContainer = parent instanceof AbstractContainerScreen;
        this.inCreativeContainer = this.inContainer && parent instanceof CreativeModeInventoryScreen;
        this.originalMousePos = ConvertScreen.getMousePos();
        this.openProgress.setValue(0.2f);
        this.openProgress.chase(1.0, 0.8, LerpedFloat.Chaser.EXP);
        this.sourceItem = this.getSourceItem();
        this.chosenItems.add(this.sourceItem.m_41720_());
    }

    private ItemStack getSourceItem() {
        if (this.slot != null) {
            return this.slot.m_7993_();
        }
        Inventory inventory = Objects.requireNonNull(Minecraft.m_91087_().f_91074_).m_150109_();
        return inventory.m_8020_(this.slotIndex);
    }

    /*
     * WARNING - void declaration
     */
    protected void m_7856_() {
        void var9_18;
        Vector2f anchor;
        int y;
        this.lastFocused = null;
        this.layout = new PanelLayout(2);
        int step = this.inContainer ? 19 : 21;
        int xStart = 0;
        int yStart = 0;
        int curX = xStart;
        int curY = yStart;
        HashSet accepted = Sets.newHashSet();
        LocalPlayer player = Objects.requireNonNull(this.f_96541_.f_91074_);
        for (CConvertItemPacket.Group group : this.groups) {
            accepted.addAll(group.entries());
        }
        int itemsPerLine = accepted.size() > 30 ? 11 : 4;
        for (CConvertItemPacket.Group group : this.groups) {
            for (CConvertItemPacket.Entry entry : group.entries()) {
                List<Component> tooltip;
                if (!accepted.contains(entry)) continue;
                ItemStack itemStack = new ItemStack((ItemLike)entry.item());
                ItemButton button = (ItemButton)ItemButton.builder(itemStack, this.inContainer, btn -> this.shortPress((ItemButton)btn, entry)).m_252987_(curX, curY, 21, 21).m_253136_();
                button.f_93717_ = btn -> {
                    if (btn.pressTime() >= 10) {
                        this.longPress((ItemButton)((Object)((Object)btn)), entry);
                    }
                };
                button.onRelease = btn -> {
                    if (!ConvertScreen.m_96637_()) {
                        this.m_7379_();
                    }
                };
                button.m_93650_(this.inContainer ? 0.2f : 0.8f);
                if (Platform.isProduction()) {
                    tooltip = List.of(itemStack.m_41786_());
                } else {
                    String steps = String.join((CharSequence)" -> ", entry.steps().stream().map(Pair::getFirst).map(Objects::toString).toList());
                    tooltip = List.of(itemStack.m_41786_(), Component.m_237113_((String)steps).m_130940_(ChatFormatting.GRAY));
                }
                button.m_257544_(MultilineTooltip.create(tooltip));
                if (this.lastFocused == null && itemStack.m_150930_(this.sourceItem.m_41720_())) {
                    this.lastFocused = button;
                }
                this.layout.addWidget((AbstractWidget)button);
                if ((curX += step) < xStart + itemsPerLine * step) continue;
                curX = xStart;
                curY += step;
            }
        }
        if (this.inContainer) {
            int n = this.f_96543_ / 2;
            y = this.f_96544_ / 2;
            anchor = new Vector2f(0.5f, 0.5f);
        } else {
            if (this.slotIndex == 40) {
                HumanoidArm humanoidarm = player.m_5737_().m_20828_();
                if (humanoidarm == HumanoidArm.LEFT) {
                    int n = this.f_96543_ / 2 - 91 - 29 + 11;
                } else {
                    int n = this.f_96543_ / 2 + 91 + 17;
                }
            } else {
                int n = this.f_96543_ / 2 - 91 + 11 + player.m_150109_().f_35977_ * 20;
            }
            y = this.f_96544_ - 24;
            anchor = new Vector2f(0.5f, 1.0f);
        }
        this.layout.bind(this, new Vector2i((int)var9_18, y), anchor);
        if (this.lastFocused != null) {
            this.moveMouseOn(this.lastFocused);
        }
        Rect2i bounds = this.layout.bounds();
        StringWidget dummySpacer = new StringWidget(bounds.m_110085_() - 2, bounds.m_110086_() - 2, 10000, 10000, (Component)Component.m_237119_(), this.getMinecraft().f_91062_);
        this.forcedTooltipPositioner = new BelowOrAboveWidgetTooltipPositioner((AbstractWidget)dummySpacer);
    }

    private void moveMouseOn(AbstractWidget button) {
        this.m_7522_((GuiEventListener)button);
        Window window = Objects.requireNonNull(this.f_96541_.m_91268_());
        double scale = window.m_85449_();
        GLFW.glfwSetCursorPos((long)window.m_85439_(), (double)((double)(button.m_252754_() + 15) * scale), (double)((double)(button.m_252907_() + 15) * scale));
    }

    private void longPress(ItemButton button, CConvertItemPacket.Entry entry) {
        boolean convertOne = ConvertScreen.m_96637_();
        if (convertOne) {
            this.shortPress(button, entry);
        } else if ((!this.inContainer || Objects.requireNonNull(this.f_96541_.f_91074_).f_36096_ instanceof InventoryMenu) && button.pressTime() >= 15) {
            Item from = this.getSourceItem().m_41720_();
            CConvertItemPacket.send(false, this.slotIndex, entry, from, CConvertItemPacket.Action.CONVERT_FAMILY);
            this.m_7379_();
        }
    }

    private void shortPress(ItemButton button, CConvertItemPacket.Entry entry) {
        LocalPlayer player = Objects.requireNonNull(this.f_96541_.f_91074_);
        boolean creative = player.m_7500_();
        ItemStack sourceItem = this.getSourceItem();
        boolean convertOne = ConvertScreen.m_96637_();
        if (convertOne && !creative && sourceItem.m_41613_() <= 1) {
            this.m_7379_();
        }
        Item from = sourceItem.m_41720_();
        Item to = button.item().m_41720_();
        if (!(creative && convertOne || from != to)) {
            return;
        }
        this.chosenItems.add(to);
        if (this.inCreativeContainer && convertOne) {
            CConvertItemPacket.send(false, -500, entry, from, CConvertItemPacket.Action.CONVERT_ONE);
        } else if (this.inCreativeContainer) {
            Objects.requireNonNull(this.slot);
            ItemStack newItem = to.m_7968_();
            newItem.m_41764_(this.slot.m_7993_().m_41613_());
            newItem.m_41754_(5);
            this.slot.m_269060_(newItem);
            NonNullList slots = player.f_36095_.f_38839_;
            for (int i = 0; i < slots.size(); ++i) {
                if (((Slot)slots.get(i)).m_7993_() != newItem) continue;
                Objects.requireNonNull(this.f_96541_.f_91072_).m_105241_(newItem, i);
                CConvertItemPacket.playPickupSound((Player)player);
                break;
            }
        } else {
            CConvertItemPacket.send(this.inContainer, this.slotIndex, entry, from, convertOne ? CConvertItemPacket.Action.CONVERT_ONE : CConvertItemPacket.Action.CONVERT_ALL);
        }
    }

    public void m_86600_() {
        this.openProgress.tickChaser();
        if (!this.isClosing() && !this.chosenItems.contains(this.getSourceItem().m_41720_())) {
            this.m_7379_();
        }
    }

    public void m_7522_(@Nullable GuiEventListener listener) {
        if (listener instanceof ItemButton) {
            ItemButton button = (ItemButton)listener;
            this.lastFocused = button;
        }
        super.m_7522_(listener);
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        Rect2i bounds;
        Rect2i tolerance;
        if (super.m_6375_(pMouseX, pMouseY, pButton)) {
            return true;
        }
        if (pButton == 0 && !(tolerance = new Rect2i((bounds = this.layout.bounds()).m_110085_() - 10, bounds.m_110086_() - 10, bounds.m_110090_() + 20, bounds.m_110091_() + 20)).m_110087_((int)pMouseX, (int)pMouseY)) {
            this.m_7379_();
            return true;
        }
        return false;
    }

    public boolean m_6050_(double mouseX, double mouseY, double scrollY) {
        if (scrollY == 0.0) {
            return false;
        }
        int index = -1;
        List<AbstractWidget> widgets = this.layout.widgets();
        if (widgets.isEmpty()) {
            return false;
        }
        if (this.lastFocused != null) {
            index = widgets.indexOf(this.lastFocused);
        }
        if (index == -1 && scrollY > 0.0) {
            index = widgets.size();
        }
        if ((index += scrollY > 0.0 ? -1 : 1) < 0) {
            index = widgets.size() - 1;
        } else if (index >= widgets.size()) {
            index = 0;
        }
        this.lastFocused = widgets.get(index);
        this.moveMouseOn(this.lastFocused);
        return true;
    }

    public void m_88315_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        Objects.requireNonNull(this.f_96541_);
        PoseStack pose = pGuiGraphics.m_280168_();
        this.layout.update();
        Vector2i pos = this.layout.getAnchoredPos();
        float openValue = this.openProgress.getValue(pPartialTick);
        pose.m_85836_();
        pose.m_252880_((float)pos.x, (float)pos.y, 0.0f);
        pose.m_85841_(openValue, openValue, openValue);
        pose.m_252880_((float)(-pos.x), (float)(-pos.y), 0.0f);
        if (this.inContainer) {
            Rect2i bounds = this.layout.bounds();
            pGuiGraphics.m_280027_(new ResourceLocation("textures/gui/demo_background.png"), bounds.m_110085_() - 2, bounds.m_110086_() - 2, bounds.m_110090_() + 4, bounds.m_110091_() + 4, 4, 4, 248, 166, 0, 0);
        }
        super.m_88315_(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        pose.m_85849_();
    }

    public void m_262861_(List<FormattedCharSequence> list, ClientTooltipPositioner tooltipPositioner, boolean force) {
        float openValue = this.openProgress.getValue(Objects.requireNonNull(this.f_96541_).getPartialTick());
        if (openValue > 0.95f) {
            super.m_262861_(list, this.forcedTooltipPositioner, force);
        }
    }

    public void m_7379_() {
        this.openProgress.chase(0.0, 0.8, LerpedFloat.Chaser.EXP);
        lingeringScreen = this;
        super.m_7379_();
        if (this.inContainer) {
            GLFW.glfwSetCursorPos((long)this.f_96541_.m_91268_().m_85439_(), (double)this.originalMousePos.x, (double)this.originalMousePos.y);
        }
    }

    public boolean isClosing() {
        return this.openProgress.getChaseTarget() == 0.0f;
    }

    public boolean m_7043_() {
        return false;
    }

    public static void renderLingering(GuiGraphics pGuiGraphics) {
        if (lingeringScreen == null) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91080_ != null || mc.m_91265_() != null || ConvertScreen.lingeringScreen.openProgress.settled()) {
            lingeringScreen = null;
            return;
        }
        lingeringScreen.m_88315_(pGuiGraphics, Integer.MAX_VALUE, Integer.MAX_VALUE, Objects.requireNonNull(mc).getPartialTick());
    }

    public static void tickLingering() {
        if (lingeringScreen != null) {
            lingeringScreen.m_86600_();
        }
    }
}

