/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.cannon_loading;

import com.simibubi.create.AllShapes;
import com.simibubi.create.content.contraptions.piston.MechanicalPistonBlock;
import com.simibubi.create.content.kinetics.base.DirectionalAxisKineticBlock;
import com.simibubi.create.foundation.block.IBE;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import rbasamoyai.createbigcannons.cannon_loading.CannonLoaderBlockEntity;
import rbasamoyai.createbigcannons.config.CBCConfigs;
import rbasamoyai.createbigcannons.index.CBCBlockEntities;
import rbasamoyai.createbigcannons.index.CBCBlocks;
import rbasamoyai.createbigcannons.remix.ContraptionRemix;

public class CannonLoaderBlock
extends DirectionalAxisKineticBlock
implements IBE<CannonLoaderBlockEntity> {
    public static final BooleanProperty MOVING = BooleanProperty.m_61465_((String)"moving");
    public static final DirectionProperty FACING = DirectionalAxisKineticBlock.FACING;

    public CannonLoaderBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)MOVING, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{MOVING});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext context) {
        return AllShapes.MECHANICAL_PISTON_EXTENDED.get((Direction)state.m_61143_((Property)FACING));
    }

    public static int maxAllowedLoaderLength() {
        return (Integer)CBCConfigs.server().kinetics.maxLoaderLength.get();
    }

    public Class<CannonLoaderBlockEntity> getBlockEntityClass() {
        return CannonLoaderBlockEntity.class;
    }

    public BlockEntityType<? extends CannonLoaderBlockEntity> getBlockEntityType() {
        return (BlockEntityType)CBCBlockEntities.CANNON_LOADER.get();
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        CannonLoaderBlock.destroyExtensionPoles(level, pos, state, !player.m_7500_());
        super.m_5707_(level, pos, state, player);
    }

    public static void destroyExtensionPoles(Level level, BlockPos pos, BlockState state, boolean dropBlocks) {
        BlockState block;
        BlockPos currentPos;
        int offset;
        dropBlocks &= level.m_46469_().m_46207_(GameRules.f_46136_);
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        BlockPos loaderHead = null;
        int maxPoles = CannonLoaderBlock.maxAllowedLoaderLength();
        for (offset = 1; offset < maxPoles; ++offset) {
            currentPos = pos.m_5484_(direction, offset);
            block = level.m_8055_(currentPos);
            if (MechanicalPistonBlock.isExtensionPole((BlockState)(block = ContraptionRemix.getInnerCannonState((LevelAccessor)level, block, currentPos, direction))) && direction.m_122434_() == ((Direction)block.m_61143_((Property)BlockStateProperties.f_61372_)).m_122434_()) continue;
            if (!CannonLoaderBlock.isLoaderHead(block) || block.m_61143_((Property)BlockStateProperties.f_61372_) != direction) break;
            loaderHead = currentPos;
            break;
        }
        if (loaderHead != null) {
            boolean dropBlocks1 = dropBlocks;
            BlockPos.m_121990_((BlockPos)pos, loaderHead).filter(p -> !p.equals((Object)pos)).forEach(p -> {
                if (!ContraptionRemix.removeCannonContentsOnBreak(level, p, dropBlocks1)) {
                    level.m_46961_(p, dropBlocks1);
                }
            });
        }
        for (offset = 1; offset < maxPoles; ++offset) {
            currentPos = pos.m_5484_(direction.m_122424_(), offset);
            block = level.m_8055_(currentPos);
            if (!MechanicalPistonBlock.isExtensionPole((BlockState)(block = ContraptionRemix.getInnerCannonState((LevelAccessor)level, block, currentPos, direction))) || direction.m_122434_() != ((Direction)block.m_61143_((Property)BlockStateProperties.f_61372_)).m_122434_()) break;
            if (ContraptionRemix.removeCannonContentsOnBreak(level, currentPos, dropBlocks)) continue;
            level.m_46961_(currentPos, dropBlocks);
        }
    }

    public static boolean isLoaderHead(BlockState state) {
        return CBCBlocks.WORM_HEAD.has(state) || CBCBlocks.RAM_HEAD.has(state);
    }
}

