/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.models.parts;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import traben.entity_model_features.models.animation.EMFAnimationEntityContext;
import traben.entity_model_features.models.parts.EMFModelPart;
import traben.entity_model_features.utils.EMFUtils;

public abstract class EMFModelPartWithState
extends EMFModelPart {
    public final Int2ObjectOpenHashMap<EMFModelState> allKnownStateVariants = new Int2ObjectOpenHashMap<EMFModelState>(){

        public EMFModelState get(int k) {
            if (!this.containsKey(k)) {
                EMFUtils.logWarn("EMFModelState variant with key " + k + " does not exist in part [" + EMFModelPartWithState.this.toStringShort() + "], returning copy of 0");
                this.put(k, EMFModelState.copy(this.get(0)));
            }
            return (EMFModelState)super.get(k);
        }
    };
    public int currentModelVariant = 0;
    Map<String, ModelPart> vanillaChildren = new HashMap<String, ModelPart>();
    Runnable startOfRenderRunnable = null;
    @NotNull
    EMFModelPart.Animator animationHolder = new EMFModelPart.Animator();

    public EMFModelPartWithState(List<ModelPart.Cube> cuboids, Map<String, ModelPart> children) {
        super(cuboids, children);
    }

    void receiveOneTimeRunnable(Runnable run) {
        this.startOfRenderRunnable = run;
        this.f_104213_.values().forEach(child -> {
            if (child instanceof EMFModelPartWithState) {
                EMFModelPartWithState emf = (EMFModelPartWithState)((Object)child);
                emf.receiveOneTimeRunnable(run);
            }
        });
    }

    @Override
    public void m_104306_(PoseStack matrices, VertexConsumer vertices, int light, int overlay, float red, float green, float blue, float alpha) {
        if (this.startOfRenderRunnable != null) {
            this.startOfRenderRunnable.run();
        }
        if (this.animationHolder != null && !EMFAnimationEntityContext.isEntityAnimPausedWrapped()) {
            this.animationHolder.run();
        }
        super.m_104306_(matrices, vertices, light, overlay, red, green, blue, alpha);
    }

    EMFModelState getCurrentState() {
        return new EMFModelState(this.m_233566_(), this.f_104212_, this.f_104213_, this.f_233553_, this.f_233554_, this.f_233555_, this.f_104207_, this.f_233556_, this.textureOverride, this.animationHolder);
    }

    EMFModelState getStateOf(ModelPart modelPart) {
        if (modelPart instanceof EMFModelPartWithState) {
            EMFModelPartWithState emf = (EMFModelPartWithState)modelPart;
            return new EMFModelState(modelPart.m_233566_(), modelPart.f_104212_, modelPart.f_104213_, modelPart.f_233553_, modelPart.f_233554_, modelPart.f_233555_, modelPart.f_104207_, modelPart.f_233556_, emf.textureOverride, emf.animationHolder);
        }
        return new EMFModelState(modelPart.m_233566_(), modelPart.f_104212_, new HashMap<String, ModelPart>(), modelPart.f_233553_, modelPart.f_233554_, modelPart.f_233555_, modelPart.f_104207_, modelPart.f_233556_, null, new EMFModelPart.Animator());
    }

    void setFromState(EMFModelState newState) {
        this.m_233560_(newState.defaultTransform());
        this.m_171322_(this.m_233566_());
        this.f_104212_ = newState.cuboids();
        this.f_104213_ = newState.variantChildren();
        this.f_233553_ = newState.xScale();
        this.f_233554_ = newState.yScale();
        this.f_233555_ = newState.zScale();
        this.f_104207_ = newState.visible();
        this.f_233556_ = newState.hidden();
        this.textureOverride = newState.texture();
        this.animationHolder = newState.animation();
    }

    protected void resetState() {
        this.setFromState((EMFModelState)this.allKnownStateVariants.get(this.currentModelVariant));
    }

    public void setVariantStateTo(int newVariant) {
        if (this.currentModelVariant != newVariant) {
            this.setFromState((EMFModelState)this.allKnownStateVariants.get(newVariant));
            this.currentModelVariant = newVariant;
            for (ModelPart part : this.f_104213_.values()) {
                if (!(part instanceof EMFModelPartWithState)) continue;
                EMFModelPartWithState p3 = (EMFModelPartWithState)part;
                p3.setVariantStateTo(newVariant);
            }
        }
    }

    public void copyVariantTo(int from, int to) {
        this.allKnownStateVariants.putIfAbsent(to, (Object)EMFModelState.copy((EMFModelState)this.allKnownStateVariants.get(from)));
        for (ModelPart value : this.f_104213_.values()) {
            if (!(value instanceof EMFModelPartWithState)) continue;
            EMFModelPartWithState p3 = (EMFModelPartWithState)value;
            p3.copyVariantTo(from, to);
        }
    }

    public record EMFModelState(PartPose defaultTransform, List<ModelPart.Cube> cuboids, Map<String, ModelPart> variantChildren, float xScale, float yScale, float zScale, boolean visible, boolean hidden, ResourceLocation texture, EMFModelPart.Animator animation) {
        public static EMFModelState copy(EMFModelState copyFrom) {
            PartPose trans = copyFrom.defaultTransform();
            EMFModelPart.Animator animator = new EMFModelPart.Animator();
            animator.setAnimation(copyFrom.animation().getAnimation());
            return new EMFModelState(PartPose.m_171423_((float)trans.f_171405_, (float)trans.f_171406_, (float)trans.f_171407_, (float)trans.f_171408_, (float)trans.f_171409_, (float)trans.f_171410_), new ArrayList<ModelPart.Cube>(copyFrom.cuboids()), new HashMap<String, ModelPart>(copyFrom.variantChildren()), copyFrom.xScale(), copyFrom.yScale(), copyFrom.zScale(), copyFrom.visible(), copyFrom.hidden(), copyFrom.texture(), animator);
        }
    }
}

